/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.channelAction.classic.sharing;

import java.io.IOException;
import java.io.StringReader;

import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.config.Space;
import org.esupportail.portal.channels.CStockage.exception.PropertiesException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Id: SpaceTool.java,v 1.0 5 janv. 2005
 * Copyright (c) 2005 Esup Portail (www.esup-portail.org)
 * Classes: SpaceTool
 * Original Author: Yohan Colmant
 * Object used to manage a Space while the sharing of spaces by users
 */
public class SpaceTool {


	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(SpaceTool.class);
	
	
	
	/**
	 * The Space we are using
	 */
	private Space space;
	
	
	
	

	/**
	 * Constructor
	 * @param stringToParse the String we want to parse
	 */
	public SpaceTool(String stringToParse) {

		Digester digester = new Digester();
		digester.setValidating(false);
		digester.push(this);		
		
		/*
		 * The space
		 */
		digester.addObjectCreate("SPACE",Space.class);		
		
		// digester.addSetProperties("SPACE","key","key");
		//digester.addSetProperties("SPACE","label", "label");
		//digester.addSetProperties("SPACE","url", "url");
		//digester.addSetProperties("SPACE","path", "path");
		digester.addSetProperties("SPACE","serverType", "serverType");
		digester.addSetProperties("SPACE","actionType", "actionType");
		digester.addSetProperties("SPACE","authenticationMode", "authenticationMode");
		digester.addSetProperties("SPACE","login", "loginFromTheConfigurationFile");
		digester.addSetProperties("SPACE","password", "password");
		
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","manageAcl", "manageAcl");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","aclNamespace", "aclNamespace");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","aclUserPrefix", "aclUserPrefix");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","aclGroupPrefix", "aclGroupPrefix");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","aclUportalGroup", "aclUportalGroup");
		
		digester.addSetProperties("SPACE","cifsDomain", "cifsDomain");
		digester.addSetProperties("SPACE","cifsResolveOrder", "cifsResolveOrder");
		digester.addSetProperties("SPACE","cifsDisablePlainTextPassword", "cifsDisablePlainTextPassword");
		
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","nfsUidNumber", "nfsUidNumber");
		digester.addSetProperties("CHANNEL_CONFIGURATION/SPACES/SPACE","nfsGidNumber", "nfsGidNumber");
		
		digester.addSetNext("SPACE", "setSpace");
		
		
		
		StringReader sr = new StringReader(stringToParse);		
		InputSource inSource = new InputSource(sr);

		try {
			//parse config file
			digester.parse(inSource);							
		}
		catch (IOException e) {				
			log.error("SpaceTool :: "+ e.toString());
		}
		catch (SAXException e) {				
			log.error("SpaceTool :: " + e.toString());
		}
	}
	
	
	

	/**
	 * return the space
	 * @return the space
	 */
	public Space getSpace() {	
		return space;
	}

	
	
	/**
	 * add a new space to the list
	 * @param space the space to add
	 */
	public void setSpace(Space space) {
		this.space = space;
		this.space.setPersonnalSpace(true);
	}
	
	
	
	
	/**
	 * Get an xml form of a space
	 * @param space the Space we want to export into xml
	 * @return an xml form of a space
	 */
	public static String getXmlFromSpace(Space space) throws PropertiesException {
		
		StringBuffer xml = new StringBuffer();		
		xml.append("<SPACE");
		/*
		// label
		if (newLabel!=null) {
			xml.append(" label=\""+newLabel+"\"");
		}
		else {
			String label = space.getLabel();
			if (label!=null)
				xml.append(" label=\""+label+"\"");
		}
*/
		/*
		// url
		try {
			String url = space.getUrl();
			if (url!=null)
				xml.append(" url=\""+url+"\"");
		}
		catch(PropertiesException e) {
			if (log.isDebugEnabled())
				log.error("getXmlFromSpace :: " + e.toString());
		}
		*/
		/*
		// path
		String path = space.getPath();
		if (path!=null)
			xml.append(" path=\""+path+"\"");
*/
		
		// serverType
		String serverType = space.getServerType();
		if (serverType!=null)
			xml.append(" serverType=\""+serverType+"\"");

		// actionType
		String actionType = space.getActionType();
		if (actionType!=null)
			xml.append(" actionType=\""+actionType+"\"");

		// authenticationMode
		String authenticationMode = space.getAuthenticationMode();
		if (authenticationMode!=null)
			xml.append(" authenticationMode=\""+authenticationMode+"\"");

		// login
		if (authenticationMode.equals(Space.AUTH_TRUSTED) || authenticationMode.equals(Space.AUTH_ASKED)) {

			if (space.isLoginIsFromConfigurationFile()) {
				String login = space.getInitialLoginFromTheConfigurationFile();
				xml.append(" login=\""+login+"\"");
			}
			
		}
		
		// password
		if (authenticationMode.equals(Space.AUTH_TRUSTED)) {
			try {				
				String trustedPassword = space.getPassword();
				if (trustedPassword!=null)
					xml.append(" password=\""+trustedPassword+"\"");
			}
			catch(PropertiesException e) {
				if (log.isDebugEnabled())
					log.error("getXmlFromSpace :: " + e.toString());
			}
			
		}
		
		// manageAcl
		boolean manageAcl = space.managesAcl();
		xml.append(" manageAcl=\""+manageAcl+"\"");

		// aclNamespace
		String aclNamespace = space.getAclNamespace();
		if (aclNamespace!=null)
			xml.append(" aclNamespace=\""+aclNamespace+"\"");

		// aclUserPrefix
		String aclUserPrefix = space.getAclUserPrefix();
		if (aclUserPrefix!=null)
			xml.append(" aclUserPrefix=\""+aclUserPrefix+"\"");

		// aclGroupPrefix
		String aclGroupPrefix = space.getAclGroupPrefix();
		if (aclGroupPrefix!=null)
			xml.append(" aclGroupPrefix=\""+aclGroupPrefix+"\"");
		
		// aclUportalGroup
		String aclUportalGroup = space.getAclUportalGroup();
		if (aclUportalGroup!=null)
			xml.append(" aclUportalGroup=\""+aclUportalGroup+"\"");

		
		// cifsDomain
		String cifsDomain = space.getCifsDomain();
		if (cifsDomain!=null)
			xml.append(" cifsDomain=\""+cifsDomain+"\"");

		// cifsResolveOrder
		String cifsResolveOrder = space.getCifsResolveOrder();
		if (cifsResolveOrder!=null)
			xml.append(" cifsResolveOrder=\""+cifsResolveOrder+"\"");

		// cifsDisablePlainTextPassword
		String cifsDisablePlainTextPassword = space.getCifsDisablePlainTextPassword();
		if (cifsDisablePlainTextPassword!=null)
			xml.append(" cifsDisablePlainTextPassword=\""+cifsDisablePlainTextPassword+"\"");
		
		// nfsUidNumber
		String nfsUidNumber = space.getNfsUidNumber();
		if (nfsUidNumber!=null)
			xml.append(" nfsUidNumber=\""+nfsUidNumber+"\"");

		// nfsGidNumber
		String nfsGidNumber = space.getNfsGidNumber();
		if (nfsGidNumber!=null)
			xml.append(" nfsGidNumber=\""+nfsGidNumber+"\"");
		
		
		xml.append("/>");				
		return xml.toString();
	}
	
	
	
	
	
	
}
