/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.channelAction.AbstractChannelAction;
import org.esupportail.portal.channels.CStockage.channelAction.BufferAction;
import org.esupportail.portal.channels.CStockage.exception.ApplicationException;
import org.esupportail.portal.channels.CStockage.exception.BadConnexionParameters;
import org.esupportail.portal.channels.CStockage.exception.PropertiesException;
import org.esupportail.portal.channels.CStockage.exception.ServerException;
import org.esupportail.portal.channels.CStockage.exception.ChannelException;
import org.esupportail.portal.channels.CStockage.provider.access.ServerAccess;
import org.jasig.portal.security.IPerson;

/**
 * Id: Space.java,v 1.0 9 juil. 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: Space<br/>
 * Original Author: Yohan Colmant<br/>
 * This represents a file space on the server<br/>
 */
public class Space {


	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(Space.class);
	

	/**
	 * CAS authentication
	 */
	public static final String AUTH_CAS = "cas";
	
	/**
	 * TRUSTED authentication
	 */
	public static final String AUTH_TRUSTED = "trusted";
	
	/**
	 * ASKED authentication
	 */
	public static final String AUTH_ASKED = "asked";
	
	
	
	
	
	
	
	/**
	 * The space key
	 */
	private String key;
	
	/**
	 * The label of this space
	 */
	private String label;
	
	/**
	 * The server url
	 */
	private String url;
	
	
	
	/**
	 * The server type
	 */
	private String serverType;
		
	/**
	 * The channel action type
	 */
	private String actionType;
	
	
	
	/**
	 * The class name used to manage the actions
	 */
	private String channelActionClass;		

	/**
	 * The class name used to manage the actions
	 */
	private String serverAccessClass;


	
	
	/**
	 * The authentication mode. "cas" or "trusted"
	 */
	private String authenticationMode;
	
	/**
	 * The login if trusted authentication
	 */
	private String login;

	/**
	 * The login if trusted authentication
	 */
	private String initialLoginFromTheConfigurationFile;
	
	/**
	 * If the login is from the configuration file
	 */
	private boolean loginIsFromConfigurationFile = false;
	
	
	/**
	 * The password if trusted authentication, or is asked authentication
	 */
	private String password;
	
	
	/**
	 * If this space can support the document sharing
	 */
	private String enableSharing;
	
	/**
	 * The path in the initial configuration file
	 */
	private String initialPath;

	/**
	 * The regexp used to apply on the path
	 */
	private String pathRegexp;

	/**
	 * The separator used when the regexp is in few parts
	 */
	private String pathRegexpSeparator;

	/**
	 * The currentPath used
	 */
	private Vector currentPath = new Vector();
	
	/**
	 * The attribute used to access the server
	 */
	private ServerAccess access;
	
	/**
	 * To manage the actions in funtion of the access class
	 */
	private AbstractChannelAction channelAction;
	
	

	/**
	 * The namespace used for the metadata
	 */
	private String metadataNamespace;
	
	/**
	 * If this space manage the acl for the sharing or for the injac mode
	 */
	private boolean manageAcl = false;
	
	
	
	/**
	 * The ACL namespace
	 */
	private String aclNamespace;
	
	/**
	 * The user prefix for the ACL
	 */
	private String aclUserPrefix;
	
	/**
	 * The group prefix for the ACL
	 */
	private String aclGroupPrefix;

	/**
	 * The uPortal group node for the ACL
	 */
	private String aclUportalGroup;
	
	
	
	
	
	/**
	 * The authorization list for this space
	 */
	private ArrayList authorizations = new ArrayList();
	
	
	
	/**
	 * The cifs domain
	 */
	private String cifsDomain;
	
	/**
	 * The Cifs resolve order
	 */
	private String cifsResolveOrder;
	
	/**
	 * The cifs disable plain text password
	 */
	private String cifsDisablePlainTextPassword;
	
	
	

	/**
	 * The NFS Uid Number
	 */
	public String nfsUidNumber;
	/**
	 * The NFS Gid Number
	 */
	private String nfsGidNumber;
	
	
	
	
	/**
	 * If this space is a personnal one
	 */
	private boolean personnalSpace = false;
	
	/**
	 * If the user can write into this space
	 */
	private boolean canWrite = true;
	
	/**
	 * Used for shared spaces, this attribute is the person who share the space
	 */
	private String owner;
	
	/**
	 * The target for the sharing: the user key or the group key
	 */
	private String targetOfSharing;
	
	/**
	 * Attribute used when we work with a shared space. the value is true if the space has been shared for one user, false if it is for a group
	 */
	private boolean sharedForTheUser = false;
	
	/**
	 * The ID of this space in the database when we share it
	 */
	private String idInDatabase;
	
	
	
	
	
	
	
	
	
	
	
	/**
	 * @return Returns the manageAcl.
	 */
	public boolean managesAcl() throws PropertiesException {		
		if (manageAcl && !supportsAcl()) {
			log.error("managesAcl :: there is no acl access parameters set for space "+getKey());
			throw new PropertiesException();
		}
		return manageAcl && supportsAcl();
	}
	
	/**
	 * @param manageAcl The manageAcl to set.
	 */
	public void setManageAcl(String manageAcl) {
		if (manageAcl.equals("true"))
			this.manageAcl = true;
		else this.manageAcl = false;
	}
	
	/**
	 * @return Returns the targetOfSharing.
	 */
	public String getTargetOfSharing() {
		return targetOfSharing;
	}
	/**
	 * @param targetOfSharing The targetOfSharing to set.
	 */
	public void setTargetOfSharing(String targetOfSharing) {
		this.targetOfSharing = targetOfSharing;
	}
	
	/**
	 * @return Returns the idInDatabase.
	 */
	public String getIdInDatabase() {
		return idInDatabase;
	}
	/**
	 * @param idInDatabase The idInDatabase to set.
	 */
	public void setIdInDatabase(String idInDatabase) {
		this.idInDatabase = idInDatabase;
	}
	
	/**
	 * @return Returns the sharedForTheUser.
	 */
	public boolean isSharedForTheUser() {
		return sharedForTheUser;
	}
	/**
	 * @param sharedForTheUser The sharedForTheUser to set.
	 */
	public void setSharedForTheUser(boolean sharedForTheUser) {
		this.sharedForTheUser = sharedForTheUser;
	}
	
	
	/**
	 * @param canWrite The canWrite to set.
	 */
	public void setCanWrite(boolean canWrite) {
		this.canWrite = canWrite;
	}
	/**
	 * @return Returns the canWrite.
	 */
	public boolean userCanWrite() {
		return canWrite;
	}

	
	
	/**
	 * @return Returns the owner.
	 */
	public String getOwner() {
		return owner;
	}
	/**
	 * @param owner The owner to set.
	 */
	public void setOwner(String owner) {
		this.owner = owner;
	}
	
	
	
	/**
	 * @return Returns the sharing.
	 */
	public boolean isSharing() {		
		return enableSharing !=null && enableSharing.equals("true");
	}
	
	

	/**
	 * @param enableSharing The enableSharing to set.
	 */
	public void setEnableSharing(String enableSharing) {		
		this.enableSharing = enableSharing;
	}
	
	
	/**
	 * return the authorization list
	 * @return the authorization list
	 */
	public ArrayList getAuthorization() {			
		return authorizations;
	}

	/**
	 * add a new authorization to the list
	 * @param authorization the authorization to add
	 */
	public void setAuthorization(AuthorizationSpaceParameter authorization) {		
		// add this authorization
		authorizations.add(authorization);
	}
	
	

	
	/**
	 * @return Returns the metadataNamespace.
	 */
	public String getMetadataNamespace() {
		return metadataNamespace;
	}
	/**
	 * @param metadataNamespace The metadataNamespace to set.
	 */
	public void setMetadataNamespace(String metadataNamespace) {
		this.metadataNamespace = metadataNamespace;
	}
	
	
	
	
	
	/**
	 * @return Returns the cifsDisablePlainTextPassword.
	 */
	public String getCifsDisablePlainTextPassword() {
		return cifsDisablePlainTextPassword;
	}
	/**
	 * @param cifsDisablePlainTextPassword The cifsDisablePlainTextPassword to set.
	 */
	public void setCifsDisablePlainTextPassword(
			String cifsDisablePlainTextPassword) {
		this.cifsDisablePlainTextPassword = cifsDisablePlainTextPassword;
	}
	/**
	 * @return Returns the cifsDomain.
	 */
	public String getCifsDomain() {
		return cifsDomain;
	}
	
	
	
	
	/**
	 * @param cifsDomain The cifsDomain to set.
	 */
	public void setCifsDomain(String cifsDomain) {
		this.cifsDomain = cifsDomain;
	}
	/**
	 * @return Returns the cifsResolveOrder.
	 */
	public String getCifsResolveOrder() {
		return cifsResolveOrder;
	}
	/**
	 * @param cifsResolveOrder The cifsResolveOrder to set.
	 */
	public void setCifsResolveOrder(String cifsResolveOrder) {
		this.cifsResolveOrder = cifsResolveOrder;
	}
	/**
	 * @return Returns the actionType.
	 */
	public String getActionType() {
		return actionType;
	}
	/**
	 * @param actionType The actionType to set.
	 */
	public void setActionType(String actionType) {
		this.actionType = actionType;
	}
	/**
	 * @return Returns the serverType.
	 */
	public String getServerType() {
		return serverType;
	}
	/**
	 * @param serverType The serverType to set.
	 */
	public void setServerType(String serverType) {
		this.serverType = serverType;
	}
	/**
	 * @return Returns the aclUportalGroup.
	 */
	public String getAclUportalGroup() {
		return aclUportalGroup;
	}
	/**
	 * @param aclUportalGroup The aclUportalGroup to set.
	 */
	public void setAclUportalGroup(String aclUportalGroup) {
		this.aclUportalGroup = aclUportalGroup;
	}
	/**
	 * @return Returns the aclGroupPrefix.
	 */
	public String getAclGroupPrefix() {
		return aclGroupPrefix;
	}
	/**
	 * @param aclGroupPrefix The aclGroupPrefix to set.
	 */
	public void setAclGroupPrefix(String aclGroupPrefix) {
		this.aclGroupPrefix = aclGroupPrefix;
	}
	/**
	 * @return Returns the aclNamespace.
	 */
	public String getAclNamespace() {
		return aclNamespace;
	}
	/**
	 * @param aclNamespace The aclNamespace to set.
	 */
	public void setAclNamespace(String aclNamespace) {
		this.aclNamespace = aclNamespace;
	}
	/**
	 * @return Returns the supportAcl.
	 */
	private boolean supportsAcl() {
		if (aclNamespace==null || aclUserPrefix == null || aclGroupPrefix == null || aclUportalGroup == null)
			return false;				
		else return true;			
	}
	
	/**
	 * @return Returns the aclUserPrefix.
	 */
	public String getAclUserPrefix() {
		return aclUserPrefix;
	}
	/**
	 * @param aclUserPrefix The aclUserPrefix to set.
	 */
	public void setAclUserPrefix(String aclUserPrefix) {
		this.aclUserPrefix = aclUserPrefix;
	}
	/**
	 * @return Returns the personnalSpace.
	 */
	public boolean isPersonnalSpace() {
		return personnalSpace;
	}
	/**
	 * @param personnalSpace The personnalSpace to set.
	 */
	public void setPersonnalSpace(boolean personnalSpace) {
		this.personnalSpace = personnalSpace;
	}
	/**
	 * If the selected authentication is CAS
	 * @return trus is cas is selected
	 */
	public boolean isCasAuthentication() throws PropertiesException {
		if (authenticationMode==null) {
			log.error("isCasAuthentication :: there is no authentication mode set for space "+getKey());
			throw new PropertiesException();
		}
		return authenticationMode.equals(AUTH_CAS);
	}
	/**
	 * If the selected authentication is TRUSTED
	 * @return true if trusted is selected
	 */
	public boolean isTrustedAuthentication() throws PropertiesException {
		if (authenticationMode==null) {
			log.error("isTrustedAuthentication :: there is no authentication mode set for space "+getKey());
			throw new PropertiesException();
		}
		return authenticationMode.equals(AUTH_TRUSTED);
	}
	/**
	 * If the selected authentication is ASKED
	 * @return true if asked is selected
	 */
	public boolean isAskedAuthentication() throws PropertiesException {
		if (authenticationMode==null) {
			log.error("isAskedAuthentication :: there is no authentication mode set for space "+getKey());
			throw new PropertiesException();
		}
		return authenticationMode.equals(AUTH_ASKED);
	}
	

	/**
	 * @return Returns the login.
	 */
	public String getLogin() {
		return login;
	}
	/**
	 * @param login The login to set.
	 */
	public void setLogin(String login) {
		this.login = login;
	}
	/**
	 * @param loginFromTheConfigurationFile The login to set.
	 */
	public void setLoginFromTheConfigurationFile(String loginFromTheConfigurationFile) {
		this.login = loginFromTheConfigurationFile;
		this.initialLoginFromTheConfigurationFile = loginFromTheConfigurationFile;
		this.loginIsFromConfigurationFile = true;
	}
	
	
	/**
	 * @return Returns the loginIsFromConfigurationFile.
	 */
	public boolean isLoginIsFromConfigurationFile() {
		return loginIsFromConfigurationFile;
	}
	
	/**
	 * @return Returns the initialLoginFromTheConfigurationFile.
	 */
	public String getInitialLoginFromTheConfigurationFile() {
		return initialLoginFromTheConfigurationFile;
	}
	/**
	 * @param loginIsFromConfigurationFile The loginIsFromConfigurationFile to set.
	 */
	/*public void setLoginIsFromConfigurationFile(
			boolean loginIsFromConfigurationFile) {
		this.loginIsFromConfigurationFile = loginIsFromConfigurationFile;
	}*/
	/**
	 * @return Returns the login used with this space.
	 */
	/*public String getUsedLogin() {
		if (trustedLogin!=null)
			return trustedLogin;
		else return usedLogin;
	}*/	
	/**
	 * @param usedLogin The usedLogin to set.
	 */
	/*public void setUsedLogin(String usedLogin) {
		this.usedLogin = usedLogin;
	}*/
	
	
	
	/**
	 * @return Returns the trustedLogin.
	 */
	/*public String getTrustedLogin() {
		return trustedLogin;
	}*/
	/**
	 * @param trustedLogin The trustedLogin to set.
	 */
	/*public void setTrustedLogin(String trustedLogin) {
		this.trustedLogin = trustedLogin;
	}*/
	
	
	
	/**
	 * @return Returns the password.
	 */
	public String getPassword() throws PropertiesException {
		if (isTrustedAuthentication() && password==null) {
			log.error("getPassword :: there is no password set for trusted authentication for space "+getKey());
			throw new PropertiesException();
		}
		return password;
	}
	/**
	 * @param password The trustedPassword to set.
	 */
	public void setPassword(String password) {
		this.password = password;
	}
	/**
	 * @return Returns the url.
	 */
	public String getUrl() throws PropertiesException {
		if (url==null) {
			log.error("getUrl :: there is no URL set for space "+getKey());
			throw new PropertiesException();
		}
		return url;
	}
	/**
	 * @param url The url to set.
	 */
	public void setUrl(String url) {
		this.url = url;
	}
	/**
	 * @param authenticationMode The authenticationMode to set.
	 */
	public void setAuthenticationMode(String authenticationMode) {
		this.authenticationMode = authenticationMode;
	}
	/**
	 * @return Returns the authenticationMode.
	 */
	public String getAuthenticationMode() {
		return authenticationMode;
	}
	
	/**
	 * @return Returns the serverAccessClass.
	 */
	public String getServerAccessClass() {
		return serverAccessClass;
	}
	/**
	 * @param serverAccessClass The serverAccessClass to set.
	 */
	public void setServerAccessClass(String serverAccessClass) {
		this.serverAccessClass = serverAccessClass;
	}
	
	

	/**
	 * @return Returns the accessClass.
	 */
	public String getChannelActionClass() {
		return channelActionClass;
	}
	/**
	 * @param channelActionClass The channelActionClass to set.
	 */
	public void setChannelActionClass(String channelActionClass) {
		this.channelActionClass = channelActionClass;
	}
	
	
	
	/**
	 * @return Returns the key.
	 */
	public String getKey() {
		return key;
	}
	
	/**
	 * @param key The key to set.
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * @return Returns the label.
	 */
	public String getLabel() {
		return label;
	}
	
	/**
	 * @param label The label to set.
	 */
	public void setLabel(String label) {
		this.label = label;
	}
	
	
	
	
	
	/**
	 * @return Returns the pathRegexp.
	 */
	public String getPathRegexp() {
		return pathRegexp;
	}
	/**
	 * @param pathRegexp The pathRegexp to set.
	 */
	public void setPathRegexp(String pathRegexp) {
		this.pathRegexp = pathRegexp;
	}
	/**
	 * @return Returns the pathRegexpSeparator.
	 */
	public String getPathRegexpSeparator() {
		return pathRegexpSeparator;
	}
	/**
	 * @param pathRegexpSeparator The pathRegexpSeparator to set.
	 */
	public void setPathRegexpSeparator(String pathRegexpSeparator) {
		this.pathRegexpSeparator = pathRegexpSeparator;
	}
	
	
	
	/**
	 * @param path The path to set.
	 */
	public void setPath(String path) {
		
		this.initialPath = path;
		
		// set the vector
		currentPath = initPath(path);
	}

	
	
	/**
	 * @param path The path to set.
	 */
	private Vector initPath(String path) {
		
		// set the vector
		Vector currentPath = new Vector();		
		
		String initPath = new String(path);		
		if (initPath.startsWith("/"))
			initPath = initPath.substring(1, initPath.length());		
		if (initPath.endsWith("/"))
			initPath = initPath.substring(0, initPath.length()-1);
				
		// we add it to the currentPath
		currentPath.addElement(initPath);	
		
		return currentPath;
	}
	
	
	
	/**
	 * @return Returns the path.
	 */
	public String getPath() {	
		return getPath(currentPath);				
	}
	
	
	
	
	
	/**
	 * Return the path due to a current path vector
	 * @param currentPath
	 * @return the space current path
	 */
	private String getPath(Vector currentPath) {
		StringBuffer pathh = new StringBuffer("/"); 
		for (int i=0; i<currentPath.size(); i++) {
			String s = (String)currentPath.elementAt(i);
			if (!s.equals("")) {
				pathh.append(s);
				pathh.append("/");
			}			
		}
		
		return pathh.toString();	
	}
	
	
	
	
	
	/**
	 * We check if the is a {...} form in the path. If yes, we replace by the real value
	 * @param person the connected person
	 */
	public void checkPath(IPerson person) {
		 
		String formLoginAttribute = "storageFormLogin";
		
		
		// if there are {} in the initial path, for each element between {}, we replace by the real value
		String path = "";
		String[] tab = initialPath.split("\\{");
		for (int i=0; i<tab.length; i++) {
			String s = tab[i];
			int index = s.indexOf("}");
			
			// if there is a "}"
			if (index==-1) {
				path = path+s;
			}
			
			// there is no "}"
			else {
				String attributeName = s.substring(0, index);
				String endOfString = s.substring(index+1, s.length());
				
				// replace the attribute
				String value = "";
				if (attributeName.equals(formLoginAttribute)) {
					value = getLogin();
				}
				else {
					value = (String)person.getAttribute(attributeName);
				}
				
				// add the attribute value
				path = path+value;
				
				// add the end of the string
				path = path+endOfString;
			}
		}
		
		// we check if the path is a regular expression
		if (pathRegexp!=null) {
			
			String[] regexps = null;
			if (pathRegexpSeparator!=null) {
				regexps = pathRegexp.split(pathRegexpSeparator);
			}
			else {
				regexps = new String[1];
				regexps[0] = pathRegexp;
			}
			
			StringBuffer result = new StringBuffer();
			
 			for (int i = 0; i < regexps.length; i++) {
				
				Pattern p = Pattern.compile(regexps[i], Pattern.CASE_INSENSITIVE);
				Matcher m = p.matcher(path);
				
				result.append(m.replaceAll("$1"));				
			}
			
			path = result.toString();
		}
		
		
		
		// we fix the currentPath vector
		currentPath = initPath(path);		
		
		// log
		if (log.isDebugEnabled()) {
			log.debug("checkPath"+" :: currentPath = "+currentPath);
		}
 	}
	
	
	
	/**
	 * we look for a {...} form in the attribute. If yes, we replace it with the real value
	 * @param attributeName to check 
	 * @param person uPortal person object
	 */
	public void checkAttribute(String attributeName, IPerson person) {
		
		Class c = this.getClass();
		String value;
		try {
			// we use java refexion to find getter and setter for attributeName
		    BeanInfo bi = Introspector.getBeanInfo(c);
		    PropertyDescriptor[] propertyDescriptor = bi.getPropertyDescriptors();
		    for (int i=0; i<propertyDescriptor.length; i++) {
		    	if (propertyDescriptor[i].getName().equals(attributeName)) {
		    		Method method = propertyDescriptor[i].getReadMethod();
		    		value = (String)method.invoke(this, null);
					if (value!=null) {
						// find and replace {...}
						int firstIndex = value.indexOf("{");
						int lastIndex = value.indexOf("}");
						
						if (firstIndex!=-1 && lastIndex!=-1) {
						
							String begin = value.substring(0, firstIndex);
							String med = value.substring(firstIndex+1, lastIndex);
							String end = value.substring(lastIndex+1, value.length());
							
							String realMedValue = (String)person.getAttribute(med);
							
							String newString = begin+realMedValue+end;								
							
							method = propertyDescriptor[i].getWriteMethod();
							Object[] arg = {newString};
							method.invoke(this, arg);
							if (log.isDebugEnabled()){
								log.debug("checkAttribute"+" :: replace "+attributeName+" value "+value+" with "+newString);
							}

						}	
						
					}
		    		// no more nead to scan propertyDescriptor[] --> exit for statement
		    		i = propertyDescriptor.length;
		    	}
		    }
		}
		catch (InvocationTargetException e) {
			log.error("checkAttribute"+" :: "+e);			
		}
		catch (IntrospectionException e) {
			log.error("checkAttribute"+" :: "+e);			
		}
		catch (IllegalAccessException e) {
			log.error("checkAttribute"+" :: "+e);			
		}
	}
	
	
	
	/**
	 * Add a path element to the current directory
	 * @param pathElement
	 */
	public void addPathElement(String pathElement) {
		this.currentPath.add(pathElement);
	}
	
	/**
	 * Remove an element from the current path
	 * @param index
	 */
	public void removePathElement(int index) {
		this.currentPath.remove(index);
	}
	
	/**
	 * Return the path size
	 * @return the size
	 */
	public int getPathSize() {
		return currentPath.size();
	}
		
	/**
	 * Return the current element path at the good index
	 * @param index the selected index
	 * @return a string
	 */
	public String getPathElementAt(int index) {
		if (index == 0)
			return this.label;
		else return (String)this.currentPath.elementAt(index);
	}
		
	
	/**
	 * Check if we are authorized to read this space
	 * @param access the object used to access the server
	 * @return true if authorized else false
	 */
	public boolean canRead(ServerAccess access) {
		try {
			if (access.canRead(this.getPath()))
				return true;
			else return false;
		}
		catch(ChannelException e) {
			return false;
		}
	}		
	
	
	/**
	 * Set the server access object for this space
	 * @return true if we can access this space, else false
	 * @throws ClassNotFoundException
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws MalformedURLException
	 * @throws ApplicationException
	 * @throws PropertiesException
	 */
	public boolean setServerAccessObject() throws PropertiesException, ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException, ApplicationException{
		
		if (serverAccessClass==null) {
			log.error("setServerAccessObject :: wrong server type for space "+getKey());
			return false;
		}
		
		// construct the object
		Class c = Class.forName(serverAccessClass);
		access = (ServerAccess)c.newInstance();
		//System.out.println("avant init");
		access.init(this);
		//System.out.println("apres init");
		// add the current server hierarchy path
		//String serverCurrentHierPath = access.getServerCurrentHierPath();		
		//setPath(serverCurrentHierPath);
		
		
		// if the authentication is "asked", we don't try to connect
		if (isAskedAuthentication())
			return true;
		
		// try to connect
		try {
			//System.out.println("avant connect");
			access.connect();			
			//System.out.println("apres connect");
		}
		catch(ServerException e) {			
			//e.printStackTrace();
			// log
			if (log.isDebugEnabled()){
				log.debug("setServerAccessObject"+" :: "+e);
			}
			
			return false;
		}
		catch(BadConnexionParameters e) {
			//e.printStackTrace();
			// log
			if (log.isDebugEnabled()){
				log.debug("setServerAccessObject"+" :: "+e);
			}
			
			return false;
		}
		
		// if it is valid
		boolean valid = access.canRead(getPath());
		
		// disconnect
		try {
			access.disconnect();			
		}
		catch(ServerException e) {

			// log
			if (log.isDebugEnabled()){
				log.debug("setServerAccessObject"+" :: "+e);
			}
			
		}
		
		return valid;
	}
	
	
	
	/**
	 * Return the object used to access the server
	 * @return the object used to access the server
	 */
	public ServerAccess getServerAccessObject() {
		return this.access;
	}
	
	
	/**
	 * Set the server access object
	 * @param access
	 */
	public void setServerAccessObject(ServerAccess access) {
		this.access = access;
	}
	
	
	/**
	 * Set the object used to manage the actions of the channel
	 * @param person the uPortal person object
	 * @param spaces the spaces used
	 * @param buffer the buffer used to get for example the clipboard
	 * @param userPortalLogin The user login in the portal
	 * @param userGroups The groups of the user in the portal
	 * @return true if well done
	 * @throws ChannelException
	 */
	public boolean setChannelActionObject(IPerson person, ArrayList spaces, BufferAction buffer, String userPortalLogin, Vector userGroups) throws ChannelException {
		
		try {
			
			if (this.channelActionClass==null)
				this.channelActionClass = "org.esupportail.portal.channels.CStockage.channelAction.webdav.ChannelAction";				
			
			Class classe = Class.forName(this.channelActionClass);
			Object obj = classe.newInstance();
			
			this.channelAction = (AbstractChannelAction)obj;
			this.channelAction.init(person, this, spaces, buffer, userPortalLogin, userGroups);
			
		}
		catch(ClassNotFoundException e) {
			log.error("setChannelActionObject"+" :: "+e);			
			return false;
		}
		catch(IllegalAccessException e) {
			log.error("setChannelActionObject"+" :: "+e);	
			return false;
		}
		catch(InstantiationException e) {
			log.error("setChannelActionObject"+" :: "+e);	
			return false;
		}
		return true;
	}
	
	
	
	/**
	 * Get the channel action object
	 * @return the channel action object
	 */
	public AbstractChannelAction getChannelActionObject() {
		return this.channelAction;
	}
	
	
	
	
	/**
	 * Return a String representation of this space
	 */
	public String toString() {
		return 
		"key: "+key+"\n"+
		"label: "+label+"\n"+
		"path: "+getPath()+"\n";
	}
	

	/**
	 * @return Returns the nfsGidNumber.
	 */
	public String getNfsGidNumber() {
		return nfsGidNumber;
	}
	/**
	 * @param nfsGidNumber The nfsGidNumber to set.
	 */
	public void setNfsGidNumber(String nfsGidNumber) {
		this.nfsGidNumber = nfsGidNumber;
	}
	/**
	 * @return Returns the nfsUidNumber.
	 */
	public String getNfsUidNumber() {
		return nfsUidNumber;
	}
	/**
	 * @param nfsUidNumber The nfsUidNumber to set.
	 */
	public void setNfsUidNumber(String nfsUidNumber) {
		this.nfsUidNumber = nfsUidNumber;
	}
	
	
	
	/**
	 * Compare this to another object
	 * @param o object to compare
	 */
	public boolean equals(Object o) {
		Space s = (Space)o;
		
		boolean thisIsPersonal = this.isPersonnalSpace();
		boolean sIsPersonal = s.isPersonnalSpace();
		
		if(thisIsPersonal && sIsPersonal) {
			return this.getIdInDatabase().equals(s.getIdInDatabase());
		}
		else {		
			return this.key.equals(((Space)o).getKey());
		}
	}
	
	
	
	
	
	/**
	 * Clone this object
	 * @return a clone of this object
	 */
	public Object clone() {
		Space space = new Space();

		space.key = this.key;
		space.label = this.label;
		space.url = this.url;
		space.serverType = this.serverType;
		space.actionType = this.actionType;
		space.authenticationMode = this.authenticationMode;
		space.login = this.login;
		space.loginIsFromConfigurationFile = this.loginIsFromConfigurationFile;
		space.initialLoginFromTheConfigurationFile = this.initialLoginFromTheConfigurationFile;
		space.password = this.password;
		
		space.enableSharing = this.enableSharing;
						
		space.initialPath = this.initialPath;
		space.pathRegexp = this.pathRegexp;
		space.pathRegexpSeparator = this.pathRegexpSeparator;
		
		space.currentPath = (Vector)this.currentPath.clone();
		
		space.metadataNamespace = this.metadataNamespace;
		space.manageAcl = this.manageAcl;
		space.aclNamespace = this.aclNamespace;
		space.aclUserPrefix = this.aclUserPrefix;
		space.aclGroupPrefix = this.aclGroupPrefix;
		space.aclUportalGroup = this.aclUportalGroup;
		
		space.authorizations = new ArrayList();
		for (int i=0; i<this.authorizations.size(); i++) {
			space.authorizations.add(((AuthorizationSpaceParameter)this.authorizations.get(i)).clone());
		}
		
		space.cifsDomain = this.cifsDomain;
		space.cifsResolveOrder = this.cifsResolveOrder;
		space.cifsDisablePlainTextPassword = this.cifsDisablePlainTextPassword;
		space.nfsUidNumber = this.nfsUidNumber;
		space.nfsGidNumber = this.nfsGidNumber;
		space.personnalSpace = this.personnalSpace;
		space.canWrite = this.canWrite;
		space.owner = this.owner;
		space.targetOfSharing = this.targetOfSharing;
		space.sharedForTheUser = this.sharedForTheUser;
		space.idInDatabase = this.idInDatabase;
		
		return space;
	}
}
