/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.userManagement;

import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.exception.ServerException;
import org.jasig.portal.groups.EntityGroupImpl;

/**
 * Id: Group.java,v 1.0 7 oct. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: Group
 * Original Author: Yohan Colmant
 * Represents a group for the management
 */
public class Group extends AbstractUser {


	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(Group.class);
	
	
	
	/**
	 * This group hierarchy
	 */
	private Vector groupHierarchy;
	
	
	
	/**
	 * Default constructor
	 */
	public Group() {
		
	}
	
	
	
	/**
	 * Constructor
	 * @param key the group key
	 * @param displayName The displayed group name
	 * @throws ServerException
	 */
	public Group(String key, String displayName) throws ServerException {
		this.key = key;		
		this.groupHierarchy = PortalGroupsManagement.getGroupHierarchy(key);
				
		if (displayName!=null) {
			this.displayName = displayName;
		}
		else {
			try {
				this.displayName = PortalGroupsManagement.getGroupName(key);
			}
			catch(ServerException e) {
				this.displayName = this.key;
			}
		}		
	}
	
	/**
	 * Constructor
	 * @param group this portal group value
	 * @throws ServerException
	 */
	public Group(EntityGroupImpl group) throws ServerException {
		this.key = group.getKey();
		this.displayName = group.getName();
		this.groupHierarchy = PortalGroupsManagement.getGroupHierarchy(group);		
	}
	
	/**
	 * Constructor
	 * @param hierarchy this portal group hierarchy in this form: G1/G2/G3 where G1 is the root
	 * @throws ServerException
	 */
	public Group(String hierarchy) throws ServerException {
		groupHierarchy = new Vector();
		StringTokenizer strToken = new StringTokenizer(hierarchy, "/");
		String token = "";
		while (strToken.hasMoreTokens()) {
			token = strToken.nextToken();
			this.groupHierarchy.add(token);
		}
		
		this.key = token;
		this.displayName = PortalGroupsManagement.getGroupName(key);		
	}	

	
	
	
	
	

	
	/**
	 * Get this group keys hierarchy from the root to the group key
	 * @return a vector construct with each hierarchy node
	 */
	public Vector getGroupHierarchy() {
		return this.groupHierarchy;
	}
	
	

	/**
	 * Clone this object to another similary one
	 * @return this cloned object
	 */
	public Object clone() {
		Group clone = new Group();
		clone.setKey(this.getKey());
		clone.setDisplayName(this.getDisplayName());
		return clone;
	}
	
	
	
	/**
	 * Return a String from this group
	 * @return a String from this group
	 */
	public String toString() {		
		return "Group: "+super.toString();
	}
}
