/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.userManagement;

import java.util.Iterator;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.exception.ServerException;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.EntityGroupImpl;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupConstants;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.services.GroupService;

/**
 * Id: PortalGroupsManagement.java,v 1.0 15 oct. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: PortalGroupsManagement
 * Original Author: Yohan Colmant
 * Manage the portal groups access. For example, if we want to know in which groups a specified user is. 
 */
public class PortalGroupsManagement {


	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(PortalGroupsManagement.class);
	
	
	
	
	

	
	/**
	 * Get the display name for the group key specified in parameter
	 * @param groupKey the group key
	 * @return the display name
	 * @throws ServerException
	 */
	public static String getGroupName(String groupKey) throws ServerException {
		try {
			IEntityGroup myGroup = GroupService.findGroup(groupKey);
			if (myGroup==null) {

				// log
				if (log.isDebugEnabled()){
					log.debug("getGroupName"+" :: not existing group "+groupKey);					
				}

				throw new GroupsException("not existing group "+groupKey);
			}
			
			else {
				String name = myGroup.getName();				
				return name;
			}
		}
		catch(GroupsException e) {
			log.error("getGroupName"+" :: "+e);			
			throw new ServerException();
		}
	}
	
	
	

	/**
	 * Get this group hierarchy
	 * @param group the group to explore
	 * @return the group hierarchy in a vector form
	 * @throws ServerException
	 */
	public static Vector getGroupHierarchy(IEntityGroup group) throws ServerException {
		
		try {
			Vector groupHierarchy = new Vector();
			
			Iterator iter = group.getContainingGroups();
			if (iter.hasNext()) {
				EntityGroupImpl egi = (EntityGroupImpl)iter.next();
				recurGroupHierarchy(egi, groupHierarchy);
				groupHierarchy.addElement(egi.getKey());
			}
			groupHierarchy.addElement(group.getKey());
			
			return groupHierarchy;
		}
		catch(GroupsException e) {
			log.error("getGroupHierarchy"+" :: "+e);
			throw new ServerException();
		}
	}
	

	
	/**
	 * Get this group hierarchy
	 * @param groupKey the key of the group to explore
	 * @return the group hierarchy in a vector form
	 * @throws ServerException
	 */
	public static Vector getGroupHierarchy(String groupKey) throws ServerException {
		try {
			//System.out.println("\n\nclef:"+groupKey+":");			
			IEntityGroup myGroup = GroupService.findGroup(groupKey);
			//System.out.println("myGroup: "+myGroup);
			if (myGroup!=null)
				return getGroupHierarchy(myGroup);
			else return null;
		}
		catch(GroupsException e) {
			log.error("getGroupHierarchy"+" :: "+e);
			throw new ServerException();
		}
	}
	
	

	/**
	 * Set recursivly the group hierarchy
	 * @param igm the group member object
	 * @param v the vector we want to set
	 * @throws ServerException
	 */
	private static void recurGroupHierarchy(IGroupMember igm, Vector v) throws ServerException {
		try {
			Iterator iter = igm.getContainingGroups();

			if(iter.hasNext()) {
				EntityGroupImpl egi = (EntityGroupImpl)iter.next();									
				recurGroupHierarchy(egi, v);			
				v.addElement(egi.getKey());			
			}
		}
		catch(GroupsException e) {
			log.error("recurGroupHierarchy"+" :: "+e);
			throw new ServerException();
		}
	}
	
	
	
	
	
	/**
	 * Get the current user groups in the portal
	 * @param userLogin the login of the user
	 * @return the current user groups in the portal
	 */
	public static Vector getUserGroupsKeys(String userLogin) {
		
		try {
	    	
	    	// vector containing all groups
	    	Vector groups = new Vector();
	    	
	    	// we search the given Person
	    	int method = IGroupConstants.IS;
	    	Class type = Class.forName("org.jasig.portal.security.IPerson");
	    	EntityIdentifier[] ents = GroupService.searchForEntities(userLogin,method,type);
	    	
	    	// if no element we return an empty vector
	    	if (ents.length!=0) {
	    		// we have only one result for this request type
	    		EntityIdentifier ei = ents[0];
	    		
	    		// the IGroupMember object associated to this element
	    		IGroupMember gm = GroupService.getGroupMember(ei);						
	    		
	    		// all groups of the user
	    		Iterator iter = gm.getContainingGroups();
	    		
	    		// for each group, we go to the root element of the tree
	    		while(iter.hasNext()) {
	    			
	    			// for each element
	    			EntityGroupImpl egi = (EntityGroupImpl)iter.next();
	    			
	    			// we set the vector
	    			getRecurContainingGroups(egi, groups);
	    			if (!groups.contains(egi.getKey()))
	    				groups.addElement(egi.getKey());
	    			
	    		}    		
	    		// return the result	    		
	    		return groups;
	    	}
	    	
	    	// if none element, we return an empty Vector
	    	else {
	    		return new Vector();
	    		}
	    }
	    catch(GroupsException e) {
	    	log.error("getUserGroupsKeys"+" :: "+e);
	    	return new Vector();
	    }
	    catch(ServerException e) {	    	
	    	return new Vector();
	    }	    
	    catch(ClassNotFoundException e) {
	    	log.error("getUserGroupsKeys"+" :: "+e);
	    	return new Vector();
	    }		
	}
	
	
	
	 
    /**
     * Get recursively the groups contening a given group, until the root element
     * @param igm a group in its IGroupMember form
     * @param v vector set in recursivity
     * @throws ServerException
     */
    private static void getRecurContainingGroups(IGroupMember igm, Vector v) throws ServerException {				

    	try {
    		// get the groups containing the group given in parameter
    		Iterator iter = igm.getContainingGroups();
    		
    		// for each one, we add it in the list
    		while(iter.hasNext()) {
    			EntityGroupImpl egi = (EntityGroupImpl)iter.next();
										
    			getRecurContainingGroups(egi, v);
    			
    			if (!v.contains(egi.getKey()))
    				v.addElement(egi.getKey());
    			
    		}
    	}
    	catch(GroupsException e) {
    		log.error("getRecurContainingGroups"+" :: "+e);
    		throw new ServerException();
    	}
	}
	
	
	
    
    
	
	
}
