<?xml version='1.0' encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no" />
<xsl:param name="baseActionURL"/>

<xsl:template match="/">

	
	<script language="javascript">
		<![CDATA[

			// we check than there is a label set
			function checkLabel() {	
				if (document.form.label.value == "")
				 	alert ('Vous devez entrer un libell');
				else {
					document.form.mode.value = 'valid';
					document.form.submit();
				}
			}

		]]>
	</script>
		

<form name="form" action="{$baseActionURL}?modeDav=share_directory_mode&amp;uP_root=root" method="post">

<input type="hidden" name="mode" value=""/>

<table border="0" width="100%" cellspacing="0" cellpadding="5">
	<tr class="uportal-background-light">				
		<td class="uportal-channel-table-header" nowrap="true">Partage de "<xsl:value-of select="/ROOT/directory/@name"/>"</td>
		<td width="100%">&#160;</td>		
		<td align="center">
			<a class="uportal-navigation-channel" href="javascript:checkLabel();">		
				<img src="media/org/esupportail/portal/channels/CStockage/valid_24px.gif" alt="Valider" border="0" />
				<br/>Valider
			</a>
		</td>
		<td align="center">
			<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=share_directory_mode&amp;mode=cancel&amp;uP_root=root">				
				<img src="media/org/esupportail/portal/channels/CStockage/cancel_24px.gif" alt="Annuler" border="0" />
				<br/>Annuler
			</a>
		</td>
	</tr>
</table>
<br/>







<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption">Libell</td>
	</tr>
	
	<tr>
		<td align="center">
			<input type="text" name="label" size="40" class="uportal-input-text" value="{/ROOT/label}"/>
		</td>
	</tr>
	
</table>
<br/>







<xsl:for-each select="/ROOT/users">
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption">Utilisateurs</td>
	</tr>
		
	
	<tr valign="top">
		<td width="90%">		
			<table border="0" width="100%" cellpadding="2" cellspacing="5">
				<tr >
					<td>&#160;</td>
					
					<td class="uportal-background-med" nowrap="true" align="left" colspan="2" width="60%">
						<div class="uportal-channel-table-header">
							Nom
						</div>
					</td>
					
					<td class="uportal-background-med" nowrap="true" align="center" width="20%">
						<div class="uportal-channel-table-header">
							Lecture
						</div>
					</td>		
					<td class="uportal-background-med" nowrap="true" align="center" width="20%">
						<div class="uportal-channel-table-header">
							Ecriture
						</div>
					</td>
					<td class="uportal-background-med" nowrap="true" align="center" width="20%">
						<div class="uportal-channel-table-header">
							Gestion droits
						</div>
					</td>					
				</tr>
				
				<xsl:for-each select="user">
					<tr>
						<td>
							<input type="checkbox" name="usersList" value="{@key}"/>							
						</td>
						<td class="uportal-channel-text" valign="center" align="left">
							<img src="media/org/esupportail/portal/channels/CStockage/user_20px.gif" border="0" />
						</td>
						<td class="uportal-channel-text" valign="center" align="left" width="100%">
							<xsl:value-of select="./@name" />
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@read='true'">
									<input type="checkbox" name="readUserList" checked="true" value="{@key}"/>
								</xsl:when>
								<xsl:otherwise>
									<input type="checkbox" name="readUserList" value="{@key}"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@write='true'">
									<input type="checkbox" name="writeUserList" checked="true" value="{@key}"/>
								</xsl:when>
								<xsl:otherwise>
									<input type="checkbox" name="writeUserList" value="{@key}"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@manage='true'">
									<input type="checkbox" name="manageUserList" checked="true" value="{@key}"/>
								</xsl:when>
								<xsl:otherwise>
									<input type="checkbox" name="manageUserList" value="{@key}"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>							
				<tr>				
					<td/>
					<td colspan="3">
						<input class="uportal-button" type="submit" value="Ajouter" name="add_user" />
						<input class="uportal-button" type="submit" value="Supprimer" name="delete_user" />
					</td>
				</tr>
			</table>
			<br/>
		</td>
		
		
	</tr>
	
</table>
</xsl:for-each>
<br/>





<xsl:for-each select="/ROOT/groups">
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption">Groupes</td>
	</tr>
		
	
	<tr valign="top">
		<td width="90%">		
			<table border="0" width="100%" cellpadding="2" cellspacing="5">
				<tr >
					<td>&#160;</td>
					
					<td class="uportal-background-med" nowrap="true" align="left" colspan="2" width="60%">
						<div class="uportal-channel-table-header">
							Nom
						</div>
					</td>
					
					<td class="uportal-background-med" nowrap="true" align="center" width="20%">
						<div class="uportal-channel-table-header">
							Lecture
						</div>
					</td>		
					<td class="uportal-background-med" nowrap="true" align="center" width="20%">
						<div class="uportal-channel-table-header">
							Ecriture
						</div>
					</td>
					<td class="uportal-background-med" nowrap="true" align="center" width="20%">
						<div class="uportal-channel-table-header">
							Gestion droits
						</div>
					</td>					
				</tr>
				
				<xsl:for-each select="group">
					<tr>
						<td>
							<input type="checkbox" name="groupsList" value="{@key}"/>							
						</td>
						<td class="uportal-channel-text" valign="center" align="left">
							<img src="media/org/esupportail/portal/channels/CStockage/group_20px.gif" border="0" />
						</td>
						<td class="uportal-channel-text" valign="center" align="left" width="100%">
							<xsl:value-of select="./@name" />
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@read='true'">
									<input type="checkbox" name="readGroupList" checked="true" value="{@key}"/>
								</xsl:when>
								<xsl:otherwise>
									<input type="checkbox" name="readGroupList" value="{@key}"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@write='true'">
									<input type="checkbox" name="writeGroupList" checked="true" value="{@key}"/>
								</xsl:when>
								<xsl:otherwise>
									<input type="checkbox" name="writeGroupList" value="{@key}"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="@manage='true'">
									<input type="checkbox" name="manageGroupList" checked="true" value="{@key}"/>
								</xsl:when>
								<xsl:otherwise>
									<input type="checkbox" name="manageGroupList" value="{@key}"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>
				<tr>				
					<td/>
					<td colspan="3">
						<input class="uportal-button" type="submit" value="Ajouter" name="add_group" />
						<input class="uportal-button" type="submit" value="Supprimer" name="delete_group" />
					</td>
				</tr>						
			</table>
				
			<br/>
		</td>
		
		
	</tr>
	
</table>
</xsl:for-each>



</form>



</xsl:template>
</xsl:stylesheet>