/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.accesslayer.RowReader;
import org.apache.ojb.broker.accesslayer.StatementsForClassFactory;
import org.apache.ojb.broker.accesslayer.StatementsForClassIF;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.AnonymousObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DeleteProcedureDescriptor;
import org.apache.ojb.broker.metadata.DescriptorBase;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.IndexDescriptor;
import org.apache.ojb.broker.metadata.InsertProcedureDescriptor;
import org.apache.ojb.broker.metadata.IsolationLevels;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.ObjectCacheDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.UpdateProcedureDescriptor;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.SqlHelper;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public final class ClassDescriptor
extends DescriptorBase
implements Serializable,
XmlCapable,
IsolationLevels {
    private String persistentFieldClassName;
    private static final long serialVersionUID = -5212253607374173965L;
    public static final String OJB_CONCRETE_CLASS = "ojbConcreteClass";
    private static final Class[] NO_PARAMS = new Class[0];
    private InsertProcedureDescriptor insertProcedure;
    private UpdateProcedureDescriptor updateProcedure;
    private DeleteProcedureDescriptor deleteProcedure;
    private transient Method initializationMethod;
    private String initializationMethodName;
    private transient Method factoryMethod;
    private String factoryMethodName;
    private transient boolean alreadyLookedupZeroArguments = false;
    private transient Constructor zeroArgumentConstructor = null;
    private transient boolean ojbConcreteFieldCheckDone = false;
    private transient FieldDescriptor ojbConcreteClassField;
    private transient StatementsForClassIF statementsForClass;
    private DescriptorRepository m_repository;
    private Class factoryClass;
    private String baseClass = null;
    private int m_IsolationLevel = 0;
    private String schema = null;
    private Class m_Class = null;
    private boolean isAbstract = false;
    private String m_TableName = null;
    private Vector superPersistentFieldDescriptors = null;
    private RowReader m_rowReader = null;
    private String superClass;
    private int superClassFieldRef;
    private boolean m_isInterface = false;
    private Class proxyClass = null;
    private String proxyClassName = null;
    private boolean acceptLocks = true;
    private boolean alwaysRefresh = false;
    private int m_ProxyPrefetchingLimit = 50;
    private ObjectCacheDescriptor objectCacheDescriptor;
    private Class[] m_dynamicProxyClassInterfaces;
    private Vector indexes = new Vector();
    private FieldDescriptor m_autoIncrementField = null;
    private FieldDescriptor[] m_FieldDescriptions = null;
    private Vector m_CollectionDescriptors = new Vector();
    private Vector m_ObjectReferenceDescriptors = new Vector();
    private FieldDescriptor[] m_nonPkFieldDescriptors = null;
    private FieldDescriptor[] m_PkFieldDescriptors = null;
    private FieldDescriptor[] m_RwFieldDescriptors = null;
    private FieldDescriptor[] m_RwNonPkFieldDescriptors = null;
    private FieldDescriptor[] m_lockingFieldDescriptors = null;
    private Vector extentClasses = new Vector();
    private Vector extentClassNames = new Vector();
    private Map m_fieldDescriptorNameMap = null;
    private Map m_collectionDescriptorNameMap = null;
    private Map m_objectReferenceDescriptorsNameMap = null;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$ClassDescriptor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public ClassDescriptor(DescriptorRepository pRepository) {
        this.m_repository = pRepository;
    }

    public String getBaseClass() {
        return this.baseClass;
    }

    public void setBaseClass(String baseClass) {
        this.baseClass = baseClass;
    }

    public void setSuperPersistentFieldDescriptors(Vector superPersistentFieldDescriptors) {
        this.superPersistentFieldDescriptors = superPersistentFieldDescriptors;
    }

    public Vector getSuperPersistentFieldDescriptors() {
        return this.superPersistentFieldDescriptors;
    }

    public ObjectCacheDescriptor getObjectCacheDescriptor() {
        return this.objectCacheDescriptor;
    }

    public void setObjectCacheDescriptor(ObjectCacheDescriptor objectCacheDescriptor) {
        this.objectCacheDescriptor = objectCacheDescriptor;
    }

    public void setRowReader(RowReader newReader) {
        this.m_rowReader = newReader;
    }

    public synchronized RowReader getRowReader() {
        if (this.m_rowReader == null) {
            OjbConfigurator configurator = OjbConfigurator.getInstance();
            Configuration config = configurator.getConfigurationFor(null);
            Class rrClass = config.getClass("RowReaderDefaultClass", class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl == null ? (class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl = ClassDescriptor.class$("org.apache.ojb.broker.accesslayer.RowReaderDefaultImpl")) : class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl);
            this.setRowReader(rrClass.getName());
        }
        return this.m_rowReader;
    }

    public void setRowReader(String newReaderClassName) {
        try {
            this.m_rowReader = (RowReader)ClassHelper.newInstance(newReaderClassName, class$org$apache$ojb$broker$metadata$ClassDescriptor == null ? (class$org$apache$ojb$broker$metadata$ClassDescriptor = ClassDescriptor.class$("org.apache.ojb.broker.metadata.ClassDescriptor")) : class$org$apache$ojb$broker$metadata$ClassDescriptor, (Object)this);
        }
        catch (Exception e) {
            throw new MetadataException("Instantiating of current set RowReader failed", e);
        }
    }

    public String getRowReaderClassName() {
        return this.m_rowReader != null ? this.m_rowReader.getClass().getName() : null;
    }

    public String getClassNameOfObject() {
        return this.m_Class != null ? this.m_Class.getName() : null;
    }

    public Class getClassOfObject() {
        return this.m_Class;
    }

    public void setClassOfObject(Class c) {
        this.m_Class = c;
        this.isAbstract = Modifier.isAbstract(this.m_Class.getModifiers());
    }

    public void addFieldDescriptor(FieldDescriptor fld) {
        fld.setClassDescriptor(this);
        if (this.m_FieldDescriptions == null) {
            this.m_FieldDescriptions = new FieldDescriptor[1];
            this.m_FieldDescriptions[0] = fld;
        } else {
            int size = this.m_FieldDescriptions.length;
            FieldDescriptor[] tmpArray = new FieldDescriptor[size + 1];
            System.arraycopy(this.m_FieldDescriptions, 0, tmpArray, 0, size);
            tmpArray[size] = fld;
            this.m_FieldDescriptions = tmpArray;
            Arrays.sort(this.m_FieldDescriptions, FieldDescriptor.getComparator());
        }
        this.m_fieldDescriptorNameMap = null;
        this.m_PkFieldDescriptors = null;
        this.m_nonPkFieldDescriptors = null;
        this.m_lockingFieldDescriptors = null;
        this.m_RwFieldDescriptors = null;
        this.m_RwNonPkFieldDescriptors = null;
    }

    public boolean removeFieldDescriptor(FieldDescriptor fld) {
        boolean result = false;
        if (this.m_FieldDescriptions == null) {
            return result;
        }
        ArrayList<FieldDescriptor> list = new ArrayList<FieldDescriptor>(Arrays.asList(this.m_FieldDescriptions));
        result = list.remove(fld);
        this.m_FieldDescriptions = list.toArray(new FieldDescriptor[list.size()]);
        this.m_fieldDescriptorNameMap = null;
        this.m_PkFieldDescriptors = null;
        this.m_nonPkFieldDescriptors = null;
        this.m_lockingFieldDescriptors = null;
        this.m_RwFieldDescriptors = null;
        this.m_RwNonPkFieldDescriptors = null;
        return result;
    }

    public Vector getCollectionDescriptors() {
        return this.m_CollectionDescriptors;
    }

    public void addCollectionDescriptor(CollectionDescriptor cod) {
        this.m_CollectionDescriptors.add(cod);
        cod.setClassDescriptor(this);
        this.m_collectionDescriptorNameMap = null;
    }

    public void removeCollectionDescriptor(CollectionDescriptor cod) {
        this.m_CollectionDescriptors.remove(cod);
        this.m_collectionDescriptorNameMap = null;
    }

    public Vector getObjectReferenceDescriptors() {
        return this.m_ObjectReferenceDescriptors;
    }

    public void addObjectReferenceDescriptor(ObjectReferenceDescriptor ord) {
        this.m_ObjectReferenceDescriptors.add(ord);
        ord.setClassDescriptor(this);
        this.m_objectReferenceDescriptorsNameMap = null;
    }

    public void removeObjectReferenceDescriptor(ObjectReferenceDescriptor ord) {
        this.m_ObjectReferenceDescriptors.remove(ord);
        this.m_objectReferenceDescriptorsNameMap = null;
    }

    public ObjectReferenceDescriptor getObjectReferenceDescriptorByName(String name) {
        ObjectReferenceDescriptor superOrd;
        ObjectReferenceDescriptor ord;
        if (name == null) {
            return null;
        }
        if (this.m_objectReferenceDescriptorsNameMap == null) {
            HashMap<String, ObjectReferenceDescriptor> nameMap = new HashMap<String, ObjectReferenceDescriptor>();
            Vector descriptors = this.getObjectReferenceDescriptors();
            for (int i = descriptors.size() - 1; i >= 0; --i) {
                ObjectReferenceDescriptor ord2 = (ObjectReferenceDescriptor)descriptors.get(i);
                nameMap.put(ord2.getPersistentField().getName(), ord2);
            }
            this.m_objectReferenceDescriptorsNameMap = nameMap;
        }
        if ((ord = (ObjectReferenceDescriptor)this.m_objectReferenceDescriptorsNameMap.get(name)) == null && (superOrd = (ObjectReferenceDescriptor)this.m_objectReferenceDescriptorsNameMap.get(AnonymousObjectReferenceDescriptor.ANONYMOUS_NAME)) != null) {
            ClassDescriptor superCld = this.getRepository().getDescriptorFor(superOrd.getItemClass());
            ord = superCld.getObjectReferenceDescriptorByName(name);
        }
        return ord;
    }

    public CollectionDescriptor getCollectionDescriptorByName(String name) {
        if (name == null) {
            return null;
        }
        if (this.m_collectionDescriptorNameMap == null) {
            HashMap<String, CollectionDescriptor> nameMap = new HashMap<String, CollectionDescriptor>();
            Vector descriptors = this.getCollectionDescriptors();
            for (int i = descriptors.size() - 1; i >= 0; --i) {
                CollectionDescriptor cod = (CollectionDescriptor)descriptors.get(i);
                nameMap.put(cod.getPersistentField().getName(), cod);
            }
            this.m_collectionDescriptorNameMap = nameMap;
        }
        return (CollectionDescriptor)this.m_collectionDescriptorNameMap.get(name);
    }

    public void addExtentClassName(Class newExtendClass) {
        this.addExtentClass(newExtendClass);
    }

    public void addExtentClass(Class newExtendClass) {
        this.extentClasses.add(newExtendClass);
        this.addExtentClass(newExtendClass.getName());
    }

    public void addExtentClass(String newExtentClassName) {
        this.extentClassNames.add(newExtentClassName);
        if (this.m_repository != null) {
            this.m_repository.addExtent(newExtentClassName, this);
        }
    }

    public void removeExtentClass(String extentClassName) {
        this.extentClassNames.remove(extentClassName);
        if (this.m_repository != null) {
            this.m_repository.removeExtent(extentClassName);
        }
    }

    public synchronized Vector getExtentClasses() {
        if (this.extentClassNames.size() != this.extentClasses.size()) {
            this.extentClasses.clear();
            Iterator iter = this.extentClassNames.iterator();
            while (iter.hasNext()) {
                Class extentClass;
                String classname = (String)iter.next();
                try {
                    extentClass = ClassHelper.getClass(classname);
                }
                catch (ClassNotFoundException e) {
                    throw new MetadataException("Unable to load class [" + classname + "]. Make sure it is available on the classpath.", e);
                }
                this.extentClasses.add(extentClass);
            }
        }
        return this.extentClasses;
    }

    public synchronized Vector getExtentClassNames() {
        return this.extentClassNames;
    }

    public boolean isExtent() {
        return this.getExtentClassNames().size() > 0;
    }

    public synchronized Class getProxyClass() {
        if (this.proxyClass == null && this.proxyClassName != null) {
            String dynamic = "dynamic";
            if (dynamic.equalsIgnoreCase(this.proxyClassName)) {
                this.proxyClass = this.getDynamicProxyClass();
            } else {
                try {
                    this.proxyClass = ClassHelper.getClass(this.proxyClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new MetadataException(e);
                }
            }
        }
        return this.proxyClass;
    }

    public void setProxyClass(Class newProxyClass) {
        this.proxyClass = newProxyClass;
        if (this.proxyClass == null) {
            this.setProxyClassName(null);
        } else {
            this.proxyClassName = this.proxyClass.getName();
        }
    }

    public void setProxyClassName(String newProxyClassName) {
        this.proxyClassName = newProxyClassName;
    }

    public String getProxyClassName() {
        return this.proxyClassName;
    }

    public FieldDescriptor[] getFieldDescriptions() {
        return this.m_FieldDescriptions;
    }

    public FieldDescriptor getFieldDescriptorByIndex(int index) {
        return this.m_FieldDescriptions[index - 1];
    }

    public FieldDescriptor getFieldDescriptorByName(String name) {
        if (name == null || this.m_FieldDescriptions == null) {
            return null;
        }
        if (this.m_fieldDescriptorNameMap == null) {
            HashMap<String, FieldDescriptor> nameMap = new HashMap<String, FieldDescriptor>();
            FieldDescriptor[] descriptors = this.getFieldDescriptions();
            for (int i = descriptors.length - 1; i >= 0; --i) {
                FieldDescriptor fld = descriptors[i];
                nameMap.put(fld.getPersistentField().getName(), fld);
            }
            this.m_fieldDescriptorNameMap = nameMap;
        }
        return (FieldDescriptor)this.m_fieldDescriptorNameMap.get(name);
    }

    public FieldDescriptor getFieldDescriptorForPath(String aPath, Map pathHints) {
        Object temp;
        ArrayList desc = this.getAttributeDescriptorsForPath(aPath, pathHints);
        FieldDescriptor fld = null;
        if (!desc.isEmpty() && (temp = desc.get(desc.size() - 1)) instanceof FieldDescriptor) {
            fld = (FieldDescriptor)temp;
        }
        return fld;
    }

    public FieldDescriptor getFieldDescriptorForPath(String aPath) {
        return this.getFieldDescriptorForPath(aPath, new HashMap());
    }

    public FieldDescriptor[] getFieldDescriptorsInHeirarchy() {
        if (this.superClass == null) {
            return this.getFieldDescriptions();
        }
        ClassDescriptor cldSuper = this.getRepository().getDescriptorFor(this.superClass);
        return this.appendFieldDescriptorArrays(this.getFieldDescriptions(), cldSuper.getFieldDescriptorsInHeirarchy());
    }

    private FieldDescriptor[] appendFieldDescriptorArrays(FieldDescriptor[] fieldDescriptions, FieldDescriptor[] fieldDescriptorsInHeirarchy) {
        FieldDescriptor fieldDescription;
        int size = fieldDescriptions.length + fieldDescriptorsInHeirarchy.length;
        FieldDescriptor[] newArray = new FieldDescriptor[size];
        int j = 0;
        int i = 0;
        while (i < fieldDescriptions.length) {
            newArray[j] = fieldDescription = fieldDescriptions[i];
            ++i;
            ++j;
        }
        i = 0;
        while (i < fieldDescriptorsInHeirarchy.length) {
            newArray[j] = fieldDescription = fieldDescriptorsInHeirarchy[i];
            ++i;
            ++j;
        }
        return newArray;
    }

    public FieldDescriptor getAutoIncrementField() {
        if (this.m_autoIncrementField == null) {
            FieldDescriptor[] fds = this.getPkFields();
            for (int i = 0; i < fds.length; ++i) {
                FieldDescriptor fd = fds[i];
                if (!fd.isAutoIncrement()) continue;
                this.m_autoIncrementField = fd;
                break;
            }
        }
        if (this.m_autoIncrementField == null) {
            LoggerFactory.getDefaultLogger().warn(this.getClass().getName() + ": " + "Could not find autoincrement attribute for class: " + this.getClassNameOfObject());
        }
        return this.m_autoIncrementField;
    }

    public FieldDescriptor[] getAutoIncrementFields() {
        ArrayList<FieldDescriptor> result = new ArrayList<FieldDescriptor>();
        for (int i = 0; i < this.m_FieldDescriptions.length; ++i) {
            FieldDescriptor field = this.m_FieldDescriptions[i];
            if (!field.isAutoIncrement()) continue;
            result.add(field);
        }
        return result.toArray(new FieldDescriptor[result.size()]);
    }

    public ValueContainer[] getCurrentLockingValues(Object o) throws PersistenceBrokerException {
        FieldDescriptor[] fields = this.getLockingFields();
        ValueContainer[] result = new ValueContainer[fields.length];
        for (int i = 0; i < result.length; ++i) {
            ValueContainer vc;
            result[i] = vc = new ValueContainer(fields[i].getPersistentField().get(o), fields[i].getJdbcType());
        }
        return result;
    }

    public void updateLockingValues(Object obj) throws PersistenceBrokerException {
        FieldDescriptor[] fields = this.getLockingFields();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor fmd = fields[i];
            if (!fmd.isUpdateLock()) continue;
            PersistentField f = fmd.getPersistentField();
            Object cv = null;
            cv = f.get(obj);
            if (f.getType() == Integer.TYPE || f.getType() == (class$java$lang$Integer == null ? ClassDescriptor.class$("java.lang.Integer") : class$java$lang$Integer)) {
                int newCv = 0;
                if (cv != null) {
                    newCv = ((Number)cv).intValue();
                }
                f.set(obj, new Integer(++newCv));
                continue;
            }
            if (f.getType() == Long.TYPE || f.getType() == (class$java$lang$Long == null ? ClassDescriptor.class$("java.lang.Long") : class$java$lang$Long)) {
                long newCv = 0L;
                if (cv != null) {
                    newCv = ((Number)cv).longValue();
                }
                f.set(obj, new Long(++newCv));
                continue;
            }
            if (f.getType() != (class$java$sql$Timestamp == null ? ClassDescriptor.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) continue;
            long newCv = new Date().getTime();
            Timestamp ts = new Timestamp(newCv);
            ts.setNanos(0);
            f.set(obj, ts);
        }
    }

    public FieldDescriptor[] getNonPkFields() {
        if (this.m_nonPkFieldDescriptors == null) {
            Vector<FieldDescriptor> vec = new Vector<FieldDescriptor>();
            for (int i = 0; i < this.m_FieldDescriptions.length; ++i) {
                FieldDescriptor fd = this.m_FieldDescriptions[i];
                if (fd.isPrimaryKey()) continue;
                vec.add(fd);
            }
            Collections.sort(vec, FieldDescriptor.getComparator());
            this.m_nonPkFieldDescriptors = vec.toArray(new FieldDescriptor[vec.size()]);
        }
        return this.m_nonPkFieldDescriptors;
    }

    public FieldDescriptor[] getPkFields() {
        if (this.m_PkFieldDescriptors == null) {
            Vector<FieldDescriptor> vec = new Vector<FieldDescriptor>();
            FieldDescriptor[] fields = null;
            if (this.m_isInterface) {
                if (this.getExtentClasses().size() == 0) {
                    throw new PersistenceBrokerException("No Implementors declared for interface " + this.getClassOfObject().getName());
                }
                Class implementor = (Class)this.getExtentClasses().get(0);
                ClassDescriptor implCld = this.getRepository().getDescriptorFor(implementor);
                this.m_PkFieldDescriptors = implCld.getPkFields();
                return this.m_PkFieldDescriptors;
            }
            fields = this.getFieldDescriptions();
            for (int i = 0; i < fields.length; ++i) {
                FieldDescriptor fd = fields[i];
                if (!fd.isPrimaryKey()) continue;
                vec.add(fd);
            }
            Collections.sort(vec, FieldDescriptor.getComparator());
            this.m_PkFieldDescriptors = vec.toArray(new FieldDescriptor[vec.size()]);
        }
        return this.m_PkFieldDescriptors;
    }

    public FieldDescriptor[] getNonPkRwFields() {
        if (this.m_RwNonPkFieldDescriptors == null) {
            FieldDescriptor[] fields = this.getNonPkFields();
            ArrayList<FieldDescriptor> rwFields = new ArrayList<FieldDescriptor>();
            for (int i = 0; i < fields.length; ++i) {
                FieldDescriptor fd = fields[i];
                if (fd.isAccessReadOnly()) continue;
                rwFields.add(fd);
            }
            this.m_RwNonPkFieldDescriptors = rwFields.toArray(new FieldDescriptor[rwFields.size()]);
        }
        return this.m_RwNonPkFieldDescriptors;
    }

    public FieldDescriptor[] getAllRwFields() {
        if (this.m_RwFieldDescriptors == null) {
            FieldDescriptor[] fields = this.getFieldDescriptions();
            ArrayList<FieldDescriptor> rwFields = new ArrayList<FieldDescriptor>();
            for (int i = 0; i < fields.length; ++i) {
                FieldDescriptor fd = fields[i];
                if (fd.isAccessReadOnly()) continue;
                rwFields.add(fd);
            }
            this.m_RwFieldDescriptors = rwFields.toArray(new FieldDescriptor[rwFields.size()]);
        }
        return this.m_RwFieldDescriptors;
    }

    public FieldDescriptor getPrimaryKey() {
        FieldDescriptor[] fds = this.getPkFields();
        if (fds != null && fds.length > 0) {
            return fds[0];
        }
        return null;
    }

    public FieldDescriptor[] getLockingFields() {
        if (this.m_lockingFieldDescriptors == null) {
            Vector<FieldDescriptor> vec = new Vector<FieldDescriptor>();
            for (int i = 0; i < this.m_FieldDescriptions.length; ++i) {
                FieldDescriptor fd = this.m_FieldDescriptions[i];
                if (!fd.isLocking()) continue;
                vec.add(fd);
            }
            Collections.sort(vec, FieldDescriptor.getComparator());
            this.m_lockingFieldDescriptors = vec.toArray(new FieldDescriptor[vec.size()]);
        }
        return this.m_lockingFieldDescriptors;
    }

    public boolean isLocking() {
        return this.getLockingFields().length > 0;
    }

    public Class getDynamicProxyClass() {
        Class clazz = this.getClassOfObject();
        if (this.m_dynamicProxyClassInterfaces == null) {
            this.m_dynamicProxyClassInterfaces = this.getInterfaces(clazz);
        }
        Class<?> proxyClazz = Proxy.getProxyClass(clazz.getClassLoader(), this.m_dynamicProxyClassInterfaces);
        return proxyClazz;
    }

    private Class[] getInterfaces(Class clazz) {
        Class superClazz = clazz;
        Class[] interfaces = clazz.getInterfaces();
        if (clazz.isInterface()) {
            Class[] tempInterfaces = new Class[interfaces.length + 1];
            tempInterfaces[0] = clazz;
            System.arraycopy(interfaces, 0, tempInterfaces, 1, interfaces.length);
            interfaces = tempInterfaces;
        }
        while ((superClazz = superClazz.getSuperclass()) != null) {
            Class<?>[] superInterfaces = superClazz.getInterfaces();
            Class[] combInterfaces = new Class[interfaces.length + superInterfaces.length];
            System.arraycopy(interfaces, 0, combInterfaces, 0, interfaces.length);
            System.arraycopy(superInterfaces, 0, combInterfaces, interfaces.length, superInterfaces.length);
            interfaces = combInterfaces;
        }
        HashMap unique = new HashMap();
        for (int i = 0; i < interfaces.length; ++i) {
            unique.put(interfaces[i].getName(), interfaces[i]);
        }
        interfaces = unique.values().toArray(new Class[unique.size()]);
        return interfaces;
    }

    public ArrayList getAttributeDescriptorsForPath(String aPath) {
        return this.getAttributeDescriptorsForPath(aPath, new HashMap());
    }

    public ArrayList getAttributeDescriptorsForPath(String aPath, Map pathHints) {
        return this.getAttributeDescriptorsForCleanPath(SqlHelper.cleanPath(aPath), pathHints);
    }

    private ArrayList getAttributeDescriptorsForCleanPath(String aPath, Map pathHints) {
        ArrayList<AttributeDescriptorBase> result = new ArrayList<AttributeDescriptorBase>();
        ClassDescriptor cld = this;
        ObjectReferenceDescriptor ord = null;
        FieldDescriptor fld = null;
        String currPath = aPath;
        Class itemClass = null;
        while (currPath.length() > 0) {
            String segment;
            int sepPos = currPath.indexOf(".");
            if (sepPos >= 0) {
                segment = currPath.substring(0, sepPos);
                currPath = currPath.substring(sepPos + 1);
            } else {
                segment = currPath;
                currPath = "";
            }
            ord = cld.getObjectReferenceDescriptorByName(segment);
            if (ord == null) {
                ord = cld.getCollectionDescriptorByName(segment);
            }
            if (ord != null) {
                List hintClasses = (List)pathHints.get(segment);
                itemClass = hintClasses != null && hintClasses.get(0) != null ? (Class)hintClasses.get(0) : ord.getItemClass();
                cld = cld.getRepository().getDescriptorFor(itemClass);
                result.add(ord);
                continue;
            }
            fld = cld.getFieldDescriptorByName(segment);
            if (fld == null) continue;
            result.add(fld);
        }
        return result;
    }

    public Constructor getZeroArgumentConstructor() {
        if (this.zeroArgumentConstructor == null && !this.alreadyLookedupZeroArguments) {
            try {
                this.zeroArgumentConstructor = this.getClassOfObject().getConstructor(NO_PARAMS);
            }
            catch (NoSuchMethodException e) {
                try {
                    this.zeroArgumentConstructor = this.getClassOfObject().getDeclaredConstructor(NO_PARAMS);
                    this.zeroArgumentConstructor.setAccessible(true);
                }
                catch (NoSuchMethodException e2) {
                    LoggerFactory.getDefaultLogger().warn(this.getClass().getName() + ": " + "No zero argument constructor defined for " + this.getClassOfObject());
                }
            }
            this.alreadyLookedupZeroArguments = true;
        }
        return this.zeroArgumentConstructor;
    }

    public String toXML() {
        RepositoryTags tags = RepositoryTags.getInstance();
        String eol = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer(1024);
        result.append(eol);
        result.append("  <!-- Mapping for Class ");
        result.append(this.getClassNameOfObject());
        result.append(" -->");
        result.append(eol);
        result.append("  ");
        result.append(tags.getOpeningTagNonClosingById(12));
        result.append(eol);
        result.append("    ");
        result.append(tags.getAttribute(13, this.getClassNameOfObject()));
        result.append(eol);
        if (null != this.getRepository() && this.getIsolationLevel() != this.getRepository().getDefaultIsolationLevel()) {
            result.append("    ");
            result.append(tags.getAttribute(34, this.isolationLevelXml()));
            result.append(eol);
        }
        Class theProxyClass = null;
        try {
            theProxyClass = this.getProxyClass();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (theProxyClass != null) {
            if (ProxyHelper.isNormalOjbProxy(theProxyClass)) {
                result.append("    ");
                result.append(tags.getAttribute(35, "dynamic"));
                result.append(eol);
            } else {
                result.append("    ");
                result.append(tags.getAttribute(35, this.getProxyClassName()));
                result.append(eol);
            }
            result.append("        ");
            result.append(tags.getAttribute(114, "" + this.getProxyPrefetchingLimit()));
            result.append(eol);
        }
        if (this.getSchema() != null) {
            result.append("    ");
            result.append(tags.getAttribute(5, this.getSchema()));
            result.append(eol);
        }
        if (this.getTableName() != null) {
            result.append("    ");
            result.append(tags.getAttribute(14, this.getTableName()));
            result.append(eol);
        }
        if (this.getRowReaderClassName() != null) {
            result.append("    ");
            result.append(tags.getAttribute(32, this.getRowReaderClassName()));
            result.append(eol);
        }
        if (!this.acceptLocks) {
            result.append("        ");
            result.append(tags.getAttribute(78, "false"));
            result.append(eol);
        }
        if (this.getInitializationMethod() != null) {
            result.append("    ");
            result.append(tags.getAttribute(93, this.getInitializationMethod().getName()));
            result.append(eol);
        }
        if (this.getFactoryClass() != null) {
            result.append("    ");
            result.append(tags.getAttribute(100, this.getFactoryClass().getName()));
            result.append(eol);
        }
        if (this.getFactoryMethod() != null) {
            result.append("    ");
            result.append(tags.getAttribute(101, this.getFactoryMethod().getName()));
            result.append(eol);
        }
        if (this.isAlwaysRefresh()) {
            result.append("    ");
            result.append(tags.getAttribute(47, "true"));
            result.append(eol);
        }
        result.append("  >");
        result.append(eol);
        if (this.isInterface()) {
            for (int i = 0; i < this.getExtentClassNames().size(); ++i) {
                result.append("      ");
                result.append(tags.getOpeningTagNonClosingById(33));
                result.append(" ");
                result.append(tags.getAttribute(68, this.getExtentClassNames().get(i).toString()));
                result.append(" />");
                result.append(eol);
            }
        } else {
            int i;
            if (this.isExtent()) {
                for (int i2 = 0; i2 < this.getExtentClassNames().size(); ++i2) {
                    result.append("      ");
                    result.append(tags.getOpeningTagNonClosingById(33));
                    result.append(" ");
                    result.append(tags.getAttribute(68, this.getExtentClassNames().get(i2).toString()));
                    result.append(" />");
                    result.append(eol);
                }
            }
            FieldDescriptor[] fields = this.getFieldDescriptions();
            for (int i3 = 0; i3 < fields.length; ++i3) {
                result.append(fields[i3].toXML());
            }
            Vector refs = this.getObjectReferenceDescriptors();
            for (int i4 = 0; i4 < refs.size(); ++i4) {
                result.append(((ObjectReferenceDescriptor)refs.get(i4)).toXML());
            }
            Vector cols = this.getCollectionDescriptors();
            for (i = 0; i < cols.size(); ++i) {
                result.append(((CollectionDescriptor)cols.get(i)).toXML());
            }
            for (i = 0; i < this.indexes.size(); ++i) {
                IndexDescriptor indexDescriptor = (IndexDescriptor)this.indexes.elementAt(i);
                result.append(indexDescriptor.toXML());
            }
            if (this.getInsertProcedure() != null) {
                result.append(this.getInsertProcedure().toXML());
            }
            if (this.getUpdateProcedure() != null) {
                result.append(this.getUpdateProcedure().toXML());
            }
            if (this.getDeleteProcedure() != null) {
                result.append(this.getDeleteProcedure().toXML());
            }
        }
        result.append("  ");
        result.append(tags.getClosingTagById(12));
        return result.toString();
    }

    private String isolationLevelXml() {
        switch (this.getIsolationLevel()) {
            case 4: {
                return "optimistic";
            }
            case 1: {
                return "read-committed";
            }
            case 0: {
                return "read-uncommitted";
            }
            case 2: {
                return "repeatable-read";
            }
            case 3: {
                return "serializable";
            }
        }
        return "read-uncommitted";
    }

    public void setSuperClass(String classname) {
        this.superClass = classname;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public void setSuperClassFieldRef(int fieldId) {
        this.superClassFieldRef = fieldId;
    }

    public int getSuperClassFieldRef() {
        return this.superClassFieldRef;
    }

    public boolean isInterface() {
        return this.m_isInterface;
    }

    public void setIsInterface(boolean newIsInterface) {
        this.m_isInterface = newIsInterface;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isAcceptLocks() {
        return this.acceptLocks;
    }

    public void setAcceptLocks(boolean acceptLocks) {
        this.acceptLocks = acceptLocks;
    }

    public Vector getIndexes() {
        return this.indexes;
    }

    public void setIndexes(Vector indexes) {
        this.indexes = indexes;
    }

    public DescriptorRepository getRepository() {
        return this.m_repository;
    }

    public void setRepository(DescriptorRepository repository) {
        this.m_repository = repository;
    }

    public int getIsolationLevel() {
        return this.m_IsolationLevel;
    }

    public void setIsolationLevel(int isoLevel) {
        this.m_IsolationLevel = isoLevel;
    }

    private String getTableName() {
        return this.m_TableName;
    }

    public void setTableName(String str) {
        this.m_TableName = str;
    }

    public String getFullTableName() {
        if (this.getSchema() != null) {
            return this.getSchema() + "." + this.getTableName();
        }
        return this.getTableName();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        return buf.append("classNameOfObject", (Object)this.getClassNameOfObject()).append("tableName", (Object)this.getTableName()).append("schema", (Object)this.getSchema()).append("isInterface", this.isInterface()).append("extendClassNames", (Object)this.getExtentClassNames().toString()).append((Object[])this.getFieldDescriptions()).toString();
    }

    private void setInitializationMethod(Method newMethod) {
        if (newMethod != null) {
            if (newMethod.getParameterTypes().length > 0) {
                throw new MetadataException("Initialization methods must be zero argument methods: " + newMethod.getClass().getName() + "." + newMethod.getName());
            }
            if (!newMethod.isAccessible()) {
                newMethod.setAccessible(true);
            }
        }
        this.initializationMethod = newMethod;
    }

    public void setInitializationMethod(String newMethodName) {
        Method newMethod = null;
        if (newMethodName != null) {
            this.initializationMethodName = newMethodName;
            try {
                newMethod = this.getClassOfObject().getMethod(newMethodName, NO_PARAMS);
            }
            catch (NoSuchMethodException e) {
                try {
                    newMethod = this.getClassOfObject().getDeclaredMethod(newMethodName, NO_PARAMS);
                }
                catch (NoSuchMethodException e2) {
                    throw new MetadataException("Invalid initialization method, there is not a zero argument method named " + newMethodName + " on class " + this.getClassOfObject().getName() + ".");
                }
            }
        }
        this.setInitializationMethod(newMethod);
    }

    public synchronized Method getInitializationMethod() {
        if (this.initializationMethod == null) {
            this.setInitializationMethod(this.initializationMethodName);
        }
        return this.initializationMethod;
    }

    public boolean isAlwaysRefresh() {
        return this.alwaysRefresh;
    }

    public void setAlwaysRefresh(boolean alwaysRefresh) {
        this.alwaysRefresh = alwaysRefresh;
    }

    public int getProxyPrefetchingLimit() {
        return this.m_ProxyPrefetchingLimit;
    }

    public void setProxyPrefetchingLimit(int proxyPrefetchingLimit) {
        this.m_ProxyPrefetchingLimit = proxyPrefetchingLimit;
    }

    public synchronized Class getFactoryClass() {
        return this.factoryClass;
    }

    public synchronized Method getFactoryMethod() {
        if (this.factoryMethod == null && this.factoryMethodName != null) {
            this.setFactoryMethod(this.factoryMethodName);
        }
        return this.factoryMethod;
    }

    public void setFactoryClass(Class newClass) {
        this.factoryClass = newClass;
    }

    public void setFactoryClass(String newClass) {
        if (null != newClass) {
            try {
                Class<?> clazz = Class.forName(newClass);
                this.setFactoryClass(clazz);
            }
            catch (Exception e) {
                throw new MetadataException("Invalid factory class: " + newClass + ".");
            }
        } else {
            this.setFactoryClass((Class)null);
        }
    }

    private void setFactoryMethod(Method newMethod) {
        if (newMethod != null) {
            if (newMethod.getParameterTypes().length > 0) {
                throw new MetadataException("Factory methods must be zero argument methods: " + newMethod.getClass().getName() + "." + newMethod.getName());
            }
            if (!newMethod.isAccessible()) {
                newMethod.setAccessible(true);
            }
        }
        this.factoryMethod = newMethod;
    }

    public void setFactoryMethod(String factoryMethodName) {
        Method newMethod = null;
        this.factoryMethodName = factoryMethodName;
        if (factoryMethodName != null) {
            try {
                newMethod = this.getFactoryClass().getMethod(factoryMethodName, NO_PARAMS);
            }
            catch (NoSuchMethodException e) {
                try {
                    newMethod = this.getFactoryClass().getDeclaredMethod(factoryMethodName, NO_PARAMS);
                }
                catch (NoSuchMethodException e2) {
                    throw new MetadataException("Invalid factory method, there is not a zero argument method named " + factoryMethodName + " on class " + this.getFactoryClass().getName() + ".");
                }
            }
        }
        this.setFactoryMethod(newMethod);
    }

    public void setInsertProcedure(InsertProcedureDescriptor newValue) {
        this.insertProcedure = newValue;
    }

    public InsertProcedureDescriptor getInsertProcedure() {
        return this.insertProcedure;
    }

    public void setUpdateProcedure(UpdateProcedureDescriptor newValue) {
        this.updateProcedure = newValue;
    }

    public UpdateProcedureDescriptor getUpdateProcedure() {
        return this.updateProcedure;
    }

    public void setDeleteProcedure(DeleteProcedureDescriptor newValue) {
        this.deleteProcedure = newValue;
    }

    public DeleteProcedureDescriptor getDeleteProcedure() {
        return this.deleteProcedure;
    }

    public FieldDescriptor getOjbConcreteClassField() {
        if (!this.ojbConcreteFieldCheckDone) {
            this.ojbConcreteClassField = this.getFieldDescriptorByName(OJB_CONCRETE_CLASS);
            this.ojbConcreteFieldCheckDone = true;
        }
        return this.ojbConcreteClassField;
    }

    public StatementsForClassIF getStatementsForClass(ConnectionManagerIF conMan) {
        if (this.statementsForClass == null) {
            this.statementsForClass = StatementsForClassFactory.getInstance().getStatementsForClass(conMan.getConnectionDescriptor(), this);
        }
        return this.statementsForClass;
    }

    public void setPersistentFieldClassName(String pfClassName) {
        this.persistentFieldClassName = pfClassName;
    }

    public String getPersistentFieldClassName() {
        return this.persistentFieldClassName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

