/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.interceptor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class InterceptorFactory
implements Configurable {
    private static InterceptorFactory instance = null;
    private Class interceptorClassToBeUsed = null;
    static /* synthetic */ Class class$java$lang$Object;

    public static InterceptorFactory getInstance() {
        if (instance == null) {
            instance = new InterceptorFactory();
            OjbConfigurator.getInstance().configure(instance);
        }
        return instance;
    }

    public void configure(Configuration pConfig) throws ConfigurationException {
        Class clazz = pConfig.getClass("InterceptorClass", null);
        this.setInterceptorClassToBeUsed(clazz);
    }

    public Object createInterceptorFor(Object instanceToIntercept) {
        if (this.getInterceptorClassToBeUsed() != null) {
            try {
                InvocationHandler handler = (InvocationHandler)ClassHelper.newInstance(this.getInterceptorClassToBeUsed(), class$java$lang$Object == null ? (class$java$lang$Object = InterceptorFactory.class$("java.lang.Object")) : class$java$lang$Object, instanceToIntercept);
                Class[] interfaces = this.computeInterfaceArrayFor(instanceToIntercept.getClass());
                Object result = Proxy.newProxyInstance(ClassHelper.getClassLoader(), interfaces, handler);
                return result;
            }
            catch (Throwable t) {
                LoggerFactory.getDefaultLogger().error("can't use Interceptor " + this.getInterceptorClassToBeUsed().getName() + "for " + instanceToIntercept.getClass().getName(), t);
                return instanceToIntercept;
            }
        }
        return instanceToIntercept;
    }

    public Class[] computeInterfaceArrayFor(Class clazz) {
        Class superClass = clazz;
        Class[] interfaces = clazz.getInterfaces();
        if (clazz.isInterface()) {
            Class[] tempInterfaces = new Class[interfaces.length + 1];
            tempInterfaces[0] = clazz;
            System.arraycopy(interfaces, 0, tempInterfaces, 1, interfaces.length);
            interfaces = tempInterfaces;
        }
        while ((superClass = superClass.getSuperclass()) != null) {
            Class<?>[] superInterfaces = superClass.getInterfaces();
            Class[] combInterfaces = new Class[interfaces.length + superInterfaces.length];
            System.arraycopy(interfaces, 0, combInterfaces, 0, interfaces.length);
            System.arraycopy(superInterfaces, 0, combInterfaces, interfaces.length, superInterfaces.length);
            interfaces = combInterfaces;
        }
        HashMap unique = new HashMap();
        for (int i = 0; i < interfaces.length; ++i) {
            unique.put(interfaces[i].getName(), interfaces[i]);
        }
        interfaces = unique.values().toArray(new Class[unique.size()]);
        return interfaces;
    }

    public Class getInterceptorClassToBeUsed() {
        return this.interceptorClassToBeUsed;
    }

    public void setInterceptorClassToBeUsed(Class interceptorClassToBeUsed) {
        this.interceptorClassToBeUsed = interceptorClassToBeUsed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

