/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.netbios.NbtAddress;
import jcifs.smb.NtlmChallenge;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SigningDigest;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbComLogoffAndX;
import jcifs.smb.SmbComSessionSetupAndX;
import jcifs.smb.SmbComSessionSetupAndXResponse;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.smb.SmbException;
import jcifs.smb.SmbTransport;
import jcifs.smb.SmbTree;
import jcifs.smb.Trans2FindFirst2;
import jcifs.smb.Trans2FindFirst2Response;
import jcifs.util.LogStream;

public final class SmbSession {
    private static final String LOGON_SHARE = Config.getProperty("jcifs.smb.client.logonShare", null);
    private static final int LOOKUP_RESP_LIMIT = Config.getInt("jcifs.netbios.lookupRespLimit", 5);
    private static final String DOMAIN = Config.getProperty("jcifs.smb.client.domain", null);
    private static final String USERNAME = Config.getProperty("jcifs.smb.client.username", null);
    private static final int CACHE_POLICY = Config.getInt("jcifs.netbios.cachePolicy", 1200);
    static long dc_list_expiration;
    static NbtAddress[] dc_list;
    static int dc_list_index;
    static int dc_list_range;
    private int uid;
    private Vector trees;
    private boolean sessionSetup;
    private UniAddress address;
    private int port;
    private int localPort;
    private InetAddress localAddr;
    SmbTransport transport = SmbTransport.NULL_TRANSPORT;
    NtlmPasswordAuthentication auth;
    long expiration;

    static void incr_dc_list_range() {
        if (dc_list_range < LOOKUP_RESP_LIMIT && dc_list_range < dc_list.length) {
            ++dc_list_range;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NtlmChallenge getChallengeForDomain() throws SmbException, UnknownHostException {
        if (DOMAIN == null) {
            throw new SmbException("A domain was not specified");
        }
        String string = DOMAIN;
        synchronized (string) {
            if (dc_list_expiration < System.currentTimeMillis()) {
                NbtAddress[] new_dc_list;
                dc_list_expiration = System.currentTimeMillis() + (long)CACHE_POLICY * 1000L;
                if (LogStream.level > 2) {
                    SmbTransport.log.println(new Date() + ": LOGON_SHARE=" + LOGON_SHARE + ",LOOKUP_RESP_LIMIT=" + LOOKUP_RESP_LIMIT + ",DOMAIN=" + DOMAIN + ",USERNAME=" + USERNAME + ",CACHE_POLICY=" + CACHE_POLICY + ",dc_list.length=" + (dc_list == null ? 0 : dc_list.length) + ",dc_list_range=" + dc_list_range + ",dc_list_index=" + dc_list_index);
                }
                if ((new_dc_list = NbtAddress.getAllByName(DOMAIN, 28, null, null)) == null) {
                    dc_list_expiration = System.currentTimeMillis() + 10000L;
                    throw new UnknownHostException(DOMAIN);
                }
                if (new_dc_list.length >= dc_list_range) {
                    dc_list = new_dc_list;
                }
                if (dc_list_range > 1) {
                    dc_list_range /= 2;
                }
            }
            int starting_index = dc_list_index;
            do {
                NbtAddress addr;
                if (dc_list_index == dc_list_range) {
                    dc_list_index = 0;
                }
                if ((addr = dc_list[dc_list_index]) == null) continue;
                try {
                    UniAddress dc = new UniAddress(addr);
                    SmbTransport trans = SmbTransport.getSmbTransport(dc, 0);
                    if (USERNAME == null) {
                        if (LogStream.level > 2) {
                            SmbTransport.log.println("Default credentials (jcifs.smb.client.username/password) not specified. SMB signing may not work propertly. Skipping DC interrogation.");
                        }
                        trans.negotiate();
                    } else {
                        trans.getSmbSession(NtlmPasswordAuthentication.DEFAULT).getSmbTree(LOGON_SHARE, null).treeConnect(null, null);
                    }
                    SmbTransport smbTransport = trans;
                    synchronized (smbTransport) {
                        if (trans.sessions.size() > SmbTransport.SSN_LIMIT / 10) {
                            SmbSession.incr_dc_list_range();
                        }
                    }
                    ++dc_list_index;
                    return new NtlmChallenge(trans.server.encryptionKey, dc);
                }
                catch (SmbException se) {
                    if (LogStream.level > 1) {
                        SmbTransport.log.println("Failed validate DC: " + addr + ": " + se.getMessage());
                    }
                    SmbSession.dc_list[SmbSession.dc_list_index] = null;
                    SmbSession.incr_dc_list_range();
                }
            } while (++dc_list_index != starting_index);
        }
        throw new UnknownHostException("Failed to negotiate with a suitable domain controller for " + DOMAIN);
    }

    public static byte[] getChallenge(UniAddress dc) throws SmbException, UnknownHostException {
        return SmbSession.getChallenge(dc, 0);
    }

    public static byte[] getChallenge(UniAddress dc, int port) throws SmbException, UnknownHostException {
        SmbTransport trans = SmbTransport.getSmbTransport(dc, port);
        trans.negotiate();
        return trans.server.encryptionKey;
    }

    public static void logon(UniAddress dc, NtlmPasswordAuthentication auth) throws SmbException {
        SmbSession.logon(dc, 0, auth);
    }

    public static void logon(UniAddress dc, int port, NtlmPasswordAuthentication auth) throws SmbException {
        SmbTree tree = SmbTransport.getSmbTransport(dc, port).getSmbSession(auth).getSmbTree(LOGON_SHARE, null);
        if (LOGON_SHARE == null) {
            tree.treeConnect(null, null);
        } else {
            Trans2FindFirst2 req = new Trans2FindFirst2("\\", "*", 16);
            Trans2FindFirst2Response resp = new Trans2FindFirst2Response();
            tree.sendTransaction(req, resp);
        }
    }

    SmbSession(UniAddress address, int port, InetAddress localAddr, int localPort, NtlmPasswordAuthentication auth) {
        this.address = address;
        this.port = port;
        this.localAddr = localAddr;
        this.localPort = localPort;
        this.auth = auth;
        this.trees = new Vector();
    }

    synchronized SmbTree getSmbTree(String share, String service) {
        SmbTree t;
        if (share == null) {
            share = "IPC$";
        }
        Enumeration e = this.trees.elements();
        while (e.hasMoreElements()) {
            t = (SmbTree)e.nextElement();
            if (!t.matches(share, service)) continue;
            return t;
        }
        t = new SmbTree(this, share, service);
        this.trees.addElement(t);
        return t;
    }

    boolean matches(NtlmPasswordAuthentication auth) {
        return this.auth == auth || this.auth.equals(auth);
    }

    synchronized SmbTransport transport() throws SmbException {
        if (this.transport == SmbTransport.NULL_TRANSPORT) {
            this.transport = SmbTransport.getSmbTransport(this.address, this.port, this.localAddr, this.localPort);
        }
        return this.transport;
    }

    void sendTransaction(SmbComTransaction request, SmbComTransactionResponse response) throws SmbException {
        this.sessionSetup(null, null);
        request.uid = this.uid;
        request.auth = this.auth;
        this.transport().sendTransaction(request, response);
    }

    void send(ServerMessageBlock request, ServerMessageBlock response) throws SmbException {
        if (response != null) {
            response.received = false;
        }
        this.sessionSetup(request, response);
        if (response != null && response.received) {
            return;
        }
        request.uid = this.uid;
        request.auth = this.auth;
        this.transport().send(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionSetup(ServerMessageBlock andx, ServerMessageBlock andxResponse) throws SmbException {
        this.expiration = System.currentTimeMillis() + (long)SmbTransport.SO_TIMEOUT;
        SmbTransport smbTransport = this.transport();
        synchronized (smbTransport) {
            if (this.sessionSetup) {
                return;
            }
            this.transport.negotiate();
            if (LogStream.level > 3) {
                SmbTransport.log.println("sessionSetup: accountName=" + this.auth.username + ",primaryDomain=" + this.auth.domain);
            }
            SmbComSessionSetupAndX request = new SmbComSessionSetupAndX(this, andx);
            SmbComSessionSetupAndXResponse response = new SmbComSessionSetupAndXResponse(andxResponse);
            if (this.transport.isSignatureSetupRequired(this.auth)) {
                if (this.auth.hashesExternal && NtlmPasswordAuthentication.DEFAULT_PASSWORD != "") {
                    this.transport.getSmbSession(NtlmPasswordAuthentication.DEFAULT).getSmbTree(LOGON_SHARE, null).treeConnect(null, null);
                }
                request.digest = new SigningDigest(this.transport, this.auth);
            }
            request.auth = this.auth;
            this.transport.send(request, response);
            if (response.isLoggedInAsGuest && !"GUEST".equalsIgnoreCase(this.auth.username)) {
                throw new SmbAuthException(-1073741715);
            }
            this.uid = response.uid;
            this.sessionSetup = true;
            if (request.digest != null) {
                this.transport.digest = request.digest;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void logoff(boolean inError) {
        SmbTransport smbTransport = this.transport;
        synchronized (smbTransport) {
            try {
                if (!this.sessionSetup) {
                    return;
                }
                Enumeration e = this.trees.elements();
                while (e.hasMoreElements()) {
                    SmbTree t = (SmbTree)e.nextElement();
                    t.treeDisconnect(inError);
                }
                if (this.transport.server.security == 0) {
                    return;
                }
                if (!inError) {
                    SmbComLogoffAndX request = new SmbComLogoffAndX(null);
                    request.uid = this.uid;
                    try {
                        this.transport.send(request, null);
                    }
                    catch (SmbException se) {
                        // empty catch block
                    }
                }
                this.sessionSetup = false;
            }
            finally {
                this.transport = SmbTransport.NULL_TRANSPORT;
            }
            return;
        }
    }

    public String toString() {
        return "SmbSession[accountName=" + this.auth.username + ",primaryDomain=" + this.auth.domain + ",uid=" + this.uid + ",sessionSetup=" + this.sessionSetup + "]";
    }

    static {
        dc_list = null;
        dc_list_range = 1;
    }
}

