/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class OracleTypeREF
extends OracleNamedType
implements Serializable {
    static final long serialVersionUID = 3186448715463064573L;
    static boolean DEBUG = false;

    protected OracleTypeREF() {
    }

    public OracleTypeREF(String string, OracleConnection oracleConnection) {
        super(string, oracleConnection);
    }

    public OracleTypeREF(OracleTypeADT oracleTypeADT, int n, OracleConnection oracleConnection) {
        super(oracleTypeADT, n, oracleConnection);
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        if (this.m_descriptor == null) {
            if (!this.m_hasName && this.getFullName(false) == null) {
                OracleTypeADT oracleTypeADT = new OracleTypeADT(this.getParent(), this.getOrder(), (Connection)this.m_conn);
                this.m_descriptor = new StructDescriptor(oracleTypeADT, (Connection)this.m_conn);
            } else {
                this.m_descriptor = StructDescriptor.createDescriptor(this.m_fullName, this.m_conn);
            }
        }
        return (StructDescriptor)this.m_descriptor;
    }

    public int getTypeCode() {
        return 2006;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeREF::readObject");
        }
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        REF rEF = null;
        if (object != null) {
            if (object instanceof REF) {
                rEF = (REF)object;
            } else {
                DBError.check_error(59, object);
            }
        }
        return rEF;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n == 1 || n == 2) {
            StructDescriptor structDescriptor = this.createStructDescriptor();
            return new REF(structDescriptor, this.m_conn, byArray);
        }
        if (n == 3) {
            return byArray;
        }
        DBError.check_error(59, byArray);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        if (n == 1) {
            if (unpickleContext.is_null(this.null_offset)) {
                return null;
            }
            unpickleContext.skip_to(unpickleContext.m_ldsOffsets[this.lds_offset]);
            if (n2 == 9) {
                unpickleContext.skip_bytes(4);
                return null;
            }
            unpickleContext.markAndSkip();
            byte[] byArray = unpickleContext.read_ptrBytes();
            unpickleContext.reset();
            return this.toObject(byArray, n2, null);
        }
        if ((unpickleContext.read_byte() & 1) == 1 || n2 == 9) {
            unpickleContext.skip_ptrBytes();
            return null;
        }
        byte[] byArray = unpickleContext.read_ptrBytes();
        return this.toObject(byArray, n2, null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeREF::writeObject");
        }
    }
}

