/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.repackager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class Repackager {
    protected static void commandLine(String[] stringArray) {
        File[] fileArray;
        File file = null;
        Vector<File> vector = new Vector<File>();
        Vector<String> vector2 = new Vector<String>();
        Vector<File[]> vector3 = new Vector<File[]>();
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            fileArray = stringArray[n];
            if (fileArray.equals("-c")) {
                vector2.addElement(stringArray[++n]);
            } else {
                if (fileArray.equals("-h")) {
                    Repackager.help();
                    return;
                }
                if (fileArray.equals("-s")) {
                    File file2;
                    if (!(file2 = new File(stringArray[++n])).canRead()) {
                        System.err.println("ERROR: either source file " + stringArray[n] + " does not exist or cannot be read.");
                        return;
                    }
                    vector.addElement(file2);
                } else if (fileArray.equals("-t")) {
                    bl = true;
                } else if (fileArray.charAt(0) == '-') {
                    vector3.addElement(fileArray);
                } else if (file == null) {
                    file = new File((String)fileArray);
                    if (file.exists()) {
                        System.err.println("ERROR: destination file " + (String)fileArray + " already exists.");
                        return;
                    }
                } else {
                    System.err.println("ERROR: too many arguments");
                    Repackager.help();
                    return;
                }
            }
            ++n;
        }
        if (bl) {
            if (vector.size() == 0) {
                System.err.println("ERROR: must have source file name to list components.");
                Repackager.help();
                return;
            }
            fileArray = new File[vector.size()];
            int n2 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                fileArray[n2] = (File)enumeration.nextElement();
                ++n2;
            }
            Repackager.listComponents(fileArray);
        } else {
            if (vector.size() == 0 || file == null) {
                System.err.println("ERROR: must have both source and destination file names to repackage components.");
                Repackager.help();
                return;
            }
            fileArray = new File[vector.size()];
            int n3 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                fileArray[n3] = (File)enumeration.nextElement();
                ++n3;
            }
            String[] stringArray2 = new String[vector2.size()];
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                stringArray2[n3] = (String)enumeration2.nextElement();
                ++n3;
            }
            String[] stringArray3 = new String[vector3.size()];
            Enumeration enumeration3 = vector3.elements();
            while (enumeration3.hasMoreElements()) {
                stringArray3[n3] = (String)enumeration3.nextElement();
                ++n3;
            }
            Repackager.repackage(fileArray, file, stringArray2, stringArray3);
        }
    }

    protected static void help() {
        System.err.println("java Repackager <options> <source> [<destination>] ");
        System.err.println();
        System.err.println("The <source> must be an original Oracle JDBC classes file.");
        System.err.println("The <destination> is the name of the new jar or zip file.");
        System.err.println("It is an error if the <destination> already exists.");
        System.err.println("Options");
        System.err.println("-c <component>\tA component to put in the destination.");
        System.err.println("\tIf <compenent> is NLSxxx where xxx is an Oracle character set number");
        System.err.println("\tsupport for that character set will be included. If it is MSG_xxx_yyy");
        System.err.println("\tthe message file for language xxx and country yyy will be included. The");
        System.err.println("\tcountry, _yyy, is optional.");
        System.err.println("-h\tPrint this help message.");
        System.err.println("-s <other-source>\tAdditional original Oracle JDBC zip file, e.g. nls_charset.zip.");
        System.err.println("\tMust be provided if there are any -NLSxxx components. May also be used for JPub");
        System.err.println("\tand/or SQLJ zip files if supported. May be used multiple times for multiple sources.");
        System.err.println("-t\tPrints the components defined in <source>.");
        System.err.println("-v\tVerbose. Prints the name of every class and whether on not it was added.");
    }

    protected static void listComponents(File[] fileArray) {
        Method method;
        ComponentLoader componentLoader = new ComponentLoader();
        try {
            method = componentLoader.getListComponentsMethod(fileArray[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("ERROR: the first source file does not appear to be an Oracle JDBC classes file ");
            System.err.println("ERROR: or the classes file is not of an 8.1.7 or later version.");
            return;
        }
        try {
            Object[] objectArray = new Object[]{fileArray};
            method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            System.err.println("ERROR: listing components failed for an unknown reason.");
            exception.printStackTrace(System.err);
            return;
        }
    }

    public static void main(String[] stringArray) {
        Repackager.commandLine(stringArray);
    }

    protected static void repackage(File[] fileArray, File file, String[] stringArray, String[] stringArray2) {
        Method method;
        ComponentLoader componentLoader = new ComponentLoader();
        try {
            method = componentLoader.getRepackageMethod(fileArray[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("ERROR: the first source file does not appear to be an Oracle JDBC classes file ");
            System.err.println("ERROR: or the classes file is not of an 8.1.7 or later version.");
            return;
        }
        try {
            Object[] objectArray = new Object[]{fileArray, file, stringArray, stringArray2};
            method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            System.err.println("ERROR: repackaging components failed for an unknown reason.");
            exception.printStackTrace(System.err);
            return;
        }
    }

    private static class ComponentLoader
    extends ClassLoader {
        ComponentLoader() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Class getComponentClass(File file) throws ClassNotFoundException {
            InputStream inputStream = null;
            byte[] byArray = null;
            int n = 0;
            try {
                try {
                    int n2;
                    ZipFile zipFile = new ZipFile(file);
                    ZipEntry zipEntry = zipFile.getEntry("oracle/jdbc/repackager/Component.class");
                    inputStream = zipFile.getInputStream(zipEntry);
                    byArray = new byte[65536];
                    while ((n2 = inputStream.read(byArray, n, byArray.length - n)) != -1) {
                        n += n2;
                    }
                }
                catch (Exception exception) {
                    throw new ClassNotFoundException(exception.toString());
                }
                Object var6_9 = null;
                if (inputStream == null) return this.defineClass("oracle.jdbc.repackager.Component", byArray, 0, n);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
                return this.defineClass("oracle.jdbc.repackager.Component", byArray, 0, n);
            }
            catch (IOException iOException) {}
            return this.defineClass("oracle.jdbc.repackager.Component", byArray, 0, n);
        }

        public Method getListComponentsMethod(File file) throws NoSuchMethodException {
            try {
                Class clazz = this.getComponentClass(file);
                Class[] classArray = new Class[]{Class.forName("[Ljava.io.File;")};
                return clazz.getDeclaredMethod("listComponents", classArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoSuchMethodException(classNotFoundException.toString());
            }
        }

        public Method getRepackageMethod(File file) throws NoSuchMethodException {
            try {
                Class clazz = this.getComponentClass(file);
                Class[] classArray = new Class[]{Class.forName("[Ljava.io.File;"), Class.forName("java.io.File"), Class.forName("[Ljava.lang.String;"), Class.forName("[Ljava.lang.String;")};
                return clazz.getDeclaredMethod("repackageComponents", classArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoSuchMethodException(classNotFoundException.toString());
            }
        }

        public Class loadClass(String string, boolean bl) {
            return null;
        }
    }
}

