/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTIoac;
import oracle.jdbc.util.RepConversion;

public class v8TTIoac
extends TTIoac {
    public final boolean DEBUG_v8TTIoac = false;
    public byte[] oactoid;
    int oactoidl;
    int oacvsn;
    int oaccsi;
    short oaccsfrm;

    public v8TTIoac(int n, MAREngine mAREngine, short s) {
        super(n, mAREngine, s);
    }

    public v8TTIoac(MAREngine mAREngine) {
        super(mAREngine);
    }

    public void init(DBType dBType) {
        super.init(dBType);
        OracleTypeADT oracleTypeADT = (OracleTypeADT)dBType.otype;
        if (oracleTypeADT != null) {
            this.oactoid = oracleTypeADT.getTOID();
            this.oacvsn = oracleTypeADT.getVersion();
            this.oaccsi = oracleTypeADT.getCharSet();
            this.oaccsfrm = (short)oracleTypeADT.getCharSetForm();
        }
    }

    public void marshal() throws IOException, SQLException {
        super.marshal();
        this.meg.marshalDALC(this.oactoid);
        this.meg.marshalUB2(this.oacvsn);
        this.meg.marshalUB2(this.oaccsi);
        this.meg.marshalUB1(this.oaccsfrm);
    }

    public void print() {
        System.out.println("     ---- Enter: v8TTIoac.print --- ");
        super.print();
        if (this.oactoid != null) {
            System.out.println("       v8TTIoac.oacdtoid = " + RepConversion.bArray2String(this.oactoid));
            System.out.println("       v8TTIoac.oactoid.length = " + this.oactoid.length);
        } else {
            System.out.println("       v8TTIoac.oacdtoid = NULL ");
        }
        System.out.println("       v8TTIoac.oacvsn   = " + this.oacvsn);
        System.out.println("       v8TTIoac.oaccsi   = " + this.oaccsi);
        System.out.println("       v8TTIoac.oaccsfrm = " + this.oaccsfrm);
        System.out.println("     ---- Exit: v8TTIoac.print --- ");
    }

    public void setFieldsForBinds(int n, int n2) throws SQLException {
        if (n2 <= 0) {
            DBError.check_error(58, new Integer(n2));
        }
        switch (n) {
            case 96: {
                if (n2 <= 2) {
                    this.max_length = 2000;
                    break;
                }
                this.max_length = 4000 / n2;
                break;
            }
            case 1: {
                this.max_length = 4000 / n2;
                break;
            }
        }
    }

    public void unmarshal() throws IOException, SQLException {
        super.unmarshal();
        this.oactoid = this.meg.unmarshalDALC();
        this.oactoidl = this.oactoid == null ? 0 : this.oactoid.length;
        this.oacvsn = this.meg.unmarshalUB2();
        this.oaccsi = this.meg.unmarshalUB2();
        this.oaccsfrm = this.meg.unmarshalUB1();
    }
}

