/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.userManagement;

import java.util.Vector;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.Personne;
import org.esupportail.portal.channels.CStockage.config.ChannelConfiguration;
import org.esupportail.portal.channels.CStockage.exception.PropertiesException;

/**
 * Id: User.java,v 1.0 7 oct. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: User
 * Original Author: Yohan Colmant
 * Represents a user for the management
 */
public class User extends AbstractUser {
 

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(User.class);
	
	
	
	
	/**
	 * Default constructor
	 */
	public User() {
		
	}
	
	
	/**
	 * Constructor
	 * @param key The key
	 * @param displayName The displayed user name
	 */
	public User(String key, String displayName) {
		this.key = key;
		this.displayName = displayName;
	}
	
	

	/**
	 * Constructor
	 * @param key The key
	 */
	public User(String key) throws PropertiesException {
		this.key = key;
		this.displayName = getUserName(key);
	}
	
	
	/**
	 * Constructor
	 * @param pers The retrieved people
	 */
	public User(Personne pers) throws PropertiesException {

		// key
		this.key = pers.getIdentifiant();
		
		// the display name
		Vector v = pers.getAttribute(ChannelConfiguration.getInstance().getLdapUserDisplayNameAttribute());		
		if (v.size()>0)
			this.displayName = (String)v.elementAt(0);
		else this.displayName = key;
	}
	
	
	/**
	 * Return the user name from a given key
	 * @param key the user key
	 * @return the user name from a given key
	 */
	private String getUserName(String key) throws PropertiesException {
		
		String displayName = key;
		try {
			ChannelConfiguration config = ChannelConfiguration.getInstance();
			displayName = LdapUsersManagement.getUserDisplayName(config.getLdapServerUrl(), config.getLdapPeople(), config.getLdapBindDn(), config.getLdapBindPassword(), config.getLdapUserKeyAttribute(), key, config.getLdapUserDisplayNameAttribute());
		}
		catch(NamingException e) {
			log.error("getUserName"+" :: "+e);
		}
				
		return displayName;
	}
	
	

	/**
	 * Clone this object to another similary one
	 * @return this cloned object
	 */
	public Object clone() {
		User clone = new User();
		clone.setKey(this.getKey());
		clone.setDisplayName(this.getDisplayName());
		return clone;
	}
	
	

	/**
	 * Return a String from this user
	 * @return a String from this user
	 */
	public String toString() {
		return "User: "+super.toString();
	}
}
