/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.sql.CLOB;

public class OracleClobReader
extends Reader {
    CLOB clob;
    DBAccess db_access;
    DBConversion db_conversion;
    long lob_offset;
    long markedChar;
    char[] buf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;
    boolean endOfStream;

    public OracleClobReader(CLOB cLOB) throws SQLException {
        this(cLOB, cLOB.getConnection().db_access.getDefaultStreamChunkSize() / 3);
    }

    public OracleClobReader(CLOB cLOB, int n) throws SQLException {
        if (cLOB == null || n <= 0 || cLOB.getConnection() == null) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.db_access = cLOB.getConnection().db_access;
        this.db_conversion = cLOB.getConnection().conversion;
        this.clob = cLOB;
        this.lob_offset = 1L;
        this.markedChar = -1L;
        this.buf = new char[n];
        this.count = 0;
        this.pos = 0;
        this.chunkSize = n;
        this.isClosed = false;
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DBError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }

    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markedChar = this.lob_offset - (long)this.count + (long)this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    protected boolean needChars() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    this.count = this.clob.getChars(this.lob_offset, this.chunkSize, this.buf);
                    if (this.count < this.chunkSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lob_offset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    DBError.SQLToIOException(sQLException);
                }
            }
            return false;
        }
        return true;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (!this.needChars()) {
            return -1;
        }
        int n3 = n;
        int n4 = n3 + Math.min(n2, cArray.length - n);
        n3 += this.writeChars(cArray, n3, n4 - n3);
        while (n3 < n4 && this.needChars()) {
            n3 += this.writeChars(cArray, n3, n4 - n3);
        }
        return n3 - n;
    }

    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.pos < this.count;
    }

    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markedChar < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.lob_offset = this.markedChar;
        this.pos = this.count;
        this.endOfStream = false;
    }

    public long skip(long l) throws IOException {
        long l2;
        block5: {
            this.ensureOpen();
            l2 = 0L;
            if ((long)(this.count - this.pos) >= l) {
                this.pos = (int)((long)this.pos + l);
                l2 += l;
            } else {
                l2 += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    long l3 = this.clob.length() - this.lob_offset + 1L;
                    if (l3 >= l - l2) {
                        this.lob_offset += l - l2;
                        l2 += l - l2;
                        break block5;
                    }
                    this.lob_offset += l3;
                    l2 += l3;
                }
                catch (SQLException sQLException) {
                    DBError.SQLToIOException(sQLException);
                }
            }
        }
        return l2;
    }

    protected int writeChars(char[] cArray, int n, int n2) {
        int n3 = Math.min(n2, this.count - this.pos);
        System.arraycopy(this.buf, this.pos, cArray, n, n3);
        this.pos += n3;
        return n3;
    }
}

