/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.channelAction;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

import org.esupportail.portal.channels.CStockage.config.Space;
import org.esupportail.portal.channels.CStockage.exception.ChannelException;
import org.esupportail.portal.channels.CStockage.exception.PropertiesException;
import org.esupportail.portal.channels.CStockage.provider.access.ServerAccess;
import org.esupportail.portal.channels.CStockage.userManagement.User;

/**
 * Id: AbstractDefaultRenderXml.java,v 1.0 24 sept. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: AbstractDefaultRenderXml
 * Original Author: Yohan Colmant
 * The default render xml for the channel. It defines the generic bars likes navigation
 */
public abstract class AbstractDefaultRenderXml {
	
	
	
	
	/**
	 * Get the XML for the navigation bar
	 * @param spaces the visibles spaces
	 * @param currentSpace the current space used
	 * @return the XML as a StringBuffer
	 */
	public static StringBuffer getXmlNavigation(ArrayList spaces, Space currentSpace) throws PropertiesException {
		StringBuffer xmlTemp = new StringBuffer();
		
		xmlTemp.append("<SPACES>\n");
		
		if (spaces.size() >1) {

			// the default space choice			
			Iterator iter = spaces.iterator();
			while (iter.hasNext()) {
				Space space = (Space)iter.next();
				
				String key = space.getKey();
				if (space.isPersonnalSpace()) {
					if (key.equals(currentSpace.getKey()))			
						xmlTemp.append("   <PERSONAL_SPACE label=\""+space.getLabel().replaceAll("&","&amp;")+"\" key=\""+key+"\" from=\""+(new User(space.getCurrentViewer().getFromKey()).getDisplayName())+"\" current=\"true\" />\n");
					else xmlTemp.append("   <PERSONAL_SPACE label=\""+space.getLabel().replaceAll("&","&amp;")+"\" key=\""+key+"\" from=\""+(new User(space.getCurrentViewer().getFromKey()).getDisplayName())+"\" />\n");
				}
				else {
					if (key.equals(currentSpace.getKey()))			
						xmlTemp.append("   <DEFAULT_SPACE label=\""+space.getLabel().replaceAll("&","&amp;")+"\" key=\""+key+"\" current=\"true\" />\n");
					else xmlTemp.append("   <DEFAULT_SPACE label=\""+space.getLabel().replaceAll("&","&amp;")+"\" key=\""+key+"\" />\n");
				}
			}					
		}
		
		xmlTemp.append("</SPACES>\n");
		
		
		// the navigation
		xmlTemp.append("<NAVIGATION>\n");
		for (int i=0; i<currentSpace.getPathSize(); i++) {			
			xmlTemp.append("   <DIR label=\""+currentSpace.getPathElementAt(i).replaceAll("&","&amp;")+"\" link=\""+i+"\" />\n");
		}
		xmlTemp.append("</NAVIGATION>\n");
		
		return xmlTemp;		
	}
	
	
	
	
	

	
	/**
	 * Get the XML for the error bar
	 * @param error the error
	 * @param internalError if there is an internal error
	 * @return the XML as a StringBuffer
	 */
	public static StringBuffer getXmlError(ChannelException error, int internalError) {
		StringBuffer xml = new StringBuffer();
		
		xml.append("<ERRORS>");
		if ( error!=null )
			xml.append("<ERROR channelCode=\""+error.getErrorCode()+"\" />");
		else {
			if (internalError!=-1)
				xml.append("<ERROR channelCode=\""+internalError+"\" />");
		}
		xml.append("</ERRORS>");
		return xml;
	}	
	
	
	
	/**
	 * Get the XML for the info bar
	 * @param information the information message code
	 * @return the XML as a StringBuffer
	 */
	public static StringBuffer getXmlInformation(String information) {
		StringBuffer xml = new StringBuffer();
		
		if (information!=null)
			xml.append("<INFORMATION>"+information+"</INFORMATION>");
		
		return xml;
	}
		
	
	
	

	/**
	 * Return the XML representing the curent dir
	 * @param spaces the default spaces
	 * @param currentSpace the current space used
	 * @param error the error exception
	 * @return the xml generated
	 * @throws PropertiesException
	 */
	public static StringBuffer getXmlForPasswordSetting(ArrayList spaces, Space currentSpace, ChannelException error) throws PropertiesException {				
		
		ServerAccess access = currentSpace.getServerAccessObject();
		
		int erreurInterne = -1;
		
		StringBuffer xml = new StringBuffer();

		String password = "";
		
		try {
			
			password = currentSpace.getPassword();
			if (password==null)
				password="";
		}
		catch(PropertiesException e) {
			erreurInterne = e.getErrorCode();
		}
		
		// the error bar
		xml.append(getXmlError(error, -1));
		
		// the navigation bar			
		xml.append(getXmlNavigation(spaces, currentSpace));										
		
		// the password bar			
		xml.append(getXmlPassword(currentSpace.getLogin(), password, currentSpace.isLoginIsFromConfigurationFile()));												
		
		return xml;
	}
	
	
	
	

	/**
	 * Get the XML for the password bar
	 * @param login the user login used
	 * @param password the user password used
	 * @return the XML as a StringBuffer
	 */
	protected static StringBuffer getXmlPassword(String login, String password, boolean loginReadOnly) {
		StringBuffer xml = new StringBuffer();
		
		xml.append("<PASSWORD login=\""+login+"\" password=\""+password+"\" readOnly=\""+loginReadOnly+"\"/>");
		
		return xml;
	}
	
	
	
	
	/**
	 * Return the good length format to print
	 * @param contentLength the content length
	 * @return the string to show
	 */
	protected static String getLengthFormat(long contentLength) {		
   		
   		// length format
   		long intLength = contentLength;	                   		      			
		float floatLength = intLength;				
		long divInt = (intLength /1024)/1024;		
		
		String length = "";
		if (divInt > 0) {			
			length = ""+(floatLength/1024)/1024;
			int index = length.indexOf(".");					
			if (length.length() > index+3) {
				length = length.substring(0, index+3);
			}						
			length += " MB";
		}
		else {
			divInt = (intLength /1024);			
			if (divInt > 0) {			
				length = ""+(floatLength/1024);
				int index = length.indexOf(".");					
				if (length.length() > index+3) {
					length = length.substring(0, index+3);
				}						
				length += " KB";
			}
			else {			
				length = ""+(floatLength);				
				int index = length.indexOf(".");			
				if (length.length() > index+3) {
					length = length.substring(0, index+3);
				}
				length += " B";
				}
			}
		return length;
	}
	
	
	

	
	/**
	 * Return the xml used to set the last update date
	 * @param lastModified the last update date
	 * @return the string to show
	 */
	protected static StringBuffer getLastUpdateDateXml(Calendar lastModified) {		
       
   		String date = lastModified.get(Calendar.DATE)+"";
   		if (date.length()==1)
   			date = "0"+date;
   		String month = (lastModified.get(Calendar.MONTH)+1)+"";
   		if (month.length()==1)
   			month = "0"+month;
   		String year = lastModified.get(Calendar.YEAR)+"";	                       
   		String hour = (lastModified.get(Calendar.HOUR_OF_DAY))+"";
   		
   		if (hour.length()==1)
   			hour = "0"+hour;
   		String minute = lastModified.get(Calendar.MINUTE)+"";
   		if (minute.length()==1)
   			minute = "0"+minute;
   		
   		StringBuffer xml = new StringBuffer();
   		xml.append("dateLastUpdate=\""+date+"\" ");
   		xml.append("monthLastUpdate=\""+month+"\" ");
   		xml.append("yearLastUpdate=\""+year+"\" ");
   		xml.append("hourLastUpdate=\""+hour+"\" ");
   		xml.append("minuteLastUpdate=\""+minute+"\" />");
   		return xml;		
	}
	
	

}
