/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.channelAction.injac.actions;

import java.util.ArrayList;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.channelAction.BufferAction;
import org.esupportail.portal.channels.CStockage.channelAction.injac.DirectoryProperties;
import org.esupportail.portal.channels.CStockage.channelAction.injac.metadata.MetaDataConstants;
import org.esupportail.portal.channels.CStockage.channelAction.injac.metadata.MetaDataManager;
import org.esupportail.portal.channels.CStockage.config.Space;
import org.esupportail.portal.channels.CStockage.exception.CancelException;
import org.esupportail.portal.channels.CStockage.exception.InjacDocumentException;
import org.esupportail.portal.channels.CStockage.exception.NoneSelectedResourceException;
import org.esupportail.portal.channels.CStockage.exception.TooMuchSelectedException;
import org.esupportail.portal.channels.CStockage.exception.ChannelException;
import org.jasig.portal.ChannelRuntimeData;

/**
 * Id: DocumentRejectAction.java,v 1.0 27 oct. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: DocumentRejectAction
 * Original Author: Yohan Colmant
 * Action for the document reject
 */
public class DocumentRejectAction {

	
	

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(DocumentRejectAction.class);
	
	


	/**
	 * Generate the XML when we ask a reject confirmation
	 * @param runtimeData the channel runtimedata object
	 * @param buffer the buffer used for the clipboard
	 * @param stylesheet the channel stylesheet we are going to use
	 * @param metadataToSet the metatada list we want to set
	 * @param userPortalLogin the user portal login
	 * @param userGroups the user portal groups
	 * @param currentSpace the current space
	 * @param directoryProperties the current directory properties
	 * @return the XML String for this mod
	 * @throws ChannelException
	 */
	public static StringBuffer renderXmlConfirmReject(ChannelRuntimeData runtimeData, BufferAction buffer, StringBuffer stylesheet, ArrayList metadataToSet, String userPortalLogin, Vector userGroups, Space currentSpace, DirectoryProperties directoryProperties) throws ChannelException {
		
		String[] files = runtimeData.getParameterValues("listeFic");

		// Xml generated
		StringBuffer xml = new StringBuffer();
		
		// if not selected
		if (files == null || files.length==0) {						
			NoneSelectedResourceException e = new NoneSelectedResourceException();

			// log
			if (log.isDebugEnabled()){
				log.debug("renderXmlConfirmReject"+" :: NoneSelectedResourceException");
			}
			
			throw e;			
		}
		
		// if too much selected
		if (files.length>1) {			
			TooMuchSelectedException e = new TooMuchSelectedException();

			// log
			if (log.isDebugEnabled()){
				log.debug("renderXmlConfirmReject"+" :: TooMuchSelectedException");
			}
			
			throw e;			
		}
		
		// if one resource selected
		String selectionName = files[0];
		String selectionPath = currentSpace.getCurrentPath();
		String selectionFullPath = selectionPath+selectionName;
		
		// check if the resource is an injac document
		String documentType = MetaDataManager.getDirectoryType(currentSpace, selectionFullPath);
		if (documentType.equals(MetaDataConstants.INJAC_TYPE_DOCUMENT)) {
					
			
			// check if the resource state is "waiting"
			String documentState = MetaDataManager.getDocumentState(currentSpace, selectionFullPath);
			if (documentState.equals(MetaDataConstants.DOCUMENT_WAITING_STATE)) {
				selectionName = selectionName.replaceAll("&","&amp;");
				selectionName = selectionName.replaceAll("\"","&#148;");
				selectionPath = selectionPath.replaceAll("&","&amp;");
				selectionPath = selectionPath.replaceAll("\"","&#148;");
				
				xml.append("<DOCUMENT name=\""+selectionName+"\" path=\""+selectionPath+"\" type=\""+MetadataManagerAction.REJECT_DOC+"\" />");
			}
			
			else {			
				InjacDocumentException e = new InjacDocumentException();

				// log
				if (log.isDebugEnabled()){
					log.debug("renderXmlConfirmReject"+" :: InjacDocumentException");
				}
				
				throw e;				
			}						
			
		}
		
		else {
			InjacDocumentException e = new InjacDocumentException();

			// log
			if (log.isDebugEnabled()){
				log.debug("renderXmlConfirmReject"+" :: InjacDocumentException");
			}
			
			throw e;			
		}		
			
		return xml;		
	
	}
	
	
	
	
	/**
	 * Generate the XML String and reject the document
	 * @param runtimeData the runtime data channel object
	 * @param stylesheet the stylesheet we are about to use
	 * @param spaces the spaces list
	 * @param metadataToSet the metadata list we want to set
	 * @param userPortalLogin the user portal login
	 * @param userGroups the user portal groups
	 * @param currentSpace the current space
	 * @param directoryProperties the current directory properties
	 * @param buffer the buffer used for example for the clipboard
	 * @param currentSortType The current and default sort type for the resources
	 * @return the XML String for this mod
	 * @throws ChannelException
	 */
	public static StringBuffer reject(ChannelRuntimeData runtimeData, StringBuffer stylesheet, ArrayList spaces, ArrayList metadataToSet, String userPortalLogin, Vector userGroups, Space currentSpace, DirectoryProperties directoryProperties, BufferAction buffer, String currentSortType) throws ChannelException {
		String submit = runtimeData.getParameter("Submit_rej");
		String cancel = runtimeData.getParameter("Cancel_rej");
		
		
		// if submit
		if (submit != null) {			
			return MetadataManagerAction.renderXmlMetadataManager(runtimeData, stylesheet, spaces, metadataToSet, userPortalLogin, userGroups, currentSpace, directoryProperties, buffer, currentSortType);			
		}
		
		// if cancel
		else {			
			CancelException e = new CancelException();

			// log
			if (log.isDebugEnabled()){
				log.debug("reject"+" :: CancelException");
			}
			
			throw e;
		}				
				
	}
	
	
	
	
}
