/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/ 
package org.esupportail.portal.channels.CStockage.spacesPersonalization;

import java.util.Enumeration;
import java.util.Hashtable;

import org.esupportail.portal.channels.CStockage.spacesPersonalization.target.GroupForPersonalization;
import org.esupportail.portal.channels.CStockage.spacesPersonalization.target.UserForPersonalization;

 

/**
 * Id: DirectorySharingProperties,v 1.0 6 janv. 2005
 * Copyright (c) 2005 Esup Portail (www.esup-portail.org)
 * Classes: DirectorySharingProperties
 * Original Author: Yohan Colmant
 * This object represents the sharing properties of a directory
 */
public class DirectorySharingProperties {

	/**
	 * The directory full name
	 */
	private String directoryName;

	/**
	 * The label for the sharing
	 */
	//private String label;
	
	/**
	 * The users to who we share the directory
	 */
	private Hashtable users;

	/**
	 * The groups to who we share the directory
	 */
	private Hashtable groups;
	
	
	
	
	/**
	 * Constructor
	 * @param directoryName the current directory name
	 */
	public DirectorySharingProperties(String directoryName) {
		this.directoryName = directoryName;
		
		//this.sharedSpace = new Space();
		
		this.users = new Hashtable();
		
		this.groups = new Hashtable();
	}
	
	
	
	/**
	 * Clone this object to another similary one
	 * @return this cloned object
	 */
	public Object clone() {
		DirectorySharingProperties clone = new DirectorySharingProperties(this.directoryName);
		
		// clone the space
		//Server originalServer = this.getSharedSpace().getServer();
		//Server cloneServer = (Server)originalServer.clone();
		//Space originalSpace = this.getSharedSpace();
		//Space cloneSpace = (Space)originalSpace.clone();
		//ArrayList cloneSpacesList = new ArrayList(1);
		//cloneSpacesList.add(cloneSpace);
		//cloneServer.setSpaces(cloneSpacesList);
		//cloneSpace.setServer(cloneServer);
		//clone.setSharedSpace(cloneSpace);
		
		Hashtable newUsers = new Hashtable();		
		Enumeration keys = this.getUsers().keys();
		while (keys.hasMoreElements()) {
			String key = (String)keys.nextElement();
			UserForPersonalization element = (UserForPersonalization)this.getUsers().get(key);
			newUsers.put(key, element.clone());			
		}
		clone.setUsers(newUsers);
		
		Hashtable newGroups = new Hashtable();		
		keys = this.getGroups().keys();
		while (keys.hasMoreElements()) {
			String key = (String)keys.nextElement();
			GroupForPersonalization element = (GroupForPersonalization)this.getGroups().get(key);
			newGroups.put(key, element.clone());			
		}
		clone.setGroups(newGroups);
		
		return clone;
	}
	
	
	
	
	/**
	 * @return Returns the label.
	 */
	/*public String getLabel() {
		return label;
	}*/
	/**
	 * @param label The label to set.
	 */
	/*public void setLabel(String label) {
		this.label = label;
	}*/
	/**
	 * @param directoryName The directoryName to set.
	 */
	
	
	public void setDirectoryName(String directoryName) {
		this.directoryName = directoryName;
	}
	
	
	
	
	/**
	 * @return Returns the isShared.
	 */
	public boolean isSharingActive() {		
		return !(users.isEmpty() && groups.isEmpty());
	}
	
	
	
	
	/**
	 * @return Returns the groups.
	 */
	public Hashtable getGroups() {
		return groups;
	}
	/**
	 * @param groups The groups to set.
	 */
	public void setGroups(Hashtable groups) {
		this.groups = groups;
	}
	
	
	
	/**
	 * @return Returns the users.
	 */
	public Hashtable getUsers() {
		return users;
	}
	/**
	 * @param users The users to set.
	 */
	public void setUsers(Hashtable users) {
		this.users = users;
	}
	
	
	
	/**
	 * Get an xml form from this sharing properties
	 * @return an xml form from this sharing properties
	 */
	public StringBuffer getXml(String label) {
		
		StringBuffer xml = new StringBuffer();
		
		xml.append("<directory name=\""+directoryName+"\" />\n");
		
		xml.append("<label>"+label+"</label>\n");
		
		xml.append("<groups>\n");
		Enumeration g = groups.elements();
		while (g.hasMoreElements()) {
			GroupForPersonalization gr = (GroupForPersonalization)g.nextElement();
			xml.append("<group key=\""+gr.getKey()+"\" name=\""+gr.getDisplayName()+"\" read=\""+gr.isReading()+"\" write=\""+gr.isWriting()+"\" manage=\""+gr.isSharing()+"\" obliged=\""+gr.isObliged()+"\" modifiable=\""+gr.isModifiable()+"\"/>\n");
		}				
		xml.append("</groups>\n");				
		
		
		xml.append("<users>\n");		
		Enumeration u = users.elements();
		while (u.hasMoreElements()) {			
			UserForPersonalization us = (UserForPersonalization)u.nextElement();
			xml.append("<user key=\""+us.getKey()+"\" name=\""+us.getDisplayName()+"\" read=\""+us.isReading()+"\" write=\""+us.isWriting()+"\" manage=\""+us.isSharing()+"\" obliged=\""+us.isObliged()+"\" modifiable=\""+us.isModifiable()+"\"/>\n");
		}				
		xml.append("</users>\n");
		
		
		
		return xml;
		
	}
	
	
	/**
	 * Compare this object to another one
	 */
	public boolean equals(Object o) {
		DirectorySharingProperties comp = (DirectorySharingProperties)o;
		
		return comp.users.equals(this.users) && comp.groups.equals(this.groups);
		
	}
	
}
