/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.spacesPersonalization.target;


import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CStockage.exception.ServerException;
import org.esupportail.portal.channels.CStockage.userManagement.Group;
import org.jasig.portal.groups.EntityGroupImpl;

/**
 * Id: GroupForPersonalization.java,v 1.0 7 oct. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: GroupForPersonalization
 * Original Author: Yohan Colmant
 * Represents a group for the management during the personalization
 */
public class GroupForPersonalization extends Group {


	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(GroupForPersonalization.class);
	
	
	
	
	/**
	 * When used for acl management, to know if this group can be modifiable
	 */
	private boolean modifiable = true;
	
	
	

	/**
	 * When used for acl management, to know if this group has reading rights
	 */
	private boolean reading = false;
	
	/**
	 * When used for acl management, to know if this group has writing rights
	 */
	private boolean writing = false;
	
	/**
	 * If the group can manage the rights
	 */
	private boolean sharing = false;
	
	/**
	 * If the group is obliged to see the sharing
	 */
	private boolean obliged = false;
	
	
	/**
	 * The ID of this sharing in the database
	 */
	private String idOfSharing;
	
	
	
	
	
	
	/**
	 * Default constructor
	 */
	public GroupForPersonalization() {
		
	}
	
	
	
	/**
	 * Constructor
	 * @param key the group key
	 * @param displayName The displayed group name
	 * @throws ServerException
	 */
	public GroupForPersonalization(String key, String displayName) throws ServerException {
		super(key, displayName);
	}
	
	/**
	 * Constructor
	 * @param group this portal group value
	 * @throws ServerException
	 */
	public GroupForPersonalization(EntityGroupImpl group) throws ServerException {
		super(group);	
	}
	
	/**
	 * Constructor
	 * @param hierarchy this portal group hierarchy in this form: G1/G2/G3 where G1 is the root
	 * @throws ServerException
	 */
	public GroupForPersonalization(String hierarchy) throws ServerException {
		super(hierarchy);		
	}

	
	
	

	

	/**
	 * @return Returns the modifiable.
	 */
	public boolean isModifiable() {
		return modifiable;
	}
	/**
	 * @param modifiable The modifiable to set.
	 */
	public void setModifiable(boolean modifiable) {
		this.modifiable = modifiable;
	}
	
	
	
	/**
	 * @return Returns the reading.
	 */
	public boolean isReading() {
		return reading;
	}
	/**
	 * @param reading The reading to set.
	 */
	public void setReading(boolean reading) {
		this.reading = reading;
	}
	/**
	 * @param reading The reading to set. "T" or "F"
	 */
	public void setReading(String reading) {
		if (reading.equals("T"))
			this.reading = true;
		else this.reading = false;
	}
	
	/**
	 * @return Returns the writing.
	 */
	public boolean isWriting() {
		return writing;
	}
	/**
	 * @param writing The writing to set.
	 */
	public void setWriting(boolean writing) {
		this.writing = writing;
	}
	/**
	 * @param writing The writing to set. "T" or "F"
	 */
	public void setWriting(String writing) {
		if (writing.equals("T"))
			this.writing = true;
		else this.writing = false;
	}

	/**
	 * @return Returns the sharing.
	 */
	public boolean isSharing() {
		return sharing;
	}
	/**
	 * @param sharing The sharing to set.
	 */
	public void setSharing(boolean sharing) {
		this.sharing = sharing;
	}
	/**
	 * @param sharing The sharing to set. "T" or "F"
	 */
	public void setSharing(String sharing) {
		if (sharing.equals("T"))
			this.sharing = true;
		else this.sharing = false;
	}
	
	/**
	 * @return Returns the obliged.
	 */
	public boolean isObliged() {
		return obliged;
	}
	/**
	 * @param obliged The obliged to set.
	 */
	public void setObliged(boolean obliged) {
		this.obliged = obliged;
	}
	/**
	 * @param obliged The obliged to set. "T" or "F"
	 */
	public void setObliged(String obliged) {
		if (obliged.equals("T"))
			this.obliged = true;
		else this.obliged = false;
	}
		
	/**
	 * @return Returns the idOfSharing.
	 */
	public String getIdOfSharing() {
		return idOfSharing;
	}
	/**
	 * @param idOfSharing The idOfSharing to set.
	 */
	public void setIdOfSharing(String idOfSharing) {
		this.idOfSharing = idOfSharing;
	}
	
	
	
	
	

	/**
	 * Clone this object to another similary one
	 * @return this cloned object
	 */
	public Object clone() {
		GroupForPersonalization clone = new GroupForPersonalization();
		clone.setKey(this.getKey());
		clone.setDisplayName(this.getDisplayName());
		clone.setGroupHierarchy((Vector)this.getGroupHierarchy().clone());
		clone.setModifiable(this.isModifiable());
		clone.setReading(this.isReading());
		clone.setWriting(this.isWriting());
		clone.setSharing(this.isSharing());
		clone.setObliged(this.isObliged());
		clone.setIdOfSharing(this.getIdOfSharing());
		return clone;
	}
	
	/**
	 * Compare this object to another one
	 */
	public boolean equals(Object o) {
		GroupForPersonalization comp = (GroupForPersonalization)o;
		
		return comp.key.equals(this.key) && comp.reading==this.reading && comp.writing==this.writing && comp.sharing==this.sharing && comp.obliged==this.obliged;
	}
}
