<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no"/>

<xsl:param name="baseActionURL"/>


<xsl:template name="_servers">

	
	<script language="javascript">
		<![CDATA[
		
		function setPointer(theRow, theAction, thePointerStyle, theDefaultStyle) {
		    if (typeof(theRow.className) == 'undefined') {
				return false;
		    }

		    var newStyle = null;

			if(theAction == 'over') {
				newStyle = thePointerStyle;
			}
			if(theAction == 'out') {
				newStyle = theDefaultStyle;
			}

		    if (newStyle) {
		       theRow.className = newStyle;
			}
		    else {
				return false;
		    }
		    return true;
		}
		
		
		
		]]>
	</script>
	
		
        

	<table width="100%" border="0" cellspacing="5" cellpadding="5">
		<xsl:for-each select="/ROOT/servers/server">
	        <tr bgColor="#F8F8F8" onmouseout="setPointer(this, 'out', 'uportal-background-highlight', 'BODY');" onmouseover="setPointer(this, 'over', 'uportal-background-highlight', 'BODY');"> 
    	     	<td width="100%" align="left" valign="center"> 
					<a class="uportal-navigation-category" href="{$baseActionURL}?modeDav=default_server_mode&amp;index={@index}">
						<nobr>
							<xsl:value-of select="@name"/>
						</nobr>
					</a>
        	 	</td>
        	 	<td align="center" valign="center"> 
					<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=confirm_rename_server_mode&amp;index={@index}">
						<nobr>
							<img src="media/org/esupportail/portal/channels/CStockage/rename_24px.gif" border="0"/>
							&#160;
							Renommer
						</nobr>
					</a>
        	 	</td>
        	 	<td align="center" valign="center"> 
					<a class="uportal-navigation-channel" href="{$baseActionURL}?modeDav=confirm_delete_server_mode&amp;index={@index}">
						<nobr>
							<img src="media/org/esupportail/portal/channels/CStockage/delete_24px.gif" border="0"/>
							&#160;
							Supprimer
						</nobr>
					</a>
        	 	</td>
	        </tr>
        </xsl:for-each>
		
	</table>	
			
	
	
</xsl:template>
</xsl:stylesheet>