/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerEvent;

public final class PBLifeCycleEvent
extends PersistenceBrokerEvent {
    public static final int TYPE_BEFORE_INSERT = 1;
    public static final int TYPE_BEFORE_DELETE = 2;
    public static final int TYPE_BEFORE_UPDATE = 3;
    public static final int TYPE_AFTER_UPDATE = 4;
    public static final int TYPE_AFTER_DELETE = 5;
    public static final int TYPE_AFTER_LOOKUP = 6;
    public static final int TYPE_AFTER_INSERT = 7;
    private Type eventType;
    private Object target;

    public PBLifeCycleEvent(PersistenceBroker broker, Object target, Type eventType) {
        super(broker);
        this.target = target;
        this.eventType = eventType;
    }

    public PBLifeCycleEvent(PersistenceBroker broker, Type type) {
        super(broker);
        this.eventType = type;
    }

    public PersistenceBrokerAware getPersitenceBrokerAware() {
        if (this.target != null && this.target instanceof PersistenceBrokerAware) {
            return (PersistenceBrokerAware)this.target;
        }
        return null;
    }

    public void setTarget(Object obj) {
        this.target = obj;
    }

    public Object getTarget() {
        return this.target;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        buf.append("target object", this.target).append("source object", this.getSource()).append("eventType", (Object)this.eventType.toString());
        return buf.toString();
    }

    public Type getEventType() {
        return this.eventType;
    }

    public static class Type {
        public static final Type BEFORE_INSERT = new Type(1);
        public static final Type BEFORE_UPDATE = new Type(3);
        public static final Type AFTER_INSERT = new Type(7);
        public static final Type AFTER_UPDATE = new Type(4);
        public static final Type BEFORE_DELETE = new Type(2);
        public static final Type AFTER_DELETE = new Type(5);
        public static final Type AFTER_LOOKUP = new Type(6);
        private int type;

        protected Type(int type) {
            this.type = type;
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PBStateEvent)) {
                return false;
            }
            return this.type == ((Type)obj).type;
        }

        public final int hashCode() {
            return this.type;
        }

        public final int typeId() {
            return this.type;
        }

        public String toString() {
            return this.getClass().getName() + " [type= " + Type.typeAsName(this.type) + "]";
        }

        private static String typeAsName(int type) {
            if (type == 5) {
                return "AFTER_DELETE";
            }
            if (type == 6) {
                return "AFTER_LOOKUP";
            }
            if (type == 7) {
                return "AFTER_INSERT";
            }
            if (type == 4) {
                return "AFTER_UPDATE";
            }
            if (type == 2) {
                return "BEFORE_DELETE";
            }
            if (type == 1) {
                return "BEFORE_INSERT";
            }
            if (type == 3) {
                return "BEFORE_UPDATE";
            }
            throw new OJBRuntimeException("Could not find type with typeId " + type);
        }
    }
}

