/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.webdav.lib.methods.MoveMethod;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class CopyMethod
extends XMLResponseMethodBase {
    private String destination;
    private boolean overwrite = true;
    private int depth = Integer.MAX_VALUE;

    public CopyMethod() {
    }

    public CopyMethod(String source) {
        super(source);
    }

    public CopyMethod(String source, String destination) {
        this(source);
        this.setDestination(destination);
    }

    public CopyMethod(String source, String destination, boolean overwrite) {
        this(source, destination);
        this.setOverwrite(overwrite);
    }

    public CopyMethod(String source, String destination, boolean overwrite, int depth) {
        this(source, destination, overwrite);
        this.setDepth(depth);
    }

    public void setRequestHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase("Overwrite")) {
            this.setOverwrite(!headerValue.equalsIgnoreCase("F") && !headerValue.equalsIgnoreCase("False"));
        } else if (headerName.equalsIgnoreCase("Destination")) {
            this.setDestination(headerValue);
        } else if (headerName.equalsIgnoreCase("Depth")) {
            if (headerValue.equalsIgnoreCase("Infinity")) {
                this.setDepth(Integer.MAX_VALUE);
            } else if (headerValue.equalsIgnoreCase("0")) {
                this.setDepth(0);
            }
        } else {
            super.setRequestHeader(headerName, headerValue);
        }
    }

    public void setDestination(String destination) {
        this.checkNotUsed();
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setOverwrite(boolean overwrite) {
        this.checkNotUsed();
        this.overwrite = overwrite;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void setDepth(int depth) {
        this.checkNotUsed();
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getName() {
        return "COPY";
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        String absoluteDestination = MoveMethod.getAbsoluteDestination(conn, this.destination);
        super.setRequestHeader("Destination", absoluteDestination);
        if (!this.isOverwrite()) {
            super.setRequestHeader("Overwrite", "F");
        }
        switch (this.depth) {
            case 0: {
                super.setRequestHeader("Depth", "0");
                break;
            }
            case 0x7FFFFFFF: {
                super.setRequestHeader("Depth", "Infinity");
            }
        }
    }
}

