/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.channelAction.classic.sharing;

import org.esupportail.portal.channels.CStockage.spacesPersonalization.target.GroupForPersonalization;
import org.esupportail.portal.channels.CStockage.spacesPersonalization.target.UserForPersonalization;

/**
 * Id: SharedSpaceProperties.java,v 1.0 15 avr. 2005
 * Copyright (c) 2005 Esup Portail (www.esup-portail.org)
 * Classes: SharedSpaceProperties
 * Original Author: Yohan Colmant
 * 
 */
public class SharedSpaceProperties {

	/**
	 * The person who shared
	 */
	private String fromKey;
	
	/**
	 * The user if shared for a user
	 */
	private UserForPersonalization user;
	
	/**
	 * The group if shared for a group
	 */
	private GroupForPersonalization group;
	
	/**
	 * If shared for a user or a group
	 */
	private boolean sharedForUser;
	
	
	
	/**
	 * CONSTRUCTOR
	 *
	 */
	public SharedSpaceProperties() {
		
	}
	
	/**
	 * @return Returns the fromKey.
	 */
	public String getFromKey() {
		return fromKey;
	}
	/**
	 * @param fromKey The fromKey to set.
	 */
	public void setFromKey(String fromKey) {
		this.fromKey = fromKey;
	}
	/**
	 * @return Returns the group.
	 */
	public GroupForPersonalization getGroup() {
		return group;
	}
	/**
	 * @param group The group to set.
	 */
	public void setGroup(GroupForPersonalization group) {
		this.group = group;
	}
	/**
	 * @return Returns the sharedForUser.
	 */
	public boolean isSharedForUser() {
		return sharedForUser;
	}
	/**
	 * @param sharedForUser The sharedForUser to set.
	 */
	public void setSharedForUser(boolean sharedForUser) {
		this.sharedForUser = sharedForUser;
	}
	/**
	 * @return Returns the user.
	 */
	public UserForPersonalization getUser() {
		return user;
	}
	/**
	 * @param user The user to set.
	 */
	public void setUser(UserForPersonalization user) {
		this.user = user;
	}
	
	

	/**
	 * @return Returns the reading.
	 */
	public boolean isReading() {
		if (sharedForUser)
			return user.isReading();
		else return group.isReading();
	}

	
	/**
	 * @return Returns the writing.
	 */
	public boolean isWriting() {
		if (sharedForUser)
			return user.isWriting();
		else return group.isWriting();
	}


	/**
	 * @return Returns the sharing.
	 */
	public boolean isSharing() {
		if (sharedForUser)
			return user.isSharing();
		else return group.isSharing();
	}

	/**
	 * @return Returns the obliged.
	 */
	public boolean isObliged() {
		if (sharedForUser)
			return user.isObliged();
		else return group.isObliged();
	}
	
		
	/**
	 * @return Returns the idOfSharing.
	 */
	public String getIdOfSharing() {
		if (sharedForUser)
			return user.getIdOfSharing();
		else return group.getIdOfSharing();
	}
	
	
	/**
	 * @return Returns the displayName.
	 */
	public String getDisplayName() {
		if (sharedForUser)
			return user.getDisplayName();
		else return group.getDisplayName();
	}
	
	
	/**
	 * Clone this object to another similary one
	 * @return this cloned object
	 */
	public Object clone() {
		SharedSpaceProperties clone = new SharedSpaceProperties();
		clone.setFromKey(this.fromKey);
		
		if (this.isSharedForUser()) {
			clone.setUser((UserForPersonalization)this.getUser().clone());
		}
		else {
			clone.setGroup((GroupForPersonalization)this.getGroup().clone());
		}
		
		clone.setSharedForUser(this.isSharedForUser());
		
		return clone;
	}
	
}
