<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="_navigation.xsl" /> 
<xsl:import href="_error.xsl" /> 
<xsl:import href="_information.xsl" /> 
<xsl:import href="_content.xsl" /> 
<xsl:import href="_action.xsl" /> 
<xsl:import href="_password.xsl" />

<xsl:output method="html" indent="no"/>


<xsl:param name="baseActionURL"/>
<xsl:param name="downloadURL"/>
<xsl:param name="redirection"/>

<xsl:template match="/">


<!-- Form for managing spaces -->
<form name="manageSpaces" action="{$baseActionURL}?modeDav=manage_shared_spaces" method="post">	
	<input type="hidden" name="modeDav" value="manage_shared_spaces" />	
</form>



<!-- Form for the https redirection -->
<form name="redirectionHttps" action="HTTPSGateway" method="GET">	
	<input type="hidden" name="tohttps" value="{$baseActionURL}" />	
</form>

<!-- Form for the http redirection -->
<form name="redirectionHttp" action="HTTPSGateway" method="GET">	
	<input type="hidden" name="backhttp" value="{$baseActionURL}" />	
</form>


<!-- Check if we have to redirect -->
<xsl:if test="$redirection='true'">
	<xsl:choose>
	
		<!-- We ask the password -->
		<xsl:when test="/ROOT/PASSWORD/@login!=''">	
			<script language="javascript">
				if (location.protocol.indexOf('https', 0) != 0) {
					document.redirectionHttps.submit();
				}						
			</script>
		</xsl:when>
	
		<!-- We don't ask the password -->
		<xsl:otherwise>
			<script language="javascript">			
				if (location.protocol.indexOf('https', 0) != -1) {				
					document.redirectionHttp.submit();
				}						
			</script>
		</xsl:otherwise>
	
	</xsl:choose>
</xsl:if>


<!-- When we want to go into a directory -->
<form name="goIntoDirectory" action="{$baseActionURL}" method="post">
	<input type="hidden" name="targetDirectory"/>
</form>


<!-- When we download a file -->
<form name="downloadFile" action="{$downloadURL}" method="post">
	<input type="hidden" name="downloadFile"/>
</form>





<!-- GENERAL FORM -->
<form name="formulaireWebDav" action="{$baseActionURL}" method="post">

<input type="hidden" name="modeDav"/>



<table border="1" cellspacing="0" cellpadding="0" width="100%" align="center">
	
	<!--****************-->
	<!-- Navigation bar -->
	<!--****************-->		
	<!-- xsl:if test="/ROOT/NAVIGATION/DIR/@label!=''">
		<tr valign="center">
			<td valign="center">
			<xsl:call-template name="_navigation" />
			</td>
		</tr>
	</xsl:if -->
	<tr>
		<td>
			<xsl:call-template name="_navigation" />
		</td>
	</tr>
	
	<!--************-->
	<!-- Action bar -->
	<!--************-->		
	<xsl:if test="/ROOT/ACTIONS!=''">
		<tr>
			<td>
				<xsl:call-template name="_action"/>
			</td>
		</tr>
	</xsl:if>
	
	<!--***********-->
	<!-- Error bar -->
	<!--***********-->		
	<xsl:if test="/ROOT/ERRORS/ERROR/@channelCode!=''">
     <tr> 
          <td align="center" valign="center"> 
	          <img src="media/org/esupportail/portal/channels/CStockage/error_24px.gif" border="0"/>
              <xsl:call-template name="_error"/> 
          </td> 
     </tr> 
     </xsl:if>
	
	
	<!--**********-->
	<!-- Info bar -->
	<!--**********-->		
	<xsl:if test="/ROOT/INFORMATION!=''">           
     <tr> 
          <td align="center"> 
               <xsl:call-template name="_information"/> 
          </td> 
     </tr> 
     </xsl:if>

	
	
	
	<!--*******************************************-->
	<!-- Content of the server OR password setting -->
	<!--*******************************************-->
	<xsl:choose>
		<xsl:when test="/ROOT/PASSWORD/@login!=''">	
			<tr>
				<td>
					<xsl:call-template name="_password"/>
				</td>
			</tr>
		</xsl:when>
		<xsl:otherwise>
			<tr>
				<td height="100px" valign="top">
					<xsl:call-template name="_content"/>
				</td>
			</tr>
		</xsl:otherwise>
	</xsl:choose>
	
	
	
	

	<!--************-->
	<!-- Action bar -->
	<!--************-->		
	<xsl:if test="/ROOT/ACTIONS!=''">
		<tr>
			<td>
				<xsl:call-template name="_action"/>
			</td>
		</tr>
	</xsl:if>
	
	
	<!--****************-->
	<!-- Navigation bar -->
	<!--****************-->		
	<tr>
		<td>
		<xsl:call-template name="_navigation" />
		</td>
	</tr>
</table>
</form>







</xsl:template>
</xsl:stylesheet>