<?xml version='1.0' encoding='ISO-8859-1' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no"/>
<xsl:param name="baseActionURL"/>


<xsl:template match="/">
<table border="1" cellspacing="0" cellpadding="0" width="90%" bordercolor="#002863" align="center">
  <tr> 
    <td> 
          <form name="newSpace" action="{$baseActionURL}" method="post">

<input type="hidden" name="modeDav" value="set_metadata_on_document_mode"/>

      <table width="100%" align="center" border="0" cellspacing="5" cellpadding="5">
        <tr class="uportal-background-light"> 
          <td class="uportal-channel-table-header" colspan="2"> 
            <div align="center"><b>Saisie des proprits sur "<xsl:value-of select="/ROOT/metas/@documentName"/>"</b></div>            
          </td>
          
        </tr>
        
        
        <tr> 
			<td align="center"> 
				<xsl:variable name = "name" select = "/ROOT/metas/@documentName" />
				<xsl:variable name = "path" select = "/ROOT/metas/@documentPath" />
				<xsl:variable name = "type" select = "/ROOT/metas/@actionType" />
							            
				<input type="hidden" name="documentName" value="{$name}"/>
				<input type="hidden" name="documentPath" value="{$path}"/>
				<input type="hidden" name="actionType" value="{$type}"/>
		          </td>
        </tr>
        
        
         
	<xsl:for-each select="/ROOT/metas/meta">
		<tr width="80%" align="center">
			
			
			<xsl:choose>
        		<xsl:when test="@modifiable='true'">
        			<xsl:choose>
						<xsl:when test="@good-format='true'">						
							<td class="uportal-text" nowrap="true" align="right">	
													
								<xsl:choose>
									<xsl:when test="@name='reject-cause'">
										Cause de rejet
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="@name='publication-date-begin'">
												Date de dbut de publication
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="@name='publication-date-end'">
														Date de fin de publication
													</xsl:when>
													<xsl:otherwise>
														<xsl:choose>
															<xsl:when test="@name='root-file-name'">
																Fichier principal
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="@label"/>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:if test="@required='true'">
									&#160;*
								</xsl:if>
							</td>							
						</xsl:when>
	  
						<xsl:otherwise>
			 				<td class="uportal-channel-strong" style="color: red;" align="right">								
								<xsl:choose>
									<xsl:when test="@name='reject-cause'">
										Cause de rejet
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="@name='publication-date-begin'">
												Date de dbut de publication
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="@name='publication-date-end'">
														Date de fin de publication
													</xsl:when>
													<xsl:otherwise>
														<xsl:choose>
															<xsl:when test="@name='root-file-name'">
																Fichier principal
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="@label"/>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:if test="@required='true'">
									&#160;*
								</xsl:if>
							</td>
						</xsl:otherwise>
					</xsl:choose>
					
					<td class="uportal-text" nowrap="true" align="left">
						<xsl:if test="@input='text'">				
							 <input type="text" name="{@name}" size="30" class="uportal-input-text" value="{@default-value}" />        							
						</xsl:if>
				
						<xsl:if test="@input='textarea'">
							<textarea name="{@name}" rows="3" cols="40" class="uportal-input-text"  ><xsl:value-of select="@default-value"/></textarea>        								
						</xsl:if>
				
						<xsl:if test="@input='select'">					
							<xsl:variable name="default"><xsl:value-of select="@default-value"/></xsl:variable>
							<select class="uportal-input-text" name="{@name}" size="1">											
								<xsl:for-each select="choice">						
									<xsl:choose>						
										<xsl:when test="@value=$default">																											
											<option class="uportal-input-text" selected="true" value="{@value}"><xsl:value-of select="@value"/></option>
										</xsl:when>
										<xsl:otherwise>									
											<option class="uportal-input-text" value="{@value}"><xsl:value-of select="@value"/></option>
										</xsl:otherwise>
									</xsl:choose>					
								</xsl:for-each>
							</select>					
						</xsl:if>
						
						<xsl:choose>
							<xsl:when test="@name='reject-cause'">
								&#160;
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="@name='publication-date-begin'">
										&#160;format JJ/MM/AAAA. Exemple: 01/09/2004
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="@name='publication-date-end'">
												&#160;format JJ/MM/AAAA. Exemple: 30/06/2005
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="@name='root-file-name'">
														&#160;fichier qui sera affich lors du rendu
													</xsl:when>
													<xsl:otherwise>
														&#160;<xsl:value-of select="@comment"/>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
												
						
						
					</td>
								
					
        		</xsl:when>          
        		<xsl:otherwise>
        	 		<td class="uportal-copyright" style="color: gray;" align="right">
						<xsl:choose>
							<xsl:when test="@name='reject-cause'">
								Cause de rejet
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="@name='publication-date-begin'">
										Date de dbut de publication
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="@name='publication-date-end'">
												Date de fin de publication
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="@name='root-file-name'">
														Fichier principal
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="@label"/>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="@required='true'">
							&#160;*
						</xsl:if>
					</td>
					
					<td class="uportal-copyright" style="color: gray;" nowrap="true" align="left">
						<xsl:if test="@input='text'">				
					 		<input type="text" readonly="true" name="{@name}" size="30" class="uportal-input-text" value="{@default-value}" />        									
						</xsl:if>
				
						<xsl:if test="@input='textarea'">					
        	 				<textarea name="{@name}" readonly="true" rows="3" cols="40" class="uportal-input-text"  ><xsl:value-of select="@default-value"/></textarea>				
						</xsl:if>								
				
						<xsl:choose>
							<xsl:when test="@name='reject-cause'">
								&#160;
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="@name='publication-date-begin'">
										&#160;format JJ/MM/AAAA. Exemple: 01/09/2004
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="@name='publication-date-end'">
												&#160;format JJ/MM/AAAA. Exemple: 30/06/2005
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="@name='root-file-name'">
														&#160;fichier qui sera affich lors du rendu
													</xsl:when>
													<xsl:otherwise>
														&#160;<xsl:value-of select="@comment"/>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					
        		</xsl:otherwise>
        	</xsl:choose>	
			
			
			
		</tr>
	</xsl:for-each>
	
	<tr>
		<td class="uportal-text" colspan="2" align="right">
			(*) obligatoire
		</td>
	</tr>
	
	        
	        
	        
	        
	        <tr> 
	          <td colspan="2"> 
	            <div align="center"> 
	              <input class="uportal-button" type="submit" name="Submit_MD" value="Valider"/>
	              <input class="uportal-button" type="submit" name="Cancel_MD" value="Annuler"/>
            </div>
            </td>
        </tr>
        
      </table>
 		</form>
      
    </td>
  </tr>
</table>
</xsl:template>
</xsl:stylesheet>
