/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.portal.utils.webdav.acl;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.Privilege;
import org.esupportail.portal.utils.webdav.acl.EsupPermission;

public class EsupPermissions {
    protected static final Log log = LogFactory.getLog((Class)(class$org$esupportail$portal$utils$webdav$acl$EsupPermissions == null ? (class$org$esupportail$portal$utils$webdav$acl$EsupPermissions = EsupPermissions.class$("org.esupportail.portal.utils.webdav.acl.EsupPermissions")) : class$org$esupportail$portal$utils$webdav$acl$EsupPermissions));
    private TreeSet permissions = new TreeSet();
    private String userPrefix;
    private String groupPrefix;
    static /* synthetic */ Class class$org$esupportail$portal$utils$webdav$acl$EsupPermissions;

    public EsupPermissions() {
    }

    public EsupPermissions(String userPrefix, String groupPrefix) {
        this(null, userPrefix, groupPrefix);
    }

    public EsupPermissions(Ace[] aces, String userPrefix, String groupPrefix) {
        this.userPrefix = userPrefix;
        this.groupPrefix = groupPrefix;
        if (aces != null) {
            for (int i = 0; i < aces.length; ++i) {
                Ace ace = aces[i];
                boolean negative = ace.isNegative();
                String principal = ace.getPrincipal();
                boolean inherited = ace.isInherited();
                String inheritedFrom = ace.getInheritedFrom();
                boolean protectedPermission = ace.isProtected();
                Enumeration enumeration = ace.enumeratePrivileges();
                while (enumeration.hasMoreElements()) {
                    Privilege p = (Privilege)enumeration.nextElement();
                    String permissionType = p.getName();
                    EsupPermission perm = new EsupPermission(negative, principal, permissionType, inherited, inheritedFrom, protectedPermission, p.getNamespace(), userPrefix, groupPrefix);
                    this.add(perm);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"tools::webdav::acl --> Ace[] is null, can't read ACL");
        }
    }

    public EsupPermissions(Ace[] aces, String permissionType, String userPrefix, String groupPrefix) {
        this.userPrefix = userPrefix;
        this.groupPrefix = groupPrefix;
        if (aces != null) {
            for (int i = 0; i < aces.length; ++i) {
                Ace ace = aces[i];
                boolean negative = ace.isNegative();
                String principal = ace.getPrincipal();
                boolean inherited = ace.isInherited();
                String inheritedFrom = ace.getInheritedFrom();
                boolean protectedPermission = ace.isProtected();
                Enumeration enumeration = ace.enumeratePrivileges();
                while (enumeration.hasMoreElements()) {
                    Privilege p = (Privilege)enumeration.nextElement();
                    String localPermissionType = p.getName();
                    if (!localPermissionType.equals(permissionType)) continue;
                    EsupPermission perm = new EsupPermission(negative, principal, permissionType, inherited, inheritedFrom, protectedPermission, p.getNamespace(), userPrefix, groupPrefix);
                    this.add(perm);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"tools::webdav::acl --> Ace[] is null, can't read ACL");
        }
    }

    public void clone(EsupPermissions perms) {
        this.groupPrefix = perms.groupPrefix;
        this.userPrefix = perms.userPrefix;
        this.permissions = perms.permissions;
    }

    public Ace[] getSortedAceArray() {
        Vector<Ace> v = new Vector<Ace>();
        Iterator iter = this.iterator();
        boolean index = false;
        while (iter.hasNext()) {
            EsupPermission perm = (EsupPermission)iter.next();
            if (perm.isInherited() || perm.isProtectedPermission()) continue;
            Ace ace = new Ace(perm.getPrincipal(), !perm.isGrantPermission(), perm.isProtectedPermission(), perm.isInherited(), perm.getInheritedFrom());
            ace.addPrivilege(new Privilege(perm.getNamespace(), perm.getPermissionType(), null));
            v.addElement(ace);
        }
        Ace[] aces = new Ace[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            aces[i] = (Ace)v.elementAt(i);
        }
        return aces;
    }

    public boolean add(EsupPermission perm) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"tools::webdav::acl --> new permission added");
        }
        return this.permissions.add(perm);
    }

    public Vector contains(EsupPermission perm) {
        Vector<EsupPermission> perms = new Vector<EsupPermission>();
        Iterator iter = this.permissions.iterator();
        while (iter.hasNext()) {
            EsupPermission iterPerm = (EsupPermission)iter.next();
            if (!iterPerm.equals(perm)) continue;
            perms.add(iterPerm);
        }
        if (perms.size() == 0) {
            return null;
        }
        return perms;
    }

    public boolean isEmpty() {
        return this.permissions.isEmpty();
    }

    private String getStringBeforeLastSlash(String s) {
        int index = s.lastIndexOf("/");
        return s.substring(0, index);
    }

    public Iterator iterator() {
        return this.permissions.iterator();
    }

    public boolean remove(boolean negative, String principal, String permissionType) {
        TreeSet<EsupPermission> newTree = new TreeSet<EsupPermission>();
        EsupPermission perm = new EsupPermission(negative, principal, permissionType, false, null, false, "DAV:", this.userPrefix, this.groupPrefix);
        boolean deleted = false;
        Iterator iter = this.permissions.iterator();
        while (iter.hasNext()) {
            EsupPermission iterPerm = (EsupPermission)iter.next();
            boolean equals = iterPerm.equals(perm);
            if (!iterPerm.equals(perm)) {
                newTree.add(iterPerm);
                continue;
            }
            deleted = true;
        }
        this.permissions = newTree;
        return deleted;
    }

    public int size() {
        return this.permissions.size();
    }

    public String toString() {
        String s = "";
        Iterator iter = this.iterator();
        String lastInheritedFrom = "";
        while (iter.hasNext()) {
            EsupPermission perm = (EsupPermission)iter.next();
            String inh2 = perm.getInheritedFrom();
            if (inh2 == null) {
                inh2 = "";
            }
            if (!lastInheritedFrom.equals(inh2)) {
                s = s + "\n";
                lastInheritedFrom = inh2;
            }
            s = s + " *** " + perm + "\n";
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

