/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;

public abstract class CharacterConverter {
    static final String CONVERTERNAMEPREFIX = "oracle.sql.converter.CharacterConverter";
    static final String CONVERTERIDPREFIX = "0000";
    static final String EX_MAP_ORACLE_TO_UCS = "Cannot map Oracle character to Unicode.";
    static final String EX_MAP_UCS_TO_ORACLE = "Cannot map Unicode to Oracle character.";
    static final int STORE_INCREMENT = 10;
    static transient CharacterConverter[] m_converterStore;
    transient int m_groupId;
    transient int m_oracleId;

    public int getGroupId() {
        return this.m_groupId;
    }

    public static final CharacterConverter getInstance(int n) {
        CharacterConverter characterConverter = null;
        int n2 = 0;
        int n3 = 0;
        if (m_converterStore != null) {
            n3 = m_converterStore.length;
            n2 = 0;
            while (n2 < n3) {
                characterConverter = m_converterStore[n2];
                if (characterConverter == null) break;
                if (characterConverter.getOracleId() == n) {
                    return characterConverter;
                }
                ++n2;
            }
        }
        String string = Integer.toHexString(n);
        String string2 = CONVERTERNAMEPREFIX + CONVERTERIDPREFIX.substring(0, 4 - string.length()) + string;
        try {
            Class<?> clazz = Class.forName(string2);
            characterConverter = (CharacterConverter)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        if (n2 == n3) {
            int n4 = n3 + 10;
            CharacterConverter[] characterConverterArray = new CharacterConverter[n4];
            if (n3 > 0) {
                System.arraycopy(m_converterStore, 0, characterConverterArray, 0, n3);
            }
            m_converterStore = characterConverterArray;
        }
        CharacterConverter.m_converterStore[n2] = characterConverter;
        return characterConverter;
    }

    public int getOracleId() {
        return this.m_oracleId;
    }

    public abstract byte[] toOracleString(String var1) throws SQLException;

    public abstract byte[] toOracleStringWithReplacement(String var1);

    public abstract String toUnicodeString(byte[] var1, int var2, int var3) throws SQLException;

    public abstract String toUnicodeStringWithReplacement(byte[] var1, int var2, int var3);
}

