/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.sql.CLOB;

public class OracleClobWriter
extends Writer {
    DBAccess db_access;
    DBConversion db_conversion;
    CLOB clob;
    long lob_offset;
    char[] charBuf;
    byte[] nativeBuf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;

    public OracleClobWriter(CLOB cLOB) throws SQLException {
        this(cLOB, cLOB.getConnection().db_access.getDefaultStreamChunkSize() / 3);
    }

    public OracleClobWriter(CLOB cLOB, int n) throws SQLException {
        if (cLOB == null || n <= 0 || cLOB.getConnection() == null) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.db_access = cLOB.getConnection().db_access;
        this.db_conversion = cLOB.getConnection().conversion;
        this.clob = cLOB;
        this.lob_offset = 1L;
        this.charBuf = new char[n];
        this.nativeBuf = new byte[n * 3];
        this.count = 0;
        this.pos = 0;
        this.chunkSize = n;
        this.isClosed = false;
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            this.isClosed = true;
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DBError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.count > 0) {
                    this.clob.putString((int)this.lob_offset, new String(this.charBuf, 0, this.count));
                    this.lob_offset += (long)this.count;
                    this.count = 0;
                }
            }
            catch (SQLException sQLException) {
                DBError.SQLToIOException(sQLException);
            }
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n3 = n;
            int n4 = n3 + Math.min(n2, cArray.length - n);
            while (n3 < n4) {
                int n5 = Math.min(this.chunkSize - this.count, n4 - n3);
                System.arraycopy(cArray, n3, this.charBuf, this.count, n5);
                n3 += n5;
                this.count += n5;
                if (this.count < this.chunkSize) continue;
                this.flushBuffer();
            }
        }
    }
}

