/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nl;

import java.util.Vector;

public final class NVTokens {
    public static final int TKN_ERROR = -1;
    public static final int TKN_NONE = 0;
    public static final int TKN_LPAREN = 1;
    public static final int TKN_RPAREN = 2;
    public static final int TKN_COMMA = 3;
    public static final int TKN_EQUAL = 4;
    public static final int TKN_LITERAL = 8;
    public static final int TKN_EOS = 9;
    private static final char TKN_LPAREN_VALUE = '(';
    private static final char TKN_RPAREN_VALUE = ')';
    private static final char TKN_COMMA_VALUE = ',';
    private static final char TKN_EQUAL_VALUE = '=';
    private static final char TKN_BKSLASH_VALUE = '\\';
    private static final char TKN_DQUOTE_VALUE = '\"';
    private static final char TKN_SQUOTE_VALUE = '\'';
    private static final char TKN_EOS_VALUE = '%';
    private static final char TKN_SPC_VALUE = ' ';
    private static final char TKN_TAB_VALUE = '\t';
    private static final char TKN_LF_VALUE = '\n';
    private static final char TKN_CR_VALUE = '\r';
    private Vector _tkType = null;
    private Vector _tkValue = null;
    private int _numTokens = 0;
    private int _tkPos = 0;

    private void _addToken(int n, char c) {
        this._addToken(n, String.valueOf(c));
    }

    private void _addToken(int n, String string) {
        this._tkType.addElement(new Integer(n));
        this._tkValue.addElement(string);
        ++this._numTokens;
    }

    private static boolean _isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    private static String _trimWhiteSpace(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = n;
        while (n2 < n && NVTokens._isWhiteSpace(string.charAt(n2))) {
            ++n2;
        }
        while (n2 < n3 && NVTokens._isWhiteSpace(string.charAt(n3 - 1))) {
            --n3;
        }
        return string.substring(n2, n3);
    }

    public void eatToken() {
        if (this._tkPos < this._numTokens) {
            ++this._tkPos;
        }
    }

    public String getLiteral() {
        String string = null;
        if (this._tkValue != null && this._tkPos < this._numTokens) {
            string = (String)this._tkValue.elementAt(this._tkPos);
        }
        return string;
    }

    public int getToken() {
        if (this._tkType == null) {
            return -1;
        }
        if (this._tkPos < this._numTokens) {
            return (Integer)this._tkType.elementAt(this._tkPos);
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public boolean parseTokens(String var1_1) {
        this._numTokens = 0;
        this._tkPos = 0;
        this._tkType = new Vector<E>(25, 25);
        this._tkValue = new Vector<E>(25, 25);
        var2_2 = var1_1.length();
        var3_3 = var1_1.toCharArray();
        var4_4 = 0;
        ** GOTO lbl56
        {
            ++var4_4;
            do {
                if (var4_4 < var2_2 && NVTokens._isWhiteSpace(var3_3[var4_4])) continue block6;
                switch (var3_3[var4_4]) {
                    case '(': {
                        this._addToken(1, '(');
                        ++var4_4;
                        break;
                    }
                    case '=': {
                        this._addToken(4, '=');
                        ++var4_4;
                        break;
                    }
                    case ')': {
                        this._addToken(2, ')');
                        ++var4_4;
                        break;
                    }
                    case ',': {
                        this._addToken(3, ',');
                        ++var4_4;
                        break;
                    }
                    default: {
                        var5_5 = var4_4;
                        var6_6 = -1;
                        var7_7 = false;
                        var8_8 = '\"';
                        if (var3_3[var4_4] == '\'' || var3_3[var4_4] == '\"') {
                            var7_7 = true;
                            var8_8 = var3_3[var4_4];
                            ++var4_4;
                        }
                        while (var4_4 < var2_2) {
                            if (var3_3[var4_4] == '\\') {
                                var4_4 += 2;
                                continue;
                            }
                            if (var7_7) {
                                if (var3_3[var4_4] == var8_8) {
                                    var6_6 = ++var4_4;
                                    break;
                                }
                            } else if (var3_3[var4_4] == '(' || var3_3[var4_4] == ')' || var3_3[var4_4] == ',' || var3_3[var4_4] == '=') {
                                var6_6 = var4_4;
                                break;
                            }
                            ++var4_4;
                        }
                        if (var6_6 == -1) {
                            var6_6 = var4_4;
                        }
                        this._addToken(8, NVTokens._trimWhiteSpace(var1_1.substring(var5_5, var6_6)));
                        break;
                    }
                }
lbl56:
                // 6 sources

            } while (var4_4 < var2_2);
        }
        this._addToken(9, '%');
        return true;
    }

    public String popLiteral() {
        String string = null;
        if (this._tkValue != null && this._tkPos < this._numTokens) {
            string = (String)this._tkValue.elementAt(this._tkPos++);
        }
        return string;
    }

    public int popToken() {
        int n = 0;
        if (this._tkType == null) {
            n = -1;
        } else if (this._tkPos < this._numTokens) {
            n = (Integer)this._tkType.elementAt(this._tkPos++);
        }
        return n;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public String toString() {
        if (this._tkType == null) {
            return "*NO TOKENS*";
        }
        String string = "Tokens";
        int n = 0;
        while (n < this._numTokens) {
            string = String.valueOf(string) + " : " + this._tkValue.elementAt(n);
            ++n;
        }
        return string;
    }
}

