/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.sql.ClobDBAccess;
import oracle.sql.Datum;

public class CLOB
extends Datum
implements Clob {
    public static final int MAX_CHUNK_SIZE = 32512;
    OracleConnection m_conn;
    ClobDBAccess m_dbaccess;
    private int m_dbChunkSize;

    protected CLOB() {
    }

    public CLOB(OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public CLOB(OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (oracleConnection != null) {
            this.m_conn = oracleConnection;
        } else {
            DBError.check_error(68, "Connection is null");
        }
        this.m_dbaccess = oracleConnection.createClobDBAccess();
        this.m_dbChunkSize = -1;
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public Reader characterStreamValue() throws SQLException {
        return this.getCharacterStream();
    }

    public static CLOB empty_lob() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        CLOB cLOB = new CLOB();
        cLOB.setShareBytes(byArray);
        return cLOB;
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        return new OracleClobOutputStream(this, this.getBufferSize());
    }

    public InputStream getAsciiStream() throws SQLException {
        return new OracleClobInputStream(this, this.getBufferSize());
    }

    public int getBufferSize() throws SQLException {
        int n = this.getChunkSize();
        if (n >= 32512 || n <= 0) {
            return 32512;
        }
        return 32512 / n * n;
    }

    public Writer getCharacterOutputStream() throws SQLException {
        return new OracleClobWriter(this, this.getBufferSize());
    }

    public Reader getCharacterStream() throws SQLException {
        return new OracleClobReader(this, this.getBufferSize());
    }

    public int getChars(long l, int n, char[] cArray) throws SQLException {
        return this.getDBAccess().getChars(this, l, n, cArray);
    }

    public int getChunkSize() throws SQLException {
        if (this.m_dbChunkSize <= 0) {
            this.m_dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.m_dbChunkSize;
    }

    public OracleConnection getConnection() throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = (OracleConnection)new OracleDriver().defaultConnection();
        }
        return this.m_conn;
    }

    public ClobDBAccess getDBAccess() throws SQLException {
        if (this.m_dbaccess == null) {
            if (this.isEmptyLob()) {
                DBError.throwSqlException(98);
            }
            this.m_dbaccess = this.getConnection().createClobDBAccess();
        }
        return this.m_dbaccess;
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public String getSubString(long l, int n) throws SQLException {
        if (n < 0 || l < 1L) {
            DBError.check_error(68, "getSubString");
        }
        if (n == 0) {
            return new String();
        }
        char[] cArray = new char[n];
        int n2 = this.getChars(l, n, cArray);
        if (n2 > 0) {
            return new String(cArray, 0, n2);
        }
        return new String();
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public boolean isEmptyLob() throws SQLException {
        return (this.shareBytes()[5] & 0x10) != 0;
    }

    public long length() throws SQLException {
        return this.getDBAccess().length(this);
    }

    public Object makeJdbcArray(int n) {
        return new CLOB[n];
    }

    public long position(String string, long l) throws SQLException {
        return this.getDBAccess().position(this, string, l);
    }

    public long position(Clob clob, long l) throws SQLException {
        return this.getDBAccess().position(this, (CLOB)clob, l);
    }

    public int putChars(long l, char[] cArray) throws SQLException {
        return this.getDBAccess().putChars(this, l, cArray);
    }

    public int putString(long l, String string) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "putString()");
        }
        if (string == null || string.length() == 0) {
            return 0;
        }
        return this.putChars(l, string.toCharArray());
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public Object toJdbc() throws SQLException {
        return this;
    }
}

