/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.ojb.broker.MtoNImplementor;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class MtoNBroker {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$MtoNBroker == null ? (class$org$apache$ojb$broker$core$MtoNBroker = MtoNBroker.class$("org.apache.ojb.broker.core.MtoNBroker")) : class$org$apache$ojb$broker$core$MtoNBroker);
    private PersistenceBroker pb;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$MtoNBroker;

    public MtoNBroker(PersistenceBroker broker) {
        this.pb = broker;
    }

    public void storeMtoNImplementor(CollectionDescriptor cod, Object obj, Object otherObj, Collection mnKeys) {
        ClassDescriptor cld = this.pb.getDescriptorRepository().getDescriptorFor(obj.getClass());
        ValueContainer[] pkValues = this.pb.serviceBrokerHelper().getKeyValues(cld, obj);
        String[] pkColumns = cod.getFksToThisClass();
        otherObj = ProxyHelper.getRealObject(otherObj);
        ClassDescriptor otherCld = this.pb.getDescriptorRepository().getDescriptorFor(otherObj.getClass());
        ValueContainer[] otherPkValues = this.pb.serviceBrokerHelper().getKeyValues(otherCld, otherObj);
        String[] otherPkColumns = cod.getFksToItemClass();
        String table = cod.getIndirectionTable();
        Key key = new Key(otherPkValues);
        if (mnKeys.contains(key)) {
            return;
        }
        String insertStmt = this.pb.serviceSqlGenerator().getInsertMNStatement(table, pkColumns, otherPkColumns);
        this.pb.serviceJdbcAccess().executeUpdateSQL(insertStmt, cld, pkValues, otherPkValues);
    }

    public Collection getMtoNImplementor(CollectionDescriptor cod, Object obj) {
        FieldDescriptor[] itemClassPKFields;
        ResultSetAndStatement rs = null;
        ArrayList<Key> result = new ArrayList<Key>();
        ClassDescriptor cld = this.pb.getDescriptorRepository().getDescriptorFor(obj.getClass());
        ValueContainer[] pkValues = this.pb.serviceBrokerHelper().getKeyValues(cld, obj);
        String[] pkColumns = cod.getFksToThisClass();
        String[] fkColumns = cod.getFksToItemClass();
        String table = cod.getIndirectionTable();
        String selectStmt = this.pb.serviceSqlGenerator().getSelectMNStatement(table, fkColumns, pkColumns);
        ClassDescriptor itemCLD = this.pb.getDescriptorRepository().getDescriptorFor(cod.getItemClass());
        Collection extents = this.pb.getDescriptorRepository().getAllConcreteSubclassDescriptors(itemCLD);
        if (extents.size() > 0) {
            itemCLD = (ClassDescriptor)extents.iterator().next();
        }
        if ((itemClassPKFields = itemCLD.getPkFields()).length != fkColumns.length) {
            throw new PersistenceBrokerException("All pk fields of the element-class need to be declared in the indirection table. Element class is " + itemCLD.getClassNameOfObject() + " with " + itemClassPKFields.length + " pk-fields." + " Declared 'fk-pointing-to-element-class' elements in collection-descriptor are" + fkColumns.length);
        }
        try {
            rs = this.pb.serviceJdbcAccess().executeSQL(selectStmt, cld, pkValues, false);
            while (rs.m_rs.next()) {
                ValueContainer[] row = new ValueContainer[fkColumns.length];
                for (int i = 0; i < row.length; ++i) {
                    row[i] = new ValueContainer(rs.m_rs.getObject(i + 1), itemClassPKFields[i].getJdbcType());
                }
                result.add(new Key(row));
            }
        }
        catch (Exception e) {
            throw new PersistenceBrokerException(e);
        }
        finally {
            rs.close();
        }
        return result;
    }

    public void deleteMtoNImplementor(CollectionDescriptor cod, Object obj) {
        ClassDescriptor cld = this.pb.getDescriptorRepository().getDescriptorFor(obj.getClass());
        ValueContainer[] pkValues = this.pb.serviceBrokerHelper().getKeyValues(cld, obj);
        String[] pkColumns = cod.getFksToThisClass();
        String table = cod.getIndirectionTable();
        String deleteStmt = this.pb.serviceSqlGenerator().getDeleteMNStatement(table, pkColumns, null);
        this.pb.serviceJdbcAccess().executeUpdateSQL(deleteStmt, cld, pkValues, null);
    }

    public void deleteMtoNImplementor(CollectionDescriptor cod, Object obj, Iterator collectionIterator, Collection mnKeys) {
        if (mnKeys.isEmpty() || collectionIterator == null) {
            return;
        }
        ArrayList workList = new ArrayList(mnKeys);
        ClassDescriptor relatedCld = this.pb.getDescriptorRepository().getDescriptorFor(cod.getItemClass());
        while (collectionIterator.hasNext()) {
            Object relatedObj = collectionIterator.next();
            Key relatedObjKeys = new Key(this.pb.serviceBrokerHelper().getKeyValues(relatedCld, relatedObj, true));
            workList.remove(relatedObjKeys);
        }
        ClassDescriptor cld = this.pb.getDescriptorRepository().getDescriptorFor(obj.getClass());
        ValueContainer[] pkValues = this.pb.serviceBrokerHelper().getKeyValues(cld, obj);
        String[] pkColumns = cod.getFksToThisClass();
        String[] fkColumns = cod.getFksToItemClass();
        String table = cod.getIndirectionTable();
        Iterator iter = workList.iterator();
        while (iter.hasNext()) {
            ValueContainer[] fkValues = ((Key)iter.next()).m_containers;
            String deleteStmt = this.pb.serviceSqlGenerator().getDeleteMNStatement(table, pkColumns, fkColumns);
            this.pb.serviceJdbcAccess().executeUpdateSQL(deleteStmt, cld, pkValues, fkValues);
        }
    }

    public void storeMtoNImplementor(MtoNImplementor m2n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Storing M2N implementor [" + m2n + "]");
        }
        this.insertOrDeleteMtoNImplementor(m2n, true);
    }

    public void deleteMtoNImplementor(MtoNImplementor m2n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deleting M2N implementor [" + m2n + "]");
        }
        this.insertOrDeleteMtoNImplementor(m2n, false);
    }

    private void insertOrDeleteMtoNImplementor(MtoNImplementor m2nImpl, boolean insert) throws PersistenceBrokerException {
        DescriptorRepository dr = this.pb.getDescriptorRepository();
        Object leftObject = m2nImpl.getLeftObject();
        Class<?> leftClass = leftObject.getClass();
        Object rightObject = m2nImpl.getRightObject();
        Class<?> rightClass = rightObject.getClass();
        ClassDescriptor leftCld = dr.getDescriptorFor(leftClass);
        ClassDescriptor rightCld = dr.getDescriptorFor(rightClass);
        Vector leftColds = leftCld.getCollectionDescriptors();
        CollectionDescriptor wanted = this.findCollectionDescriptor(leftClass, rightClass, leftColds);
        if (leftObject != null && rightObject != null) {
            ValueContainer[] leftPkValues = this.pb.serviceBrokerHelper().getKeyValues(leftCld, leftObject);
            ValueContainer[] rightPkValues = this.pb.serviceBrokerHelper().getKeyValues(rightCld, rightObject);
            String[] pkLeftColumns = wanted.getFksToThisClass();
            String[] pkRightColumns = wanted.getFksToItemClass();
            String table = wanted.getIndirectionTable();
            if (table == null) {
                throw new PersistenceBrokerException("Can't remove MtoN implementor withou an indirection table");
            }
            String stmt = null;
            stmt = insert ? this.pb.serviceSqlGenerator().getInsertMNStatement(table, pkLeftColumns, pkRightColumns) : this.pb.serviceSqlGenerator().getDeleteMNStatement(table, pkLeftColumns, pkRightColumns);
            this.pb.serviceJdbcAccess().executeUpdateSQL(stmt, leftCld, leftPkValues, rightPkValues);
        }
    }

    private CollectionDescriptor findCollectionDescriptor(Class leftClass, Class rightClass, Vector leftColds) {
        Iterator iter = leftColds.iterator();
        while (iter.hasNext()) {
            CollectionDescriptor element = (CollectionDescriptor)iter.next();
            if (!element.getItemClass().isAssignableFrom(rightClass)) continue;
            return element;
        }
        throw new PersistenceBrokerException("Can't find reasonable collection descriptor for MtoN implementor left[" + leftClass + "] right[" + rightClass + "]");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Key {
        final ValueContainer[] m_containers;

        Key(ValueContainer[] containers) {
            this.m_containers = new ValueContainer[containers.length];
            for (int i = 0; i < containers.length; ++i) {
                Object value = containers[i].getValue();
                JdbcType type = containers[i].getJdbcType();
                if (value instanceof Number) {
                    value = new Long(((Number)value).longValue());
                }
                this.m_containers[i] = new ValueContainer(value, type);
            }
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object[])this.m_containers, (Object[])otherKey.m_containers);
            return eb.isEquals();
        }

        public int hashCode() {
            HashCodeBuilder hb = new HashCodeBuilder();
            hb.append((Object[])this.m_containers);
            return hb.toHashCode();
        }
    }
}

