/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.channelAction.injac;

import org.esupportail.portal.channels.CStockage.channelAction.injac.metadata.parse.ParseRequiredMetaData;

/**
 * Id: DirectoryProperties.java,v 1.0 21 oct. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: DirectoryProperties
 * Original Author: Yohan Colmant
 * Contains the properties on a directory like its type, rights ....
 */
public class DirectoryProperties {

	/**
	 * The directory type: space or document
	 */
	private String type;
	
	/**
	 * If user is writer in the case of a space
	 */
	private boolean userIsWriter = false;
	
	/**
	 * If user is editor in the case of a space
	 */
	private boolean userIsEditor = false;
	
	/**
	 * If user is manager in the case of a space
	 */
	private boolean userIsManager = false;
	
	/**
	 * The root document name witch is showed
	 */
	private String rootDocumentName;
	
	/**
	 * The metadata list for the space
	 */
	private ParseRequiredMetaData metadataList;
	
	
	/**
	 * Constructor
	 * @param type The directory type: space or document
	 * @param userIsWriter If user is writer in the case of a space
	 * @param userIsEditor If user is editor in the case of a space
	 * @param userIsManager If user is manager in the case of a space
	 * @param rootDocumentName The root document name witch is showed
	 */
	public DirectoryProperties(String type, boolean userIsWriter, boolean userIsEditor, boolean userIsManager, String rootDocumentName) {		
		this.type = type;		
		this.userIsWriter = userIsWriter;
		this.userIsEditor = userIsEditor;
		this.userIsManager = userIsManager;
		this.rootDocumentName = rootDocumentName;
	}
	
	
	/**
	 * Return the resource name without the last dot. For example, toto.txt will give toto
	 * @param name the resource's name
	 * @return the resource name without the last dot.
	 */
	public static String getResourceNameWithoutLastDot(String name) {
		int index = name.lastIndexOf(".");
		if (index!=-1) {
			return name.substring(0, index); 
		}
		else return name;
	}
	
	
	/**
	 * @return Returns the type.
	 */
	public String getType() {
		return type;
	}
	/**
	 * @return Returns the userIsEditor.
	 */
	public boolean isUserEditor() {
		return userIsEditor;
	}
	/**
	 * @return Returns the userIsManager.
	 */
	public boolean isUserManager() {
		return userIsManager;
	}
	/**
	 * @return Returns the userIsWriter.
	 */
	public boolean isUserWriter() {
		return userIsWriter;
	}
	
	
	
	
	
	
	/**
	 * @param type The type to set.
	 */
	public void setType(String type) {
		this.type = type;
	}
	/**
	 * @param userIsEditor The userIsEditor to set.
	 */
	public void setUserIsEditor(boolean userIsEditor) {
		this.userIsEditor = userIsEditor;
	}
	/**
	 * @param userIsManager The userIsManager to set.
	 */
	public void setUserIsManager(boolean userIsManager) {
		this.userIsManager = userIsManager;
	}
	/**
	 * @param userIsWriter The userIsWriter to set.
	 */
	public void setUserIsWriter(boolean userIsWriter) {
		this.userIsWriter = userIsWriter;
	}	
	
	
	
	/**
	 * @return Returns the rootDocumentName.
	 */
	public String getRootDocumentName() {
		return rootDocumentName;
	}
	/**
	 * @param rootDocumentName The rootDocumentName to set.
	 */
	public void setRootDocumentName(String rootDocumentName) {
		this.rootDocumentName = rootDocumentName;
	}
	
	
	
	/**
	 * @return Returns the metadataList.
	 */
	public ParseRequiredMetaData getMetadataList() {
		return metadataList;
	}
	/**
	 * @param metadataList The metadataList to set.
	 */
	public void setMetadataList(ParseRequiredMetaData metadataList) {
		this.metadataList = metadataList;
	}
}
