/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.spacesPersonalization.target;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Id: Personalization.java,v 1.0 23 sept. 2005
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: Personalization
 * Original Author: Yohan Colmant
 * Represents an object used for the management during the personalization
 */
public class Personalization {
 

	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(Personalization.class);
	
	


	/**
	 * When used for acl management, to know if this user can be modifiable
	 */
	private boolean modifiable = true;
	
	
	
	/**
	 * When used for acl management, to know if this user has reading rights. -1:deny, 0:none, 1:grant
	 */
	private int reading = 0;
	
	/**
	 * When used for acl management, to know if this user has writing rights. -1:deny, 0:none, 1:grant
	 */
	private int writing = 0;

	/**
	 * If the user can manage the rights. -1:deny, 0:none, 1:grant
	 */
	private int sharing = 0;
	
	/**
	 * If the user is obliged to see the sharing
	 */
	private boolean obliged = false;
	
	
	/**
	 * Add the rights into the database
	 */
	//private boolean addInDatabase = true;
	
	/**
	 * The ACL is inerited
	 */
	private boolean inheritedAcl = false;
	
	/**
	 * The path from where this right is inherited
	 */
	private String inheritedFrom;
	
	/**
	 * The ID of this sharing in the database
	 */
	private String idOfSharing;
	
	/**
	 * If the principal is visible or not
	 */
	private boolean visible;
	
	/**
	 * If this one is a security right
	 */
	private boolean securityRight;
	
	
	
	/**
	 * Default constructor
	 */
	public Personalization() {
		this.visible = true;
		this.securityRight = false;
	}
	
	
	
	/**
	 * @return Returns the securityRight.
	 */
	public boolean isSecurityRight() {
		return securityRight;
	}
	/**
	 * @param securityRight The securityRight to set.
	 */
	public void setSecurityRight(boolean securityRight) {
		this.securityRight = securityRight;
	}
	
	/**
	 * @return Returns the inheritedFrom.
	 */
	public String getInheritedFrom() {
		return inheritedFrom;
	}
	/**
	 * @param inheritedFrom The inheritedFrom to set.
	 */
	public void setInheritedFrom(String inheritedFrom) {
		this.inheritedFrom = inheritedFrom;
	}
	
	/**
	 * @return Returns the addInDatabase.
	 */
	/*public boolean isAddInDatabase() {
		return addInDatabase;
	}*/
	/**
	 * @param addInDatabase The addInDatabase to set.
	 */
	/*public void setAddInDatabase(boolean addInDatabase) {
		this.addInDatabase = addInDatabase;
	}*/
	
	/**
	 * @return Returns the inheritableAcl.
	 */
	public boolean isInheritedAcl() {
		return inheritedAcl;
	}
	/**
	 * @param inheritedAcl The inheritedAcl to set.
	 */
	public void setInheritedAcl(boolean inheritedAcl) {
		this.inheritedAcl = inheritedAcl;
	}
	/**
	 * @return Returns the modifiable.
	 */
	public boolean isModifiable() {
		return modifiable;
	}
	/**
	 * @param modifiable The modifiable to set.
	 */
	public void setModifiable(boolean modifiable) {
		this.modifiable = modifiable;
	}

	/**
	 * @return Returns the reading.
	 */
	public int getReading() {
		return reading;
	}
	/**
	 * @param reading The reading to set.
	 */
	public void setReading(int reading) {
		this.reading = reading;
	}
	/**
	 * @param reading The reading to set. "T" or "F"
	 */
	/*public void setReading(String reading) {
		if (reading.equals("T"))
			this.reading = true;
		else this.reading = false;
	}*/
	
	/**
	 * @return Returns the writing.
	 */
	public int getWriting() {
		return writing;
	}
	/**
	 * @param writing The writing to set.
	 */
	public void setWriting(int writing) {
		this.writing = writing;
	}
	/**
	 * @param writing The writing to set. "T" or "F"
	 */
	/*public void setWriting(String writing) {
		if (writing.equals("T"))
			this.writing = true;
		else this.writing = false;
	}*/

	/**
	 * @return Returns the sharing.
	 */
	public int getSharing() {
		return sharing;
	}
	/**
	 * @param sharing The sharing to set.
	 */
	public void setSharing(int sharing) {
		this.sharing = sharing;
	}
	/**
	 * @param sharing The sharing to set. "T" or "F"
	 */
	/*public void setSharing(String sharing) {
		if (sharing.equals("T"))
			this.sharing = true;
		else this.sharing = false;
	}*/
	
	/**
	 * @return Returns the obliged.
	 */
	public boolean isObliged() {
		return obliged;
	}
	/**
	 * @param obliged The obliged to set.
	 */
	public void setObliged(boolean obliged) {
		this.obliged = obliged;
	}
	/**
	 * @param obliged The obliged to set. "T" or "F"
	 */
	public void setObliged(String obliged) {
		if (obliged.equals("T"))
			this.obliged = true;
		else this.obliged = false;
	}
	
	
	
	/**
	 * @return Returns the idOfSharing.
	 */
	public String getIdOfSharing() {
		return idOfSharing;
	}
	/**
	 * @param idOfSharing The idOfSharing to set.
	 */
	public void setIdOfSharing(String idOfSharing) {
		this.idOfSharing = idOfSharing;
	}
	
	/**
	 * @return Returns the visible.
	 */
	public boolean isVisible() {
		return visible;
	}
	/**
	 * @param visible The visible to set.
	 */
	public void setVisible(boolean visible) {
		this.visible = visible;
	}
	
	/**
	 * Clone this object to another similary one
	 * @return this cloned object
	 */
	public Object clone() {
		Personalization clone = new Personalization();
		clone.setModifiable(this.isModifiable());
		clone.setReading(this.getReading());
		clone.setWriting(this.getWriting());
		clone.setSharing(this.getSharing());
		clone.setObliged(this.isObliged());
		clone.setIdOfSharing(this.getIdOfSharing());
		clone.setSecurityRight(this.isSecurityRight());
		//clone.setAddInDatabase(this.isAddInDatabase());
		clone.inheritedAcl = this.isInheritedAcl();
		clone.setInheritedFrom(this.getInheritedFrom());
		return clone;
	}
	
	
	/**
	 * Compare this object to another one
	 */
	public boolean equals(Object o) {
		Personalization comp = (Personalization)o;
		
		boolean equals = comp.reading==this.reading && comp.writing==this.writing && comp.sharing==this.sharing && comp.obliged==this.obliged && (comp.inheritedAcl==true && this.inheritedAcl==true || (comp.inheritedAcl==false && this.inheritedAcl==false));
		
		if (equals && this.inheritedAcl) {
				return comp.inheritedFrom.equals(this.inheritedFrom);
		}
		else return equals;
		
		
	}
	
	
	
	

	/**
	 * Return a String from this user
	 * @return a String from this user
	 */
	public String toString() {
		return "reading="+reading+" writing="+writing+" sharing="+sharing+" inherited="+inheritedAcl+" from="+inheritedFrom+" security="+securityRight;
	}
	
}
