/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.HasBroker;
import org.apache.ojb.odmg.ImplementationImpl;
import org.apache.ojb.odmg.NamedRootsMap;
import org.apache.ojb.odmg.NarrowTransaction;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxUtil;
import org.odmg.ClassNotPersistenceCapableException;
import org.odmg.Database;
import org.odmg.DatabaseClosedException;
import org.odmg.DatabaseNotFoundException;
import org.odmg.DatabaseOpenException;
import org.odmg.ODMGException;
import org.odmg.ObjectNameNotFoundException;
import org.odmg.ObjectNameNotUniqueException;
import org.odmg.Transaction;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class DatabaseImpl
implements Database {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$DatabaseImpl == null ? (class$org$apache$ojb$odmg$DatabaseImpl = DatabaseImpl.class$("org.apache.ojb.odmg.DatabaseImpl")) : class$org$apache$ojb$odmg$DatabaseImpl);
    private PBKey pbKey;
    private boolean isOpen = false;
    private ImplementationImpl odmg;
    private NamedRootsMap nrm = NamedRootsMap.getInstance();
    static /* synthetic */ Class class$org$apache$ojb$odmg$DatabaseImpl;

    public DatabaseImpl(ImplementationImpl ojb) {
        this.odmg = ojb;
    }

    private TransactionImpl getTransaction() {
        Transaction result = this.odmg.currentTransaction();
        if (result instanceof NarrowTransaction) {
            return ((NarrowTransaction)result).getRealTransaction();
        }
        return (TransactionImpl)result;
    }

    public PBKey getPBKey() {
        if (this.pbKey == null) {
            this.log.error("## PBKey not set, Database isOpen=" + this.isOpen + " ##");
            if (!this.isOpen) {
                throw new DatabaseClosedException("Database is not open");
            }
        }
        return this.pbKey;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public synchronized void open(String name, int accessMode) throws ODMGException {
        if (this.isOpen()) {
            throw new DatabaseOpenException("Database is already open");
        }
        PersistenceBroker broker = null;
        try {
            if (name == null) {
                this.log.info("Given argument was 'null', open default database");
                broker = PersistenceBrokerFactory.defaultPersistenceBroker();
            } else {
                broker = PersistenceBrokerFactory.createPersistenceBroker(BrokerHelper.extractAllTokens(name));
            }
            this.pbKey = broker.getPBKey();
            this.isOpen = true;
            this.odmg.registerOpenDatabase(this);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Open database using PBKey " + this.pbKey);
            }
        }
        catch (PBFactoryException ex) {
            this.log.error("Open database failed: " + ex.getMessage(), (Throwable)((Object)ex));
            throw new DatabaseNotFoundException("OJB can't open database " + name + "\n" + ex.getMessage());
        }
        finally {
            if (broker != null) {
                broker.close();
            }
        }
    }

    public void close() throws ODMGException {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not Open. Must have an open DB to call close.");
        }
        if (this.odmg.hasOpenTransaction() && this.getTransaction().getAssociatedDatabase().equals(this)) {
            String msg = "Database cannot be closed, associated Tx is still open. Transaction status is '" + TxUtil.getStatusString(this.getTransaction().getStatus()) + "'." + " Used PBKey was " + this.getTransaction().getBroker().getPBKey();
            this.log.error(msg);
            TransactionInProgressException ex = new TransactionInProgressException(msg);
            throw ex;
        }
        this.isOpen = false;
        this.pbKey = null;
        if (this == this.odmg.getCurrentDatabase()) {
            this.odmg.setCurrentDatabase(null);
        }
    }

    public void bind(Object object, String name) throws ObjectNameNotUniqueException {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to call bind.");
        }
        TransactionImpl tx = this.getTransaction();
        if (tx == null || !tx.isOpen()) {
            throw new TransactionNotInProgressException("Tx is not open. Must have an open TX to call bind.");
        }
        Identity identity = new Identity(object, tx.getBroker());
        this.makePersistent(object);
        this.nrm.put(name, identity);
        tx.putNrmEntry(name, identity);
    }

    public Object lookup(String name) throws ObjectNameNotFoundException {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to call lookup");
        }
        TransactionImpl tx = this.getTransaction();
        if (tx == null || !tx.isOpen()) {
            throw new TransactionNotInProgressException("Tx is not open. Must have an open TX to call lookup.");
        }
        Identity oid = this.nrm.get(name);
        if (oid == null) {
            oid = tx.getNrmEntry(name);
        }
        if (oid != null) {
            try {
                Object result = tx.getObjectByIdentity(oid);
                if (result != null) {
                    tx.lock(result, 1);
                }
                return result;
            }
            catch (PersistenceBrokerException ex) {
                throw new ObjectNameNotFoundException("Error in lookup of: " + name + ", " + ex.getMessage());
            }
        }
        throw new ObjectNameNotFoundException("Name not found: " + name);
    }

    public void unbind(String name) throws ObjectNameNotFoundException {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to call unbind");
        }
        TransactionImpl tx = this.getTransaction();
        if (tx == null || !tx.isOpen()) {
            throw new TransactionNotInProgressException("Tx is not open. Must have an open TX to call unbind.");
        }
        boolean failedPersistent = false;
        boolean failedCurrentTx = false;
        if (!tx.unbindNrmEntry(name)) {
            failedCurrentTx = true;
        }
        try {
            this.nrm.unbind(name);
        }
        catch (ObjectNameNotFoundException ex) {
            failedPersistent = true;
        }
        if (failedCurrentTx && failedPersistent) {
            throw new ObjectNameNotFoundException("don't know about " + name);
        }
    }

    public void makePersistent(Object object) {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open");
        }
        TransactionImpl tx = this.getTransaction();
        if (tx == null || !tx.isOpen()) {
            throw new TransactionNotInProgressException("No transaction in progress, cannot persist");
        }
        try {
            PersistenceBroker broker = ((HasBroker)tx).getBroker();
            broker.getClassDescriptor(object.getClass());
            tx.lock(object, 4);
        }
        catch (org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException ex) {
            this.log.error("Persistence object failed: " + object, (Throwable)((Object)ex));
            throw new ClassNotPersistenceCapableException(ex.getMessage());
        }
    }

    public void deletePersistent(Object object) {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open");
        }
        TransactionImpl tx = this.getTransaction();
        if (tx == null || !tx.isOpen()) {
            throw new TransactionNotInProgressException("No transaction in progress, cannot delete persistent");
        }
        tx.lock(object, 4);
        tx.markDelete(object);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

