/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.HasBroker;
import org.odmg.Transaction;

public final class PBCapsule {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$PBCapsule == null ? (class$org$apache$ojb$odmg$PBCapsule = PBCapsule.class$("org.apache.ojb.odmg.PBCapsule")) : class$org$apache$ojb$odmg$PBCapsule);
    PersistenceBroker broker;
    PBKey pbKey;
    Transaction tx;
    boolean needsTxCommit = false;
    boolean needsPBCommit = false;
    boolean isIlleagal = false;
    static /* synthetic */ Class class$org$apache$ojb$odmg$PBCapsule;

    public PBCapsule(PBKey pbKey, Transaction tx) {
        this.tx = tx;
        this.pbKey = pbKey;
        this.prepare();
    }

    public PersistenceBroker getBroker() {
        if (this.isIlleagal) {
            throw new OJBRuntimeException("You could not reuse PBCapsule after destroy");
        }
        return this.broker;
    }

    private void prepare() {
        if (this.isIlleagal) {
            throw new OJBRuntimeException("You could not reuse PBCapsule after destroy");
        }
        if (this.tx == null) {
            if (log.isDebugEnabled()) {
                log.debug("No running transaction found, try to get PersistenceBroker instance via PBKey " + this.pbKey);
            }
            this.broker = this.obtainBroker();
            if (!this.broker.isInTransaction()) {
                this.broker.beginTransaction();
                this.needsPBCommit = true;
            }
        } else {
            if (!this.tx.isOpen()) {
                this.tx.begin();
                this.needsTxCommit = true;
            }
            this.broker = ((HasBroker)((Object)this.tx)).getBroker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        block8: {
            if (this.needsTxCommit) {
                if (log.isDebugEnabled()) {
                    log.debug("Indicated to commit tx");
                }
                this.tx.commit();
            } else if (this.needsPBCommit) {
                if (log.isDebugEnabled()) {
                    log.debug("Indicated to commit PersistenceBroker");
                }
                try {
                    this.broker.commitTransaction();
                    Object var2_1 = null;
                    if (this.broker == null) break block8;
                    this.broker.close();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    if (this.broker != null) {
                        this.broker.close();
                    }
                    throw throwable;
                }
                {
                }
            }
        }
        this.isIlleagal = true;
        this.needsTxCommit = false;
        this.needsPBCommit = false;
    }

    private PersistenceBroker obtainBroker() {
        PersistenceBroker _broker;
        try {
            if (this.pbKey == null) {
                log.warn("No tx runnning and PBKey is null, try to use the default PB");
                _broker = PersistenceBrokerFactory.defaultPersistenceBroker();
            } else {
                _broker = PersistenceBrokerFactory.createPersistenceBroker(this.pbKey);
            }
        }
        catch (PBFactoryException e) {
            log.error("Could not obtain PB for PBKey " + this.pbKey, (Throwable)((Object)e));
            throw new OJBRuntimeException("Unexpected micro-kernel exception", (Throwable)((Object)e));
        }
        return _broker;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

