/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListEntry;
import org.apache.ojb.odmg.collections.DSetEntry;
import org.apache.ojb.odmg.collections.DSetIterator;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DCollection;
import org.odmg.DList;
import org.odmg.DSet;
import org.odmg.ODMGRuntimeException;
import org.odmg.QueryInvalidException;

public class DSetImpl
extends AbstractSet
implements DSet,
Serializable {
    private static final long serialVersionUID = -4459673364598652639L;
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DSetImpl == null ? (class$org$apache$ojb$odmg$collections$DSetImpl = DSetImpl.class$("org.apache.ojb.odmg.collections.DSetImpl")) : class$org$apache$ojb$odmg$collections$DSetImpl);
    private int id = -1;
    private Vector elements = new Vector();
    private int size;
    private PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DSetImpl;

    public DSetImpl() {
        this.size = 0;
    }

    public DSetImpl(PBKey pbKey) {
        this.size = 0;
        this.pbKey = pbKey;
    }

    public DSetImpl(int theId, int theSize) {
        this.id = theId;
        this.size = theSize;
    }

    private TransactionImpl getTransaction() {
        return TxManagerFactory.instance().getTransaction();
    }

    public boolean add(Object o) {
        if (!this.contains(o)) {
            ++this.size;
            DSetEntry entry = new DSetEntry(this, o);
            this.elements.add(entry);
            TransactionImpl tx = this.getTransaction();
            if (tx != null && tx.isOpen()) {
                tx.lock(this, 4);
                tx.lock(entry, 4);
                tx.lock(o, 1);
            }
            return true;
        }
        return false;
    }

    public DSet difference(DSet otherSet) {
        DSetImpl result = new DSetImpl(this.pbKey);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object candidate = iter.next();
            if (otherSet.contains(candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    public boolean existsElement(String predicate) throws QueryInvalidException {
        DList results = (DList)this.query(predicate);
        return results != null && results.size() != 0;
    }

    protected int generateNewId() {
        PBCapsule capsule = new PBCapsule(null, TxManagerFactory.instance().getTransaction());
        try {
            int result;
            ClassDescriptor cld = capsule.getBroker().getClassDescriptor(this.getClass());
            FieldDescriptor fld = cld.getFieldDescriptorByName("id");
            Integer val = (Integer)capsule.getBroker().serviceSequenceManager().getUniqueValue(fld);
            int n = result = val.intValue();
            return n;
        }
        catch (Exception e) {
            this.log.error("Generation of new id failed", e);
            throw new PersistenceBrokerException(e);
        }
        finally {
            capsule.destroy();
        }
    }

    public Vector getElements() {
        return this.elements;
    }

    public int getId() {
        if (this.id == -1) {
            this.id = this.generateNewId();
        }
        return this.id;
    }

    public DSet intersection(DSet otherSet) {
        DSet union = this.union(otherSet);
        DSetImpl result = new DSetImpl(this.pbKey);
        Iterator iter = union.iterator();
        while (iter.hasNext()) {
            Object candidate = iter.next();
            if (!this.contains(candidate) || !otherSet.contains(candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    public Iterator iterator() {
        return new DSetIterator(this);
    }

    public boolean properSubsetOf(DSet otherSet) {
        return this.size() > 0 && this.size() < otherSet.size() && this.subsetOf(otherSet);
    }

    public boolean properSupersetOf(DSet otherSet) {
        return otherSet.size() > 0 && otherSet.size() < this.size() && this.supersetOf(otherSet);
    }

    public DCollection query(String predicate) throws QueryInvalidException {
        String oql = "select all from java.lang.Object where " + predicate;
        OQLQueryImpl predicateQuery = new OQLQueryImpl(this.pbKey);
        TransactionImpl tx = this.getTransaction();
        PBCapsule capsule = new PBCapsule(this.pbKey, tx);
        PersistenceBroker broker = capsule.getBroker();
        try {
            predicateQuery.create(oql);
            Query pQ = predicateQuery.getQuery();
            Criteria pCrit = pQ.getCriteria();
            Criteria allElementsCriteria = this.getPkCriteriaForAllElements(broker);
            pCrit.addAndCriteria(allElementsCriteria);
            Class clazz = this.getElementsExtentClass(broker);
            QueryByCriteria q = new QueryByCriteria(clazz, pCrit);
            if (this.log.isDebugEnabled()) {
                this.log.debug(((Object)q).toString());
            }
            DSetImpl dSetImpl = (DSetImpl)((Object)broker.getCollectionByQuery(class$org$apache$ojb$odmg$collections$DSetImpl == null ? (class$org$apache$ojb$odmg$collections$DSetImpl = DSetImpl.class$("org.apache.ojb.odmg.collections.DSetImpl")) : class$org$apache$ojb$odmg$collections$DSetImpl, q));
            return dSetImpl;
        }
        catch (PersistenceBrokerException e) {
            throw new ODMGRuntimeException(e.getMessage());
        }
        finally {
            capsule.destroy();
        }
    }

    private Criteria getPkCriteriaForAllElements(PersistenceBroker broker) {
        try {
            Criteria crit = null;
            for (int i = 0; i < this.elements.size(); ++i) {
                DListEntry entry = (DListEntry)this.elements.get(i);
                Object obj = entry.getRealSubject();
                ClassDescriptor cld = broker.getClassDescriptor(obj.getClass());
                FieldDescriptor[] pkFields = cld.getPkFields();
                ValueContainer[] pkValues = broker.serviceBrokerHelper().getKeyValues(cld, obj);
                Criteria criteria = new Criteria();
                for (int j = 0; j < pkFields.length; ++j) {
                    FieldDescriptor fld = pkFields[j];
                    criteria.addEqualTo(fld.getPersistentField().getName(), pkValues[j].getValue());
                }
                if (crit == null) {
                    crit = criteria;
                    continue;
                }
                crit.addOrCriteria(criteria);
            }
            return crit;
        }
        catch (PersistenceBrokerException e) {
            this.log.error((Object)e);
            return null;
        }
    }

    private Class getElementsExtentClass(PersistenceBroker broker) throws PersistenceBrokerException {
        DListEntry entry = (DListEntry)this.elements.get(0);
        Class<?> elementsClass = entry.getRealSubject().getClass();
        Class extentClass = broker.getTopLevelClass(elementsClass);
        return extentClass;
    }

    public Iterator select(String predicate) throws QueryInvalidException {
        return this.query(predicate).iterator();
    }

    public Object selectElement(String predicate) throws QueryInvalidException {
        return ((DList)this.query(predicate)).get(0);
    }

    public void setElements(Vector elements) {
        this.elements = elements;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean subsetOf(DSet otherSet) {
        return otherSet.containsAll(this);
    }

    public boolean supersetOf(DSet otherSet) {
        return this.containsAll(otherSet);
    }

    public DSet union(DSet otherSet) {
        DSetImpl result = new DSetImpl(this.pbKey);
        result.addAll(this);
        result.addAll(otherSet);
        return result;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

