/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CStockage.provider;

import java.io.InputStream;

/**
 * Id: ChannelResource.java,v 1.0 8 juil. 2004<br/>
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
 * Classes: ChannelResource<br/>
 * Original Author: Yohan Colmant<br/>
 * This represents a file system resource. This is used to abstract the server client library.<br/>
 */
public class ChannelResource {

	/**
	 * The displayed name
	 */
	private String displayName;
	
	/**
	 * The resource path
	 */
	private String path;
	
	/**
	 * The length of the resource
	 */
	private long contentLength;
	
	/**
	 * The type of the resource
	 */
	private String contentType;
	
	/**
	 * The last modification date
	 */
	private long lastModified;
	
	/**
	 * If this resource is a collection
	 */
	private boolean isCollection;
	
	/**
	 * The file inputStream
	 */
	private InputStream inputStream;
	
	/**
	 * If this resource has a state
	 */
	private String state;
	
	
	
	/**
	 * Constructor
	 * @param displayName The displayed name
	 * @param path The resource path
	 * @param contentLength The length of the resource
	 * @param contentType The type of the resource
	 * @param lastModified The last modification date
	 * @param isCollection If this resource is a collection
	 */
	public ChannelResource(String displayName, String path, long contentLength, String contentType, long lastModified, boolean isCollection) {
		this(displayName, path, contentLength, contentType, lastModified, isCollection, null);
	}
	
	
	/**
	 * Constructor
	 * @param displayName The displayed name
	 * @param path The resource path
	 * @param contentLength The length of the resource
	 * @param contentType The type of the resource
	 * @param lastModified The last modification date
	 * @param isCollection If this resource is a collection
	 * @param inputStream the file inputStream
	 */
	public ChannelResource(String displayName, String path, long contentLength, String contentType, long lastModified, boolean isCollection, InputStream inputStream) {
		this.displayName = displayName;
		this.path = path;
		this.contentLength = contentLength;
		this.contentType = contentType;
		this.lastModified = lastModified;	
		this.isCollection = isCollection;
		this.inputStream = inputStream;
		//System.out.println(displayName+" "+path+" "+contentLength+" "+contentType+" "+lastModified+" "+isCollection+" "+inputStream);
	}
	
	
	
	/**
	 * @return Returns the state.
	 */
	public String getState() {
		return state;
	}
	
	/**
	 * @param state The state to set.
	 */
	public void setState(String state) {
		this.state = state;
	}
	/**
	 * @return Returns the path.
	 */
	public String getPath() {
		return path;
	}
	/**
	 * @return Returns the contentLength.
	 */
	public long getContentLength() {
		return contentLength;
	}
	/**
	 * @return Returns the contentType.
	 */
	public String getContentType() {
		return contentType;
	}
	/**
	 * @return Returns the displayName.
	 */
	public String getDisplayName() {
		return displayName;
	}
	/**
	 * @return Returns the lastModified.
	 */
	public long getLastModified() {
		return lastModified;
	}
	
	/**
	 * @param lastModified The lastModified to set.
	 */
	public void setLastModified(long lastModified) {
		this.lastModified = lastModified;
	}

	/**
	 * @return Returns the isCollection.
	 */
	public boolean isCollection() {
		return isCollection;
	}
	/**
	 * @return Returns the inputStream.
	 */
	public InputStream getInputStream() {
		return inputStream;
	}
	
	
	/**
	 * Return a String formed with all attributes
	 * @return a String formed with all attributes
	 */
	public String toString() {
		String s = "";
		s+= "\ndisplayName: "+displayName;
		s+= "\npath: "+path;
		s+= "\ncontentLength: "+contentLength;
		s+= "\ncontentType: "+contentType;
		s+= "\nlastModified: "+lastModified;
		s+= "\nisCollection: "+isCollection;
		return s;
	}
}
