/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.sql.ArrayDescriptor;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

public abstract class TypeDescriptor
implements Serializable {
    public static boolean DEBUG_SERIALIZATION = false;
    static final long serialVersionUID = 2022598722047823723L;
    SQLName m_sqlName;
    OracleNamedType m_pickler;
    transient OracleConnection m_conn;

    protected TypeDescriptor() {
    }

    protected TypeDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.m_conn = (OracleConnection)connection;
        this.m_sqlName = new SQLName(string, this.m_conn);
    }

    protected TypeDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        if (oracleTypeADT == null || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.m_conn = (OracleConnection)connection;
        this.m_sqlName = null;
        this.m_pickler = oracleTypeADT;
        this.m_pickler.setDescriptor(this);
    }

    protected TypeDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        if (sQLName == null || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.m_sqlName = sQLName;
        this.m_conn = (OracleConnection)connection;
    }

    protected TypeDescriptor(SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        if (sQLName == null || oracleTypeADT == null || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.m_sqlName = sQLName;
        this.m_conn = (OracleConnection)connection;
        this.m_pickler = oracleTypeADT;
        this.m_pickler.setDescriptor(this);
    }

    public OracleConnection getConnection() {
        return this.m_conn;
    }

    public synchronized String getName() throws SQLException {
        if (this.m_sqlName == null) {
            this.initSQLName();
        }
        return this.m_sqlName.getName();
    }

    public OracleNamedType getPickler() {
        return this.m_pickler;
    }

    public synchronized SQLName getSQLName() throws SQLException {
        if (this.m_sqlName == null) {
            this.initSQLName();
        }
        return this.m_sqlName;
    }

    public String getSchemaName() throws SQLException {
        return this.getSQLName().getSchema();
    }

    public static TypeDescriptor getTypeDescriptor(String string, OracleConnection oracleConnection) throws SQLException {
        TypeDescriptor typeDescriptor = null;
        SQLName sQLName = new SQLName(string, oracleConnection);
        String string2 = sQLName.getName();
        typeDescriptor = (TypeDescriptor)oracleConnection.getDescriptor(string2);
        if (typeDescriptor != null) {
            return typeDescriptor;
        }
        OracleTypeADT oracleTypeADT = new OracleTypeADT(string2, (Connection)oracleConnection);
        oracleConnection.db_access.getOracleTypeADT(oracleTypeADT);
        oracleTypeADT.init(oracleConnection);
        OracleTypeADT oracleTypeADT2 = oracleTypeADT.cleanup();
        switch (oracleTypeADT2.getTypeCode()) {
            case 2002: {
                typeDescriptor = new StructDescriptor(sQLName, oracleTypeADT2, oracleConnection);
                break;
            }
            case 2003: {
                typeDescriptor = new ArrayDescriptor(sQLName, (OracleTypeCOLLECTION)oracleTypeADT2, (Connection)oracleConnection);
                break;
            }
            default: {
                DBError.throwSqlException(1);
            }
        }
        oracleConnection.putDescriptor(string2, typeDescriptor);
        oracleTypeADT2.setDescriptor(typeDescriptor);
        return typeDescriptor;
    }

    public String getTypeName() throws SQLException {
        return this.getSQLName().getSimpleName();
    }

    void initSQLName() throws SQLException {
        if (this.m_pickler == null || this.m_conn == null) {
            DBError.throwSqlException(1);
        }
        this.m_sqlName = new SQLName(this.m_pickler.getFullName(), this.m_conn);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (DEBUG_SERIALIZATION) {
            System.out.println("TypeDescriptor::readObject");
        }
        this.m_sqlName = (SQLName)objectInputStream.readObject();
        this.m_pickler = (OracleNamedType)objectInputStream.readObject();
    }

    public void setConnection(Connection connection) throws SQLException {
        if (DEBUG_SERIALIZATION) {
            System.out.println("TypeDescriptor::writeObject");
        }
        this.m_conn = (OracleConnection)connection;
        this.m_pickler.setConnection((OracleConnection)connection);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            if (this.m_sqlName == null) {
                this.initSQLName();
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
        objectOutputStream.writeObject(this.m_sqlName);
        objectOutputStream.writeObject(this.m_pickler);
    }
}

