/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.RowReader;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class RowReaderDefaultImpl
implements RowReader {
    private static final Object[] NO_ARGS = new Object[0];
    private ClassDescriptor m_cld;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl;

    public RowReaderDefaultImpl(ClassDescriptor cld) {
        this.m_cld = cld;
    }

    public Object readObjectFrom(Map row) throws PersistenceBrokerException {
        ClassDescriptor cld = this.selectClassDescriptor(row);
        return this.buildOrRefreshObject(row, cld, null);
    }

    public void refreshObject(Object instance, Map row) {
        ClassDescriptor targetClassDescriptor = this.selectClassDescriptor(row);
        this.buildOrRefreshObject(row, targetClassDescriptor, instance);
    }

    protected Object buildOrRefreshObject(Map row, ClassDescriptor targetClassDescriptor, Object targetObject) {
        Method initializationMethod;
        Object result = targetObject;
        FieldDescriptor fmd = null;
        if (targetObject == null) {
            result = ClassHelper.buildNewObjectInstance(targetClassDescriptor);
        }
        FieldDescriptor[] fields = targetClassDescriptor.getFieldDescriptions();
        for (int i = 0; i < fields.length; ++i) {
            fmd = fields[i];
            fmd.getPersistentField().set(result, row.get(fmd.getColumnName()));
        }
        if (targetObject == null && (initializationMethod = targetClassDescriptor.getInitializationMethod()) != null) {
            try {
                initializationMethod.invoke(result, NO_ARGS);
            }
            catch (Exception ex) {
                throw new PersistenceBrokerException("Unable to invoke initialization method:" + initializationMethod.getName() + " for class:" + this.m_cld.getClassOfObject(), ex);
            }
        }
        return result;
    }

    public void readObjectArrayFrom(ResultSet rs, Map row) {
        FieldDescriptor[] fields = null;
        fields = this.m_cld.getSuperClass() != null ? this.m_cld.getFieldDescriptorsInHeirarchy() : this.m_cld.getRepository().getFieldDescriptorsForMultiMappedTable(this.m_cld);
        this.readValuesFrom(rs, row, fields);
    }

    public void readPkValuesFrom(ResultSet rs, Map row) {
        FieldDescriptor[] pkFields = this.m_cld.getPkFields();
        this.readValuesFrom(rs, row, pkFields);
    }

    protected void readValuesFrom(ResultSet rs, Map row, FieldDescriptor[] fields) {
        int size = fields.length;
        Object val = null;
        FieldDescriptor fld = null;
        try {
            for (int j = 0; j < size; ++j) {
                fld = fields[j];
                if (row.containsKey(fld.getColumnName())) continue;
                val = fld.getJdbcType().getObjectFromColumn(rs, fld.getColumnName());
                row.put(fld.getColumnName(), fld.getFieldConversion().sqlToJava(val));
            }
        }
        catch (SQLException t) {
            throw new PersistenceBrokerException("Error reading class type: " + this.m_cld.getClassNameOfObject() + " from result set, current read field was " + (fld != null ? fld.getPersistentField().getName() : null), t);
        }
    }

    protected ClassDescriptor selectClassDescriptor(Map row) throws PersistenceBrokerException {
        FieldDescriptor concreteClassFD = this.m_cld.getOjbConcreteClassField();
        if (concreteClassFD == null) {
            return this.m_cld;
        }
        try {
            String concreteClass = (String)row.get(concreteClassFD.getColumnName());
            if (concreteClass == null || concreteClass.trim().length() == 0) {
                throw new PersistenceBrokerException("ojbConcreteClass field returned null or 0-length string");
            }
            concreteClass = concreteClass.trim();
            ClassDescriptor result = this.m_cld.getRepository().getDescriptorFor(concreteClass);
            if (result == null) {
                LoggerFactory.getDefaultLogger().warn("[" + (class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl == null ? (class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl = RowReaderDefaultImpl.class$("org.apache.ojb.broker.accesslayer.RowReaderDefaultImpl")) : class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl).getName() + "] Can not find class-descriptor for ojbConcreteClass " + concreteClass + ", use given class-descriptor '" + this.m_cld.getClassNameOfObject() + "' instead");
                result = this.m_cld;
            }
            return result;
        }
        catch (PBFactoryException e) {
            throw new PersistenceBrokerException((Throwable)((Object)e));
        }
    }

    public void setClassDescriptor(ClassDescriptor cld) {
        this.m_cld = cld;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.m_cld;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

