/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.RsQueryObject;
import org.apache.ojb.broker.accesslayer.SqlBasedRsIterator;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.util.JdbcTypesHelper;

public class SqlBasedReportQueryRsIterator
extends SqlBasedRsIterator {
    private ResultSetMetaData rsMetaData;
    private int columnCount;

    public SqlBasedReportQueryRsIterator(RsQueryObject queryObject, PersistenceBrokerImpl broker) throws PersistenceBrokerException {
        super(queryObject, broker);
        try {
            this.rsMetaData = this.getRsAndStmt().m_rs.getMetaData();
            this.columnCount = this.rsMetaData.getColumnCount();
        }
        catch (SQLException e) {
            throw new PersistenceBrokerException(e);
        }
    }

    protected Object getObjectFromResultSet() throws PersistenceBrokerException {
        Object[] result = new Object[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            try {
                Object item;
                int jdbcType = this.rsMetaData.getColumnType(i + 1);
                result[i] = item = JdbcTypesHelper.getObjectFromColumn(this.getRsAndStmt().m_rs, new Integer(jdbcType), i + 1);
                continue;
            }
            catch (SQLException e) {
                throw new PersistenceBrokerException(e);
            }
        }
        return result;
    }
}

