/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.conversions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.accesslayer.conversions.ConversionException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;

public class IntList2VarcharFieldConversion
implements FieldConversion {
    private static final String NULLVALUE = "#NULL#";
    private static final String EMPTYCOLLEC = "#EMTPY#";

    public Object javaToSql(Object source) throws ConversionException {
        if (source == null) {
            return NULLVALUE;
        }
        try {
            List intList = (List)source;
            if (intList.isEmpty()) {
                return NULLVALUE;
            }
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < intList.size(); ++i) {
                Integer obj = (Integer)intList.get(i);
                String newSt = obj.toString();
                newSt = StringUtils.replace((String)newSt, (String)"#", (String)"##");
                result.append(newSt);
                result.append("#");
            }
            return result.toString();
        }
        catch (ClassCastException e) {
            throw new ConversionException("Object is not a List of Integer it is a" + source.getClass().getName());
        }
    }

    public Object sqlToJava(Object source) throws ConversionException {
        if (source == null) {
            return null;
        }
        if (!(source instanceof String)) {
            throw new ConversionException("Object is not a String it is a" + source.getClass().getName());
        }
        if (source.toString().equals(NULLVALUE)) {
            return null;
        }
        if (source.toString().equals(EMPTYCOLLEC)) {
            return new ArrayList();
        }
        ArrayList<Object> v = new ArrayList<Object>();
        String input = source.toString();
        int pos = input.indexOf("#");
        while (pos >= 0) {
            if (pos == 0) {
                v.add("");
            } else {
                v.add(Integer.valueOf(input.substring(0, pos)));
            }
            if (pos + 1 > input.length()) break;
            input = input.substring(pos + 1, input.length());
            pos = input.indexOf("#");
        }
        return v;
    }
}

