/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.StringTokenizer;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.CacheFilter;
import org.apache.ojb.broker.cache.ObjectCache;

public class CacheFilterPackageImpl
implements CacheFilter {
    public static final String EXCLUDE_PACKAGES = "exclude-packages";
    private static final String COMMA = ",";
    private PersistenceBroker broker;
    private ObjectCache cache;
    private StringTokenizer tok;
    private String filterPackages;

    public CacheFilterPackageImpl(PersistenceBroker broker, ObjectCache cache) {
        this.broker = broker;
        this.cache = cache;
    }

    public boolean beforeCache(Identity oid, Object obj) {
        this.filterPackages = null;
        this.filterPackages = this.broker.serviceConnectionManager().getConnectionDescriptor().getAttribute(EXCLUDE_PACKAGES);
        this.filterPackages = this.broker.getDescriptorRepository().getAttribute(EXCLUDE_PACKAGES) + (this.filterPackages != null ? COMMA + this.filterPackages : "");
        return this.matchFilterPackages(this.filterPackages, oid.getObjectsRealClass());
    }

    public boolean beforeLookup(Identity oid) {
        return true;
    }

    public boolean beforeRemove(Identity oid) {
        return true;
    }

    public ObjectCache getObjectCache() {
        return this.cache;
    }

    private boolean matchFilterPackages(String aFilterPackages, Class clazz) {
        boolean result = true;
        if (aFilterPackages != null && aFilterPackages.length() != 0) {
            this.tok = new StringTokenizer(aFilterPackages, COMMA);
            while (this.tok.hasMoreTokens()) {
                String token = this.tok.nextToken().trim();
                if (token.equals("") || !clazz.getName().startsWith(token)) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

