/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;

public class ObjectCacheLocalDefaultImpl
implements ObjectCache {
    private static final String TIMEOUT = "timeout";
    protected Map objectTable = new HashMap();
    private long timeout = 900000L;

    public ObjectCacheLocalDefaultImpl(PersistenceBroker broker, Properties prop) {
        this.timeout = prop == null ? this.timeout : Long.parseLong(prop.getProperty(TIMEOUT, "" + this.timeout)) * 1000L;
    }

    public void clear() {
        this.objectTable.clear();
    }

    public void cache(Identity oid, Object obj) {
        if (obj != null) {
            SoftReference<CacheEntry> ref = new SoftReference<CacheEntry>(new CacheEntry(obj));
            this.objectTable.put(oid, ref);
        }
    }

    public Object lookup(Identity oid) {
        CacheEntry entry = null;
        SoftReference ref = (SoftReference)this.objectTable.get(oid);
        if (ref != null && ((entry = (CacheEntry)ref.get()) == null || entry.lifetime < System.currentTimeMillis())) {
            this.objectTable.remove(oid);
            entry = null;
        }
        return entry != null ? entry.object : null;
    }

    public void remove(Identity oid) {
        if (oid != null) {
            this.objectTable.remove(oid);
        }
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        buf.append("Count of cached objects", this.objectTable.keySet().size());
        return buf.toString();
    }

    class CacheEntry {
        long lifetime;
        Object object;

        public CacheEntry(Object object) {
            this.object = object;
            this.lifetime = System.currentTimeMillis() + ObjectCacheLocalDefaultImpl.this.timeout;
        }
    }
}

