/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.ojb.broker.metadata.JdbcType;

public final class ValueContainer {
    private JdbcType m_jdbcType;
    private Object m_value;

    public ValueContainer(Object value, JdbcType jdbcType) {
        this.setJdbcType(jdbcType);
        this.setValue(value);
    }

    public JdbcType getJdbcType() {
        return this.m_jdbcType;
    }

    public void setJdbcType(JdbcType jdbcType) {
        this.m_jdbcType = jdbcType;
    }

    public Object getValue() {
        return this.m_value;
    }

    public void setValue(Object value) {
        if (value instanceof ValueContainer) {
            throw new RuntimeException("We can't nest ValueContainers");
        }
        this.m_value = value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        boolean result = false;
        if (obj instanceof ValueContainer) {
            ValueContainer container = (ValueContainer)obj;
            boolean bl = result = this.m_jdbcType != null ? ((Object)this.m_jdbcType).equals(container.getJdbcType()) : false;
            if (result) {
                result = this.m_value == null ? null == container.getValue() : this.m_value.equals(container.getValue());
                result = new EqualsBuilder().append(this.m_value, container.getValue()).isEquals();
            }
        }
        return result;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.m_jdbcType).append(this.m_value).toHashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[jdbcType: " + this.m_jdbcType + ", value: " + this.m_value + "]";
    }
}

