/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.SerializationUtils;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.RepositoryPersistor;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class MetadataManager {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$MetadataManager == null ? (class$org$apache$ojb$broker$metadata$MetadataManager = MetadataManager.class$("org.apache.ojb.broker.metadata.MetadataManager")) : class$org$apache$ojb$broker$metadata$MetadataManager);
    private static final String MSG_STR = "* Can't find DescriptorRepository for current thread, use default one *";
    private static ThreadLocal threadedRepository = new ThreadLocal();
    private static MetadataManager singleton;
    private Hashtable metadataProfiles;
    private DescriptorRepository globalRepository;
    private ConnectionRepository connectionRepository;
    private boolean enablePerThreadChanges;
    private PBKey defaultPBKey;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$MetadataManager;

    private MetadataManager() {
        this.init();
    }

    private void init() {
        this.metadataProfiles = new Hashtable();
        String repository = ((PersistenceBrokerConfiguration)((Object)OjbConfigurator.getInstance().getConfigurationFor(null))).getRepositoryFilename();
        try {
            this.globalRepository = new RepositoryPersistor().readDescriptorRepository(repository);
            this.connectionRepository = new RepositoryPersistor().readConnectionRepository(repository);
        }
        catch (FileNotFoundException ex) {
            this.globalRepository = new DescriptorRepository();
            this.connectionRepository = new ConnectionRepository();
            log.info("No repository.xml file found, starting with empty metadata and connection configuration");
        }
        catch (Exception ex) {
            throw new MetadataException("Can't read repository file '" + repository + "'", ex);
        }
        this.defaultPBKey = this.buildDefaultKey();
    }

    public static synchronized MetadataManager getInstance() {
        if (singleton == null) {
            singleton = new MetadataManager();
        }
        return singleton;
    }

    public DescriptorRepository getRepository() {
        if (this.enablePerThreadChanges) {
            DescriptorRepository repository = (DescriptorRepository)threadedRepository.get();
            if (repository == null) {
                repository = this.getGlobalRepository();
                log.info(MSG_STR);
            }
            return repository;
        }
        return this.globalRepository;
    }

    public DescriptorRepository getGlobalRepository() {
        return this.globalRepository;
    }

    public ConnectionRepository connectionRepository() {
        return this.connectionRepository;
    }

    public void mergeConnectionRepository(ConnectionRepository repository) {
        this.mergeConnectionRepository(this.connectionRepository(), repository, false);
    }

    public void mergeConnectionRepository(ConnectionRepository targetRepository, ConnectionRepository sourceRepository, boolean deep) {
        List list = sourceRepository.getAllDescriptor();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JdbcConnectionDescriptor jcd = (JdbcConnectionDescriptor)iterator.next();
            if (deep) {
                jcd = (JdbcConnectionDescriptor)SerializationUtils.clone((Serializable)jcd);
            }
            targetRepository.addDescriptor(jcd);
        }
    }

    public void mergeDescriptorRepository(DescriptorRepository repository) {
        this.mergeDescriptorRepository(this.getRepository(), repository, false);
    }

    public void mergeDescriptorRepository(DescriptorRepository targetRepository, DescriptorRepository sourceRepository, boolean deep) {
        Iterator it = sourceRepository.iterator();
        while (it.hasNext()) {
            ClassDescriptor cld = (ClassDescriptor)it.next();
            if (deep) {
                cld = (ClassDescriptor)SerializationUtils.clone((Serializable)cld);
            }
            targetRepository.put(cld.getClassOfObject(), cld);
            cld.setRepository(targetRepository);
        }
    }

    public DescriptorRepository readDescriptorRepository(String fileName) {
        try {
            RepositoryPersistor persistor = new RepositoryPersistor();
            return persistor.readDescriptorRepository(fileName);
        }
        catch (Exception e) {
            throw new MetadataException("Can not read repository " + fileName, e);
        }
    }

    public DescriptorRepository readDescriptorRepository(InputStream inst) {
        try {
            RepositoryPersistor persistor = new RepositoryPersistor();
            return persistor.readDescriptorRepository(inst);
        }
        catch (Exception e) {
            throw new MetadataException("Can not read repository " + inst, e);
        }
    }

    public ConnectionRepository readConnectionRepository(String fileName) {
        try {
            RepositoryPersistor persistor = new RepositoryPersistor();
            return persistor.readConnectionRepository(fileName);
        }
        catch (Exception e) {
            throw new MetadataException("Can not read repository " + fileName, e);
        }
    }

    public ConnectionRepository readConnectionRepository(InputStream inst) {
        try {
            RepositoryPersistor persistor = new RepositoryPersistor();
            return persistor.readConnectionRepository(inst);
        }
        catch (Exception e) {
            throw new MetadataException("Can not read repository from " + inst, e);
        }
    }

    public void setDescriptor(DescriptorRepository repository, boolean global) {
        if (global) {
            if (log.isDebugEnabled()) {
                log.debug("Set new global repository: " + repository);
            }
            this.globalRepository = repository;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Set new threaded repository: " + repository);
            }
            threadedRepository.set(repository);
        }
    }

    public void setDescriptor(DescriptorRepository repository) {
        this.setDescriptor(repository, false);
    }

    public void setPerThreadDescriptor(DescriptorRepository repository) {
        this.setDescriptor(repository, false);
    }

    public DescriptorRepository copyOfGlobalRepository() {
        return (DescriptorRepository)SerializationUtils.clone((Serializable)this.globalRepository);
    }

    public boolean isEnablePerThreadChanges() {
        return this.enablePerThreadChanges;
    }

    public void setEnablePerThreadChanges(boolean enablePerThreadChanges) {
        this.enablePerThreadChanges = enablePerThreadChanges;
    }

    public void addProfile(Object key, DescriptorRepository repository) {
        if (this.metadataProfiles.contains(key)) {
            throw new MetadataException("Duplicate profile key. Key '" + key + "' already exists.");
        }
        this.metadataProfiles.put(key, repository);
    }

    public void loadProfile(Object key) {
        if (!this.isEnablePerThreadChanges()) {
            throw new MetadataException("Can not load profile with disabled per thread mode");
        }
        DescriptorRepository rep = (DescriptorRepository)this.metadataProfiles.get(key);
        if (rep == null) {
            throw new MetadataException("Can not find profile for key '" + key + "'");
        }
        this.setDescriptor(rep);
    }

    public DescriptorRepository removeProfile(Object key) {
        return (DescriptorRepository)this.metadataProfiles.remove(key);
    }

    public void clearProfiles() {
        this.metadataProfiles.clear();
    }

    public void removeAllProfiles() {
        this.metadataProfiles.clear();
    }

    public PBKey getDefaultPBKey() {
        return this.defaultPBKey;
    }

    public void setDefaultPBKey(PBKey defaultPBKey) {
        if (this.defaultPBKey != null) {
            throw new MetadataException("Default key is already set. Current key is " + this.defaultPBKey);
        }
        this.defaultPBKey = defaultPBKey;
        log.info("Set default PBKey for convenience broker creation: " + defaultPBKey);
    }

    private PBKey buildDefaultKey() {
        List descriptors = this.connectionRepository().getAllDescriptor();
        Iterator iterator = descriptors.iterator();
        while (iterator.hasNext()) {
            JdbcConnectionDescriptor descriptor = (JdbcConnectionDescriptor)iterator.next();
            if (!descriptor.isDefaultConnection()) continue;
            return new PBKey(descriptor.getJcdAlias(), descriptor.getUserName(), descriptor.getPassWord());
        }
        log.info("No 'default-connection' attribute set in jdbc-connection-descriptors, thus it's currently not possible to use 'defaultPersistenceBroker()'  convenience method to lookup PersistenceBroker instances. But it's possible to enable this at runtime using 'setDefaultKey' method.");
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

