/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.torque;

import java.util.Vector;
import org.apache.ojb.broker.metadata.IndexDescriptor;

public class TorqueIndexGenerator {
    public void generateIndices(Vector indexDescriptors, StringBuffer buffer) {
        int numIndexes = indexDescriptors.size();
        for (int i = 0; i < numIndexes; ++i) {
            IndexDescriptor index = (IndexDescriptor)indexDescriptors.get(i);
            String indexTag = this.getIndexTag(index);
            buffer.append("        <");
            buffer.append(indexTag);
            if (index.getName() != null) {
                buffer.append(" name=\"");
                buffer.append(index.getName());
                buffer.append("\"");
            }
            buffer.append(">\n");
            this.generateStringVector(index.getIndexColumns(), indexTag + "-column", "name", "            ", buffer);
            buffer.append("        </");
            buffer.append(indexTag);
            buffer.append(">\n");
        }
    }

    private String getIndexTag(IndexDescriptor indexDescriptor) {
        if (indexDescriptor.isUnique()) {
            return "unique";
        }
        return "index";
    }

    private void generateStringVector(Vector strings, String element, String attribute, String indentation, StringBuffer buffer) {
        for (int i = 0; i < strings.size(); ++i) {
            buffer.append(indentation);
            buffer.append("<");
            buffer.append(element);
            buffer.append(" ");
            buffer.append(attribute);
            buffer.append("=\"");
            buffer.append(strings.get(i));
            buffer.append("\"/>\n");
        }
    }
}

