/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.torque;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.torque.TableDescriptor;

public class TorqueTablePreprocessor {
    private DescriptorRepository repository;
    private HashMap standardTables = new HashMap();

    public TorqueTablePreprocessor(DescriptorRepository repository) {
        this.repository = repository;
    }

    public void buildStandardTables() {
        Iterator classDescriptorIterators = this.repository.iterator();
        while (classDescriptorIterators.hasNext()) {
            ClassDescriptor cd = (ClassDescriptor)classDescriptorIterators.next();
            if (cd.isAbstract() || cd.isInterface()) {
                System.out.println("Skip table build for abstract base class / interface called " + cd.getClassNameOfObject());
                continue;
            }
            this.buildStandardTable(cd);
        }
    }

    public HashMap getStandardTables() {
        return this.standardTables;
    }

    private void buildStandardTable(ClassDescriptor cd) {
        String tableName = cd.getFullTableName();
        TableDescriptor tableDescriptor = (TableDescriptor)this.standardTables.get(tableName);
        if (tableDescriptor == null) {
            tableDescriptor = new TableDescriptor();
            tableDescriptor.setName(tableName);
            this.standardTables.put(tableName, tableDescriptor);
        }
        this.buildStandardTableFieldDescriptors(cd.getFieldDescriptions(), tableDescriptor);
        tableDescriptor.getIndices().addAll(cd.getIndexes());
        tableDescriptor.getReferences().addAll(cd.getObjectReferenceDescriptors());
    }

    private void buildStandardTableFieldDescriptors(FieldDescriptor[] fieldDescriptors, TableDescriptor tableDescriptor) {
        if (fieldDescriptors != null) {
            for (int i = 0; i < fieldDescriptors.length; ++i) {
                tableDescriptor.addColumn(fieldDescriptors[i]);
            }
        }
    }
}

