/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;

public class CommonsLoggerImpl
implements Logger {
    private String name;
    private transient Log log;

    public CommonsLoggerImpl(String aName) {
        this.name = aName;
        this.log = LogFactory.getLog((String)aName);
    }

    public void debug(Object pObject) {
        this.getLog().debug(pObject);
    }

    public void info(Object pObject) {
        this.getLog().info(pObject);
    }

    public void warn(Object pObject) {
        this.getLog().warn(pObject);
    }

    public void error(Object pObject) {
        this.getLog().error(pObject);
    }

    public void fatal(Object pObject) {
        this.getLog().fatal(pObject);
    }

    public void debug(Object message, Throwable obj) {
        this.getLog().debug(message, obj);
    }

    public void info(Object message, Throwable obj) {
        this.getLog().info(message, obj);
    }

    public void warn(Object message, Throwable obj) {
        this.getLog().warn(message, obj);
    }

    public void error(Object message, Throwable obj) {
        this.getLog().error(message, obj);
    }

    public void fatal(Object message, Throwable obj) {
        this.getLog().fatal(message, obj);
    }

    public boolean isEnabledFor(int priority) {
        return false;
    }

    public boolean isDebugEnabled() {
        return this.getLog().isDebugEnabled();
    }

    public String getName() {
        return this.name;
    }

    public void safeDebug(String message, Object obj) {
        if (this.getLog().isDebugEnabled()) {
            String toString = this.safeToString(obj);
            this.getLog().debug((Object)(message + " : " + toString));
        }
    }

    public void safeDebug(String message, Object obj, Throwable t) {
        if (this.getLog().isDebugEnabled()) {
            String toString = this.safeToString(obj);
            this.getLog().debug((Object)(message + " : " + toString), t);
        }
    }

    public void safeInfo(String message, Object obj) {
        if (this.getLog().isInfoEnabled()) {
            String toString = this.safeToString(obj);
            this.getLog().info((Object)(message + " : " + toString));
        }
    }

    public void safeInfo(String message, Object obj, Throwable t) {
        if (this.getLog().isInfoEnabled()) {
            String toString = this.safeToString(obj);
            this.getLog().info((Object)(message + " : " + toString), t);
        }
    }

    public void safeWarn(String message, Object obj) {
        if (this.getLog().isWarnEnabled()) {
            String toString = this.safeToString(obj);
            this.getLog().warn((Object)(message + " : " + toString));
        }
    }

    public void safeWarn(String message, Object obj, Throwable t) {
        if (this.getLog().isWarnEnabled()) {
            String toString = this.safeToString(obj);
            this.getLog().warn((Object)(message + " : " + toString), t);
        }
    }

    public void safeError(String message, Object obj) {
        if (this.getLog().isErrorEnabled()) {
            String toString = this.safeToString(obj);
            this.getLog().error((Object)(message + " : " + toString));
        }
    }

    public void safeError(String message, Object obj, Throwable t) {
        if (this.getLog().isErrorEnabled()) {
            String toString = this.safeToString(obj);
            this.getLog().error((Object)(message + " : " + toString), t);
        }
    }

    public void safeFatal(String message, Object obj) {
        if (this.getLog().isFatalEnabled()) {
            String toString = this.safeToString(obj);
            this.getLog().fatal((Object)(message + " : " + toString));
        }
    }

    public void safeFatal(String message, Object obj, Throwable t) {
        if (this.getLog().isFatalEnabled()) {
            String toString = this.safeToString(obj);
            this.getLog().fatal((Object)(message + " : " + toString), t);
        }
    }

    private String safeToString(Object obj) {
        String toString = null;
        if (obj != null) {
            try {
                toString = obj.toString();
            }
            catch (Throwable ex) {
                toString = "BAD toString() impl for " + obj.getClass().getName();
            }
        }
        return toString;
    }

    public void configure(Configuration config) throws ConfigurationException {
    }

    public Log getLog() {
        return this.log;
    }
}

