/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.ObjectModificationDefaultImpl;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.HighLowSequence;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public class SequenceManagerHighLowImpl
extends AbstractSequenceManager {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl = SequenceManagerHighLowImpl.class$("org.apache.ojb.broker.util.sequence.SequenceManagerHighLowImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl);
    private static final String GLOBAL_SEQUENCE_NAME = "global - default sequence name";
    public static final String PROPERTY_GRAB_SIZE = "grabSize";
    public static final String PROPERTY_GLOBAL_SEQUENCE_ID = "globalSequenceId";
    public static final String PROPERTY_GLOBAL_SEQUENCE_START = "globalSequenceStart";
    private static final String DEPRECATED_COLUMN = "deprecatedColumn";
    private static final String PK_FIELD = "tableName";
    protected static Map sequencesMap = new HashMap();
    protected boolean useGlobalSequenceIdentities;
    protected int grabSize = Integer.parseInt(this.getConfigurationProperty("grabSize", "20"));
    protected long globalSequenceStart;
    protected int attempts;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$HighLowSequence;

    public SequenceManagerHighLowImpl(PersistenceBroker broker) {
        super(broker);
        this.useGlobalSequenceIdentities = Boolean.valueOf(this.getConfigurationProperty(PROPERTY_GLOBAL_SEQUENCE_ID, "false"));
        this.globalSequenceStart = Long.parseLong(this.getConfigurationProperty(PROPERTY_GLOBAL_SEQUENCE_START, "10000"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getUniqueLong(FieldDescriptor field) throws SequenceManagerException {
        String sequenceName = this.buildSequenceName(field);
        Map map = sequencesMap;
        synchronized (map) {
            long id;
            HighLowSequence seq = (HighLowSequence)sequencesMap.get(sequenceName);
            if (seq == null) {
                seq = this.getSequence(this.getBrokerForClass(), field, sequenceName);
                sequencesMap.put(sequenceName, seq);
            }
            if ((id = seq.getNextId()) == 0L) {
                seq = this.getSequence(this.getBrokerForClass(), field, sequenceName);
                sequencesMap.put(sequenceName, seq);
                id = seq.getNextId();
                if (id == 0L) {
                    sequencesMap.remove(sequenceName);
                    throw new SequenceManagerException("Sequence generation failed: " + SystemUtils.LINE_SEPARATOR + "Sequence: " + seq + ". Unable to build new ID, id was always 0." + SystemUtils.LINE_SEPARATOR + "Thread: " + Thread.currentThread() + SystemUtils.LINE_SEPARATOR + "PB: " + this.getBrokerForClass());
                }
            }
            return id;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HighLowSequence getSequence(PersistenceBroker brokerForSequence, FieldDescriptor field, String sequenceName) throws SequenceManagerException {
        HighLowSequence newSequence = null;
        PersistenceBroker internBroker = null;
        try {
            try {
                internBroker = PersistenceBrokerFactory.createPersistenceBroker(brokerForSequence.getPBKey());
                internBroker.beginTransaction();
                newSequence = this.lookupStoreSequence(internBroker, field, sequenceName);
                internBroker.commitTransaction();
                if (log.isDebugEnabled()) {
                    log.debug("new sequence was " + newSequence);
                }
            }
            catch (Exception e) {
                log.error("Can't lookup new HighLowSequence for field " + (field != null ? field.getAttributeName() : null) + " using sequence name " + sequenceName, e);
                if (internBroker == null) throw new SequenceManagerException("Can't build new sequence", e);
                if (!internBroker.isInTransaction()) throw new SequenceManagerException("Can't build new sequence", e);
                internBroker.abortTransaction();
                throw new SequenceManagerException("Can't build new sequence", e);
            }
            Object var8_6 = null;
            this.attempts = 0;
            if (internBroker == null) return newSequence;
            internBroker.close();
            return newSequence;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.attempts = 0;
            if (internBroker == null) throw throwable;
            internBroker.close();
            throw throwable;
        }
    }

    protected HighLowSequence lookupStoreSequence(PersistenceBroker broker, FieldDescriptor field, String seqName) {
        HighLowSequence newSequence = null;
        boolean needsInsert = false;
        Criteria c = new Criteria();
        c.addEqualTo(PK_FIELD, seqName);
        QueryByCriteria q = new QueryByCriteria(class$org$apache$ojb$broker$util$sequence$HighLowSequence == null ? (class$org$apache$ojb$broker$util$sequence$HighLowSequence = SequenceManagerHighLowImpl.class$("org.apache.ojb.broker.util.sequence.HighLowSequence")) : class$org$apache$ojb$broker$util$sequence$HighLowSequence, c);
        newSequence = (HighLowSequence)broker.getObjectByQuery(q);
        if (newSequence == null) {
            if (log.isDebugEnabled()) {
                log.debug("sequence for field " + field + " not found in db, store new HighLowSequence");
            }
            long maxKey = this.getMaxKeyForSequence(this.getBrokerForClass(), field);
            newSequence = this.newSequenceObject(seqName, field);
            newSequence.setMaxKey(maxKey);
            needsInsert = true;
        }
        newSequence.setGrabSize(this.grabSize);
        newSequence.grabNextKeySet();
        try {
            if (needsInsert) {
                broker.store(newSequence, ObjectModificationDefaultImpl.INSERT);
            } else {
                broker.store(newSequence, ObjectModificationDefaultImpl.UPDATE);
            }
        }
        catch (OptimisticLockException e) {
            if (this.attempts < 5) {
                log.info("OptimisticLockException was thrown, will try again to store sequence. Sequence was " + newSequence);
                ++this.attempts;
                newSequence = this.lookupStoreSequence(broker, field, seqName);
            }
            throw e;
        }
        return newSequence;
    }

    protected HighLowSequence newSequenceObject(String sequenceName, FieldDescriptor field) {
        HighLowSequence seq = new HighLowSequence();
        seq.setTableName(sequenceName);
        seq.setFieldName(DEPRECATED_COLUMN);
        seq.setGrabSize(this.grabSize);
        return seq;
    }

    protected long getMaxKeyForSequence(PersistenceBroker broker, FieldDescriptor field) {
        long maxKey = 0L;
        maxKey = this.useGlobalSequenceIdentities ? this.globalSequenceStart : SequenceManagerHelper.getMaxForExtent(broker, field);
        return maxKey;
    }

    private String buildSequenceName(FieldDescriptor field) throws SequenceManagerException {
        String seqName = null;
        seqName = this.useGlobalSequenceIdentities ? GLOBAL_SEQUENCE_NAME : this.calculateSequenceName(field);
        return seqName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

