/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class SequenceManagerNextValImpl
extends AbstractSequenceManager {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$util$sequence$SequenceManagerNextValImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerNextValImpl = SequenceManagerNextValImpl.class$("org.apache.ojb.broker.util.sequence.SequenceManagerNextValImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerNextValImpl);
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerNextValImpl;

    public SequenceManagerNextValImpl(PersistenceBroker broker) {
        super(broker);
    }

    protected int getUniqueId(FieldDescriptor field) throws SequenceManagerException {
        return (int)this.getUniqueLong(field);
    }

    protected long getUniqueLong(FieldDescriptor field) throws SequenceManagerException {
        long result = 0L;
        String sequenceName = this.calculateSequenceName(field);
        try {
            result = this.buildNextSequence(field.getClassDescriptor(), sequenceName);
        }
        catch (Throwable e) {
            try {
                this.log.info("Create DB sequence key '" + sequenceName + "'");
                this.createSequence(field.getClassDescriptor(), sequenceName);
            }
            catch (Exception e1) {
                throw new SequenceManagerException(SystemUtils.LINE_SEPARATOR + "Could not grab next id, failed with " + SystemUtils.LINE_SEPARATOR + e.getMessage() + SystemUtils.LINE_SEPARATOR + "Creation of new sequence failed with " + SystemUtils.LINE_SEPARATOR + e1.getMessage() + SystemUtils.LINE_SEPARATOR, e1);
            }
            try {
                result = this.buildNextSequence(field.getClassDescriptor(), sequenceName);
            }
            catch (Throwable e1) {
                throw new SequenceManagerException("Could not grab next id, sequence seems to exist", e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long buildNextSequence(ClassDescriptor cld, String sequenceName) throws Exception {
        ResultSet rs = null;
        Statement stmt = null;
        long result = -1L;
        StatementManagerIF stmtMan = this.getBrokerForClass().serviceStatementManager();
        try {
            stmt = stmtMan.getGenericStatement(cld, false);
            rs = stmt.executeQuery(this.getPlatform().nextSequenceQuery(sequenceName));
            rs.next();
            result = rs.getLong(1);
            stmtMan.closeResources(stmt, rs);
        }
        catch (Throwable throwable) {
            stmtMan.closeResources(stmt, rs);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSequence(ClassDescriptor cld, String sequenceName) throws Exception {
        Statement stmt = null;
        StatementManagerIF stmtMan = this.getBrokerForClass().serviceStatementManager();
        try {
            stmt = stmtMan.getGenericStatement(cld, false);
            stmt.execute(this.getPlatform().createSequenceQuery(sequenceName));
        }
        finally {
            try {
                stmtMan.closeResources(stmt, null);
            }
            catch (Exception ignore) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

