/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo.jdoql;

import java.util.Iterator;
import java.util.List;
import org.apache.ojb.jdo.jdoql.Expression;
import org.apache.ojb.jdo.jdoql.PostfixExpression;
import org.apache.ojb.jdo.jdoql.Visitor;

public class MethodInvocation
extends PostfixExpression {
    private String _name;
    private List _args;
    private Class _returnType;

    public MethodInvocation(Expression base, String methodName, List args) {
        super(base);
        this._name = methodName;
        this._args = args;
        Iterator it = args.iterator();
        while (it.hasNext()) {
            ((Expression)it.next()).setParent(this);
        }
    }

    public boolean hasBaseExpression() {
        return this._base != null;
    }

    public Expression getBaseExpression() {
        return this._base;
    }

    public void setBaseExpression(Expression base) {
        this._base = base;
    }

    public void replaceChild(Expression oldChild, Expression newChild) {
        if (oldChild == this._base) {
            this._base.setParent(null);
            this._base = newChild;
            this._base.setParent(this);
        } else {
            for (int idx = 0; idx < this._args.size(); ++idx) {
                Expression expr = (Expression)this._args.get(idx);
                if (expr != oldChild) continue;
                expr.setParent(null);
                newChild.setParent(this);
                this._args.set(idx, newChild);
                break;
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public List getArguments() {
        return this._args;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this._base != null) {
            result.append(this._base.toString());
            result.append(".");
        }
        result.append(this._name);
        result.append("(");
        Iterator it = this._args.iterator();
        while (it.hasNext()) {
            result.append(it.next().toString());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append(")");
        return result.toString();
    }

    public void setType(Class type) {
        this._returnType = type;
    }

    public Class getType() {
        return this._returnType;
    }
}

