/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.List;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.Configurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.DatabaseImpl;
import org.apache.ojb.odmg.OJBTxManager;
import org.apache.ojb.odmg.TransactionExt;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DCollectionFactory;
import org.apache.ojb.odmg.oql.EnhancedOQLQuery;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DArray;
import org.odmg.DBag;
import org.odmg.DList;
import org.odmg.DMap;
import org.odmg.DSet;
import org.odmg.Database;
import org.odmg.DatabaseClosedException;
import org.odmg.Implementation;
import org.odmg.ODMGRuntimeException;
import org.odmg.Transaction;

public class ImplementationImpl
implements Implementation {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$ImplementationImpl == null ? (class$org$apache$ojb$odmg$ImplementationImpl = ImplementationImpl.class$("org.apache.ojb.odmg.ImplementationImpl")) : class$org$apache$ojb$odmg$ImplementationImpl);
    private List usedDatabases = new ArrayList();
    private DatabaseImpl currentDatabase;
    private Configurator configurator;
    private OJBTxManager ojbTxManager = TxManagerFactory.instance();
    static /* synthetic */ Class class$org$apache$ojb$odmg$ImplementationImpl;

    protected ImplementationImpl() {
        this.setConfigurator(PersistenceBrokerFactory.getConfigurator());
    }

    protected synchronized void setCurrentDatabase(DatabaseImpl curDB) {
        this.currentDatabase = curDB;
    }

    public DatabaseImpl getCurrentDatabase() {
        return this.currentDatabase;
    }

    public PBKey getCurrentPBKey() {
        return this.currentDatabase.getPBKey();
    }

    public Configurator getConfigurator() {
        return this.configurator;
    }

    public void setConfigurator(Configurator configurator) {
        this.configurator = configurator;
    }

    public Transaction newTransaction() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, must have a DB in order to create a transaction");
        }
        TransactionImpl tx = new TransactionImpl(this.getCurrentDatabase());
        try {
            this.getConfigurator().configure(tx);
        }
        catch (ConfigurationException e) {
            throw new ODMGRuntimeException("Error in configuration of TransactionImpl instance: " + e.getMessage());
        }
        return tx;
    }

    public Transaction currentTransaction() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, must have a DB in order to create a transaction");
        }
        return this.ojbTxManager.getTransaction();
    }

    public boolean hasOpenTransaction() {
        TransactionImpl tx = this.ojbTxManager.getTransaction();
        return tx != null ? tx.isOpen() : false;
    }

    public Database newDatabase() {
        return new DatabaseImpl(this);
    }

    public EnhancedOQLQuery newOQLQuery() {
        if (this.getCurrentDatabase() == null || !this.getCurrentDatabase().isOpen()) {
            throw new DatabaseClosedException("Database is not open");
        }
        OQLQueryImpl query = new OQLQueryImpl(this.getCurrentPBKey());
        try {
            this.getConfigurator().configure(query);
        }
        catch (ConfigurationException e) {
            throw new ODMGRuntimeException("Error in configuration of OQLQueryImpl instance: " + e.getMessage());
        }
        return query;
    }

    public DList newDList() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DList with a null database.");
        }
        return DCollectionFactory.getInstance().createDList(this.getCurrentPBKey());
    }

    public DBag newDBag() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DBag with a null database.");
        }
        return DCollectionFactory.getInstance().createDBag(this.getCurrentPBKey());
    }

    public DSet newDSet() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DSet with a null database.");
        }
        return DCollectionFactory.getInstance().createDSet(this.getCurrentPBKey());
    }

    public DArray newDArray() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DArray with a null database.");
        }
        return DCollectionFactory.getInstance().createDArray(this.getCurrentPBKey());
    }

    public DMap newDMap() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DMap with a null database.");
        }
        return DCollectionFactory.getInstance().createDMap(this.getCurrentPBKey());
    }

    public String getObjectId(Object obj) {
        Identity oid = null;
        PersistenceBroker broker = this.getCurrentDatabase() != null ? PersistenceBrokerFactory.createPersistenceBroker(this.getCurrentDatabase().getPBKey()) : PersistenceBrokerFactory.defaultPersistenceBroker();
        oid = new Identity(obj, broker);
        return new String(oid.serialize());
    }

    public Database getDatabase(Object obj) {
        return this.getCurrentDatabase();
    }

    protected synchronized void registerOpenDatabase(DatabaseImpl newDB) {
        DatabaseImpl old_db = this.getCurrentDatabase();
        if (old_db != null) {
            try {
                if (old_db.isOpen()) {
                    this.log.warn("## There is still an opened database, close old one ##");
                    old_db.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Set current database " + newDB + " PBKey was " + newDB.getPBKey());
        }
        this.setCurrentDatabase(newDB);
        this.usedDatabases.add(newDB.getPBKey());
    }

    public void setImplicitLocking(boolean value) {
        ((TransactionExt)this.currentTransaction()).setImplicitLocking(value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

